/*
 * Decompiled with CFR 0.152.
 */
package us.springett.threatmodeling.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import us.springett.threatmodeling.model.Asset;
import us.springett.threatmodeling.model.DataFlow;
import us.springett.threatmodeling.model.EntryPoint;
import us.springett.threatmodeling.model.ExternalDependency;
import us.springett.threatmodeling.model.Threat;

public class ThreatModel {
    private String id;
    private String name;
    private String description;
    private String assumptions;
    private String contributors;
    private String owner;
    private String reviewer;
    private List<ExternalDependency> externalDependencies;
    private List<EntryPoint> entryPoints;
    private List<Asset> assets;
    private List<Threat> threats;
    private Object nativeThreatModel;
    private List<DataFlow> dataFlows;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ThreatModel id(String id) {
        this.setId(id);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ThreatModel name(String name) {
        this.setName(name);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ThreatModel description(String description) {
        this.setDescription(description);
        return this;
    }

    public String getAssumptions() {
        return this.assumptions;
    }

    public void setAssumptions(String assumptions) {
        this.assumptions = assumptions;
    }

    public ThreatModel assumptions(String assumptions) {
        this.setAssumptions(assumptions);
        return this;
    }

    public String getContributors() {
        return this.contributors;
    }

    public void setContributors(String contributors) {
        this.contributors = contributors;
    }

    public ThreatModel contributors(String contributors) {
        this.setContributors(contributors);
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ThreatModel owner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public String getReviewer() {
        return this.reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public ThreatModel reviewer(String reviewer) {
        this.setReviewer(reviewer);
        return this;
    }

    public List<ExternalDependency> getExternalDependencies() {
        return this.externalDependencies;
    }

    public void setExternalDependencies(List<ExternalDependency> externalDependencies) {
        this.externalDependencies = externalDependencies;
    }

    public ThreatModel externalDependencies(List<ExternalDependency> externalDependencies) {
        this.setExternalDependencies(externalDependencies);
        return this;
    }

    public List<EntryPoint> getEntryPoints() {
        return this.entryPoints;
    }

    public void setEntryPoints(List<EntryPoint> entryPoints) {
        this.entryPoints = entryPoints;
    }

    public ThreatModel entryPoints(List<EntryPoint> entryPoints) {
        this.setEntryPoints(entryPoints);
        return this;
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public Set<Asset> getAssetsReferencedByThreats() {
        if (this.threats == null || this.threats.size() == 0) {
            return new HashSet<Asset>();
        }
        HashSet<Asset> assetsReferencedByThreats = new HashSet<Asset>();
        for (Threat threat : this.threats) {
            assetsReferencedByThreats.addAll(threat.getAssets());
        }
        return assetsReferencedByThreats;
    }

    public void setAssets(List<Asset> assets) {
        this.assets = assets;
    }

    public ThreatModel assets(List<Asset> assets) {
        this.setAssets(assets);
        return this;
    }

    public List<Threat> getThreats() {
        return this.threats;
    }

    public void setThreats(List<Threat> threats) {
        this.threats = threats;
    }

    public ThreatModel threats(List<Threat> threats) {
        this.setThreats(threats);
        return this;
    }

    public Object getNativeThreatModel() {
        return this.nativeThreatModel;
    }

    public void setNativeThreatModel(Object nativeThreatModel) {
        this.nativeThreatModel = nativeThreatModel;
    }

    public ThreatModel nativeThreatModel(Object nativeThreatModel) {
        this.setNativeThreatModel(nativeThreatModel);
        return this;
    }

    public List<DataFlow> getDataFlows() {
        return this.dataFlows;
    }

    public void setDataFlows(List<DataFlow> dataFlows) {
        this.dataFlows = dataFlows;
    }

    public ThreatModel dataFlows(List<DataFlow> dataFlows) {
        this.setDataFlows(dataFlows);
        return this;
    }
}

