/*
 * Decompiled with CFR 0.152.
 */
package us.springett.threatmodeling.tools.mstmt2016;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import us.springett.threatmodeling.IParser;
import us.springett.threatmodeling.exception.ParseException;
import us.springett.threatmodeling.model.Asset;
import us.springett.threatmodeling.model.DataFlow;
import us.springett.threatmodeling.model.Threat;
import us.springett.threatmodeling.tools.mstmt2016.model.ThreatInstance;
import us.springett.threatmodeling.tools.mstmt2016.model.ThreatModel;
import us.springett.threatmodeling.tools.mstmt2016.model.ThreatType;
import us.springett.threatmodeling.tools.mstmt2016.util.ParseUtil;

public final class Parser
implements IParser {
    @Override
    public us.springett.threatmodeling.model.ThreatModel parse(File file) throws ParseException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ThreatModel.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = xif.createXMLStreamReader(new StreamSource(file.getAbsolutePath()));
            ThreatModel nativeModel = (ThreatModel)unmarshaller.unmarshal(xsr);
            us.springett.threatmodeling.model.ThreatModel threatModel = new us.springett.threatmodeling.model.ThreatModel();
            threatModel.setNativeThreatModel(nativeModel);
            List<Asset> assets = ParseUtil.lookupAssets(nativeModel);
            List<DataFlow> dataFlows = ParseUtil.lookupDataFlows(nativeModel);
            threatModel.assumptions(nativeModel.getMetaInformation().getAssumptions()).contributors(nativeModel.getMetaInformation().getContributors()).description(nativeModel.getMetaInformation().getHighLevelSystemDescription()).name(nativeModel.getMetaInformation().getThreatModelName()).owner(nativeModel.getMetaInformation().getOwner()).reviewer(nativeModel.getMetaInformation().getReviewer()).assets(assets).dataFlows(dataFlows);
            ArrayList<Threat> threats = new ArrayList<Threat>();
            List<HashMap<String, ThreatInstance>> threatList = nativeModel.getKeyValueThreatMap();
            for (HashMap<String, ThreatInstance> threatMap : threatList) {
                for (Map.Entry<String, ThreatInstance> threatEntry : threatMap.entrySet()) {
                    ThreatInstance ti = threatEntry.getValue();
                    ThreatType threatType = ParseUtil.lookupThreatType(nativeModel, ti);
                    Threat threat = new Threat().id(ti.getId()).name(ParseUtil.lookupPropertyValueByKey(ti, "Title")).description(ParseUtil.lookupPropertyValueByKey(ti, "UserThreatDescription")).justification(ParseUtil.lookupPropertyValueByKey(ti, "StateInformation")).threatClassification(ParseUtil.lookupClassification(threatType)).risk(ParseUtil.lookupRisk(ti)).state(ParseUtil.lookupState(ti)).dataFlow(ParseUtil.lookupAssociatedDataFlows(assets, dataFlows, ti)).assets(ParseUtil.lookupTargetAsset(assets, ti));
                    threats.add(threat);
                }
                threatModel.setThreats(threats);
            }
            return threatModel;
        }
        catch (JAXBException | XMLStreamException e) {
            throw new ParseException(e);
        }
    }
}

