/*
 * Decompiled with CFR 0.152.
 */
package us.springett.threatmodeling.tools.mstmt2016.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.springett.threatmodeling.model.Asset;
import us.springett.threatmodeling.model.DataFlow;
import us.springett.threatmodeling.model.Risk;
import us.springett.threatmodeling.model.Stride;
import us.springett.threatmodeling.model.ThreatState;
import us.springett.threatmodeling.tools.mstmt2016.model.Border;
import us.springett.threatmodeling.tools.mstmt2016.model.DrawingSurfaceList;
import us.springett.threatmodeling.tools.mstmt2016.model.DrawingSurfaceModel;
import us.springett.threatmodeling.tools.mstmt2016.model.Line;
import us.springett.threatmodeling.tools.mstmt2016.model.ThreatInstance;
import us.springett.threatmodeling.tools.mstmt2016.model.ThreatModel;
import us.springett.threatmodeling.tools.mstmt2016.model.ThreatType;

public class ParseUtil {
    public static ThreatType lookupThreatType(ThreatModel nativeModel, ThreatInstance threatInstance) {
        if (threatInstance.getTypeId() == null) {
            return null;
        }
        for (ThreatType threatType : nativeModel.getKnowledgeBase().getThreatTypes()) {
            if (!threatType.getId().equals(threatInstance.getTypeId())) continue;
            return threatType;
        }
        return null;
    }

    public static Stride lookupClassification(ThreatType threatType) {
        if (threatType == null) {
            return null;
        }
        switch (threatType.getCategory()) {
            case "S": {
                return Stride.SPOOFING;
            }
            case "T": {
                return Stride.TAMPERING;
            }
            case "R": {
                return Stride.REPUDIATION;
            }
            case "I": {
                return Stride.INFORMATION_DISCLOSURE;
            }
            case "D": {
                return Stride.DENIAL_OF_SERVICE;
            }
            case "E": {
                return Stride.ELEVATION_OF_PRIVILEGE;
            }
            case "A": {
                return Stride.ABUSE;
            }
        }
        return null;
    }

    public static Risk lookupRisk(ThreatInstance threatInstance) {
        switch (threatInstance.getPriority()) {
            case "Critical": {
                return Risk.CRITICAL;
            }
            case "High": {
                return Risk.HIGH;
            }
            case "Medium": {
                return Risk.MEDIUM;
            }
            case "Low": {
                return Risk.LOW;
            }
        }
        return null;
    }

    public static String lookupPropertyValueByKey(ThreatInstance threatInstance, String key) {
        for (Map<String, String> map : threatInstance.getProperties()) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }

    public static List<Asset> lookupAssets(ThreatModel threatModel) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        DrawingSurfaceList dsl = threatModel.getDrawingSurfaceList();
        if (dsl == null) {
            return assets;
        }
        DrawingSurfaceModel dsm = dsl.getDrawingSurfaceModel();
        if (dsm == null) {
            return assets;
        }
        for (Border border : dsm.getBorders()) {
            Asset asset = new Asset();
            asset.setId(border.getKey());
            if (border.getValue() != null && border.getValue().getAnyTypes() != null) {
                for (Border.AnyType anytype : border.getValue().getAnyTypes()) {
                    if (anytype.getDisplayName() != null && anytype.getDisplayName().equals("Name")) {
                        asset.setName(anytype.getValue().trim());
                        continue;
                    }
                    if (anytype.getDisplayName() == null || !anytype.getDisplayName().equals("Out Of Scope")) continue;
                    asset.setOutOfScope(Boolean.parseBoolean(anytype.getValue()));
                }
            }
            assets.add(asset);
        }
        return assets;
    }

    public static Map<String, Asset> mapAssetsByIds(List<Asset> assets) {
        HashMap<String, Asset> idAssetMap = new HashMap<String, Asset>();
        for (Asset asset : assets) {
            idAssetMap.put(asset.getId(), asset);
        }
        return idAssetMap;
    }

    public static Map<String, DataFlow> mapDataflowsByIds(List<DataFlow> dataFlows) {
        HashMap<String, DataFlow> idDataFlowMap = new HashMap<String, DataFlow>();
        for (DataFlow asset : dataFlows) {
            idDataFlowMap.put(asset.getId(), asset);
        }
        return idDataFlowMap;
    }

    public static List<Asset> lookupTargetAsset(List<Asset> assets, ThreatInstance ti) {
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        assetList.add(ParseUtil.mapAssetsByIds(assets).get(ti.getTargetGuid()));
        return assetList;
    }

    public static ThreatState lookupState(ThreatInstance ti) {
        ThreatState state;
        try {
            state = ThreatState.fromString(ti.getState());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid threat state: [" + ti.getState() + "]");
        }
        return state;
    }

    public static List<DataFlow> lookupDataFlows(ThreatModel nativeModel) {
        ArrayList<DataFlow> dataFlows = new ArrayList<DataFlow>();
        for (Line line : nativeModel.getDrawingSurfaceList().getDrawingSurfaceModel().getLines()) {
            dataFlows.add(new DataFlow(line.getKey(), line.getValue().getAnyTypes().get(0).getDisplayName()));
        }
        return dataFlows;
    }

    public static DataFlow lookupAssociatedDataFlows(List<Asset> assets, List<DataFlow> dataFlows, ThreatInstance ti) {
        String[] interactionKey = ti.getInteractionKey().trim().split(":");
        String sourceId = interactionKey[0];
        String dataFlowId = interactionKey[1];
        String targetId = interactionKey[2];
        Map<String, Asset> idToAssetMap = ParseUtil.mapAssetsByIds(assets);
        DataFlow dataFlow = ParseUtil.mapDataflowsByIds(dataFlows).get(dataFlowId);
        dataFlow.setSource(idToAssetMap.get(sourceId));
        dataFlow.setDestination(idToAssetMap.get(targetId));
        return dataFlow;
    }
}

