/*
 * Decompiled with CFR 0.152.
 */
package us.springett.vulndbdatamirror;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import us.springett.vulndbdatamirror.client.VulnDbApi;
import us.springett.vulndbdatamirror.parser.model.Results;
import us.springett.vulndbdatamirror.parser.model.Status;

public class VulnDbDataMirror {
    private static final String UPDATE_PROP = "update.properties";
    private final Properties properties = new Properties();
    private File propertyFile;
    private final String consumerKey;
    private final String consumerSecret;
    private final File outputDir;
    private boolean downloadFailed = false;

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("stat", "status-only", false, "Displays VulnDB API status only");
        options.addOption("vend", "mirror-vendors", false, "Mirror the vendors data feed");
        options.addOption("prod", "mirror-products", false, "Mirror the products data feed");
        options.addOption("vuln", "mirror-vulnerabilities", false, "Mirror the vulnerabilities data feed");
        options.addOption(Option.builder().longOpt("consumer-key").desc("The Consumer Key provided by VulnDB").hasArg().required().argName("key").build());
        options.addOption(Option.builder().longOpt("consumer-secret").desc("The Consumer Secret provided by VulnDB").hasArg().required().argName("secret").build());
        options.addOption(Option.builder().longOpt("dir").desc("The target directory to store contents").hasArg().argName("dir").build());
        try {
            CommandLine line = parser.parse(options, args);
            VulnDbDataMirror mirror = new VulnDbDataMirror(line.getOptionValue("consumer-key"), line.getOptionValue("consumer-secret"), line.getOptionValue("dir", System.getProperty("user.dir")));
            mirror.getApiStatus();
            if (line.hasOption("status-only")) {
                return;
            }
            if (line.hasOption("mirror-vendors")) {
                mirror.mirrorVendors();
            }
            if (line.hasOption("mirror-products")) {
                mirror.mirrorProducts();
            }
            if (line.hasOption("mirror-vulnerabilities")) {
                mirror.mirrorVulnerabilities();
            }
            if (!(line.hasOption("mirror-vendors") && line.hasOption("mirror-products") && line.hasOption("mirror-vulnerabilities"))) {
                System.out.println("A feed to mirror was not specified. Defaulting to mirror all feeds.");
                mirror.mirrorVendors();
                mirror.mirrorProducts();
                mirror.mirrorVulnerabilities();
            }
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("vulndb-data-mirror", options);
        }
    }

    private VulnDbDataMirror(String consumerKey, String consumerSecret, String outputDirPath) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.outputDir = new File(outputDirPath);
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        this.initPropertyFile();
    }

    private void initPropertyFile() {
        this.propertyFile = new File(this.outputDir, UPDATE_PROP);
        if (!this.propertyFile.exists()) {
            try {
                this.propertyFile.createNewFile();
            }
            catch (IOException e) {
                System.err.println("Unable to create update.properties in " + this.outputDir.getAbsolutePath());
            }
        }
        if (this.propertyFile != null) {
            this.readProperties();
        }
    }

    private void getApiStatus() throws Exception {
        VulnDbApi api = new VulnDbApi(this.consumerKey, this.consumerSecret);
        System.out.print("\nVulnDB API Status:\n");
        System.out.println(StringUtils.repeat((String)"-", (int)80));
        Status status = api.getStatus();
        System.out.println("Organization Name.............: " + status.getOrganizationName());
        System.out.println("Name of User Requesting.......: " + status.getUserNameRequesting());
        System.out.println("Email of User Requesting......: " + status.getUserEmailRequesting());
        System.out.println("Subscription Expiration Date..: " + status.getSubscriptionEndDate());
        System.out.println("API Calls Allowed per Month...: " + status.getApiCallsAllowedPerMonth());
        System.out.println("API Calls Made This Month.....: " + status.getApiCallsMadeThisMonth());
        System.out.println(StringUtils.repeat((String)"-", (int)80));
    }

    private void mirrorVendors() throws Exception {
        VulnDbApi api = new VulnDbApi(this.consumerKey, this.consumerSecret);
        System.out.print("\nMirroring Vendors feed...\n");
        int page = this.lastSuccessfulPage("vendors");
        boolean more = true;
        while (more) {
            Results results = api.getVendors(100, page);
            if (results.isSuccessful()) {
                more = this.processResults(this.outputDir, VulnDbApi.Type.VENDORS, results);
                ++page;
                continue;
            }
            System.exit(1);
        }
        if (this.downloadFailed) {
            System.exit(1);
        }
    }

    private void mirrorProducts() throws Exception {
        VulnDbApi api = new VulnDbApi(this.consumerKey, this.consumerSecret);
        System.out.print("\nMirroring Products feed...\n");
        int page = this.lastSuccessfulPage("products");
        boolean more = true;
        while (more) {
            Results results = api.getProducts(100, page);
            if (results.isSuccessful()) {
                more = this.processResults(this.outputDir, VulnDbApi.Type.PRODUCTS, results);
                ++page;
                continue;
            }
            System.exit(1);
        }
        if (this.downloadFailed) {
            System.exit(1);
        }
    }

    private void mirrorVulnerabilities() throws Exception {
        VulnDbApi api = new VulnDbApi(this.consumerKey, this.consumerSecret);
        System.out.print("\nMirroring Vulnerabilities feed...\n");
        int page = this.lastSuccessfulPage("vulnerabilities");
        boolean more = true;
        while (more) {
            Results results = api.getVulnerabilities(100, page);
            if (results.isSuccessful()) {
                more = this.processResults(this.outputDir, VulnDbApi.Type.VULNERABILITIES, results);
                ++page;
                continue;
            }
            System.exit(1);
        }
        if (this.downloadFailed) {
            System.exit(1);
        }
    }

    private int lastSuccessfulPage(String prefix) {
        return Integer.parseInt(this.properties.getProperty(prefix + ".last_success_page", "1"));
    }

    private void storeSuccessfulPage(VulnDbApi.Type type, int page) {
        String prefix = type.name().toLowerCase();
        this.properties.setProperty(prefix + ".last_success_page", String.valueOf(page));
        this.properties.setProperty(prefix + ".last_success_timestamp", String.valueOf(new Date().getTime()));
        this.writeProperties();
    }

    private boolean processResults(File dir, VulnDbApi.Type type, Results results) throws Exception {
        try {
            FileUtils.writeStringToFile((File)new File(dir, type.name().toLowerCase() + "_" + results.getPage() + ".json"), (String)results.getRawResults(), (String)"UTF-8");
            this.storeSuccessfulPage(type, results.getPage());
        }
        catch (IOException ex) {
            System.err.println("Error writing VulnDB output to file");
            System.err.println(ex.getMessage());
        }
        this.logProgress(results.getPage() * 100, results.getTotal());
        return results.getPage() * 100 < results.getTotal();
    }

    private void logProgress(int currentResults, int totalResults) throws Exception {
        if (currentResults > totalResults) {
            currentResults = totalResults;
        }
        String data = "\rProcessing " + currentResults + " of " + totalResults + " results";
        System.out.write(data.getBytes());
    }

    private void readProperties() {
        try (FileInputStream in = new FileInputStream(this.propertyFile);){
            this.properties.load(in);
        }
        catch (IOException e) {
            System.err.println("Unable to read update.properties");
            System.err.println(e.getMessage());
        }
    }

    private void writeProperties() {
        try (FileOutputStream os = new FileOutputStream(this.propertyFile);){
            this.properties.store(os, "Automatically generated from vulndb-data-mirror. Do not modify.");
        }
        catch (IOException e) {
            System.err.println("Unable to write to update.properties");
            System.err.println(e.getMessage());
        }
    }
}

