/*
 * Decompiled with CFR 0.152.
 */
package us.springett.vulndbdatamirror.parser;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kong.unirest.JsonNode;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.vulndbdatamirror.parser.model.ApiObject;
import us.springett.vulndbdatamirror.parser.model.Author;
import us.springett.vulndbdatamirror.parser.model.CPE;
import us.springett.vulndbdatamirror.parser.model.Classification;
import us.springett.vulndbdatamirror.parser.model.CvssV2Metric;
import us.springett.vulndbdatamirror.parser.model.CvssV3Metric;
import us.springett.vulndbdatamirror.parser.model.ExternalReference;
import us.springett.vulndbdatamirror.parser.model.ExternalText;
import us.springett.vulndbdatamirror.parser.model.NvdAdditionalInfo;
import us.springett.vulndbdatamirror.parser.model.Product;
import us.springett.vulndbdatamirror.parser.model.Results;
import us.springett.vulndbdatamirror.parser.model.Status;
import us.springett.vulndbdatamirror.parser.model.Vendor;
import us.springett.vulndbdatamirror.parser.model.Version;
import us.springett.vulndbdatamirror.parser.model.Vulnerability;

public class VulnDbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(VulnDbParser.class);

    public Status parseStatus(JsonNode jsonNode) {
        LOGGER.debug("Parsing JSON node");
        Status status = new Status();
        JSONObject root = jsonNode.getObject();
        status.setOrganizationName(root.optString("organization_name"));
        status.setUserNameRequesting(root.optString("user_name_requesting"));
        status.setUserEmailRequesting(root.optString("user_email_address_requesting"));
        status.setSubscriptionEndDate(root.optString("subscription_end_date"));
        status.setApiCallsAllowedPerMonth(root.optString("number_of_api_calls_allowed_per_month"));
        status.setApiCallsMadeThisMonth(root.optString("number_of_api_calls_made_this_month"));
        status.setVulnDbStatistics(root.optString("vulndb_statistics"));
        status.setRawStatus(jsonNode.toString());
        return status;
    }

    public <T> Results<T> parse(JsonNode jsonNode, Class<? extends ApiObject> apiObject) {
        LOGGER.debug("Parsing JSON node");
        Results results = new Results();
        JSONObject root = jsonNode.getObject();
        results.setPage(root.getInt("current_page"));
        results.setTotal(root.getInt("total_entries"));
        results.setRawResults(jsonNode.toString());
        JSONArray rso = root.getJSONArray("results");
        if (Product.class == apiObject) {
            results.setResults(this.parseProducts(rso));
        } else if (Vendor.class == apiObject) {
            results.setResults(this.parseVendors(rso));
        } else if (Version.class == apiObject) {
            results.setResults(this.parseVersions(rso));
        } else if (Vulnerability.class == apiObject) {
            results.setResults(this.parseVulnerabilities(rso));
        }
        return results;
    }

    public <T> Results<T> parse(String jsonData, Class<? extends ApiObject> apiObject) {
        return this.parse(new JsonNode(jsonData), apiObject);
    }

    public <T> Results<T> parse(File file, Class<? extends ApiObject> apiObject) throws IOException {
        String jsonData = new String(Files.readAllBytes(Paths.get(file.toURI())));
        return this.parse(new JsonNode(jsonData), apiObject);
    }

    private List<CPE> parseCpes(JSONArray rso) {
        ArrayList<CPE> cpes = null;
        if (rso != null) {
            cpes = new ArrayList<CPE>();
            for (int i = 0; i < rso.length(); ++i) {
                JSONObject object = rso.getJSONObject(i);
                CPE cpe = new CPE();
                cpe.setCpe(StringUtils.trimToNull((String)object.optString("cpe", null)));
                cpe.setType(StringUtils.trimToNull((String)object.optString("type", null)));
                cpes.add(cpe);
            }
        }
        return cpes;
    }

    private List<Product> parseProducts(JSONArray rso) {
        ArrayList<Product> products = null;
        if (rso != null) {
            products = new ArrayList<Product>();
            for (int i = 0; i < rso.length(); ++i) {
                JSONObject object = rso.getJSONObject(i);
                Product product = new Product();
                product.setId(object.getInt("id"));
                product.setName(StringUtils.trimToNull((String)object.optString("name", null)));
                product.setVersions(this.parseVersions(object.optJSONArray("versions")));
                products.add(product);
            }
        }
        return products;
    }

    private List<Vendor> parseVendors(JSONArray rso) {
        ArrayList<Vendor> vendors = null;
        if (rso != null) {
            vendors = new ArrayList<Vendor>();
            for (int i = 0; i < rso.length(); ++i) {
                JSONObject object = rso.getJSONObject(i);
                if (object.has("vendor")) {
                    JSONObject childObject = object.getJSONObject("vendor");
                    Vendor vendor = this.parseVendor(childObject);
                    vendors.add(vendor);
                    continue;
                }
                Vendor vendor = this.parseVendor(object);
                vendors.add(vendor);
            }
        }
        return vendors;
    }

    private Vendor parseVendor(JSONObject object) {
        Vendor vendor = new Vendor();
        vendor.setId(object.getInt("id"));
        vendor.setName(StringUtils.trimToNull((String)object.optString("name", null)));
        vendor.setShortName(StringUtils.trimToNull((String)object.optString("short_name", null)));
        vendor.setVendorUrl(StringUtils.trimToNull((String)object.optString("vendor_url", null)));
        vendor.setProducts(this.parseProducts(object.optJSONArray("products")));
        return vendor;
    }

    private List<Version> parseVersions(JSONArray rso) {
        ArrayList<Version> versions = null;
        if (rso != null) {
            versions = new ArrayList<Version>();
            for (int i = 0; i < rso.length(); ++i) {
                JSONObject object = rso.getJSONObject(i);
                Version version = new Version();
                version.setId(object.getInt("id"));
                version.setName(StringUtils.trimToNull((String)object.optString("name", null)));
                version.setAffected(object.optBoolean("affected", false));
                version.setCpes(this.parseCpes(object.optJSONArray("cpe")));
                versions.add(version);
            }
        }
        return versions;
    }

    private List<Vulnerability> parseVulnerabilities(JSONArray rso) {
        ArrayList<Vulnerability> vulnerabilities = null;
        if (rso != null) {
            vulnerabilities = new ArrayList<Vulnerability>();
            for (int i = 0; i < rso.length(); ++i) {
                JSONArray nvdInfo;
                JSONArray cvssv3Metrics;
                JSONArray cvssv2Metrics;
                JSONArray extTexts;
                JSONArray extRefs;
                JSONArray authors;
                JSONObject object = rso.getJSONObject(i);
                Vulnerability vulnerability = new Vulnerability();
                vulnerability.setId(object.getInt("vulndb_id"));
                vulnerability.setTitle(StringUtils.trimToNull((String)object.optString("title", null)));
                vulnerability.setDisclosureDate(StringUtils.trimToNull((String)object.optString("disclosure_date", null)));
                vulnerability.setDiscoveryDate(StringUtils.trimToNull((String)object.optString("discovery_date", null)));
                vulnerability.setExploitPublishDate(StringUtils.trimToNull((String)object.optString("exploit_publish_date", null)));
                vulnerability.setKeywords(StringUtils.trimToNull((String)object.optString("keywords", null)));
                vulnerability.setShortDescription(StringUtils.trimToNull((String)object.optString("short_description", null)));
                vulnerability.setDescription(StringUtils.trimToNull((String)object.optString("description", null)));
                vulnerability.setSolution(StringUtils.trimToNull((String)object.optString("solution", null)));
                vulnerability.setManualNotes(StringUtils.trimToNull((String)object.optString("manual_notes", null)));
                vulnerability.setTechnicalDescription(StringUtils.trimToNull((String)object.optString("t_description", null)));
                vulnerability.setSolutionDate(StringUtils.trimToNull((String)object.optString("solution_date", null)));
                vulnerability.setVendorInformedDate(StringUtils.trimToNull((String)object.optString("vendor_informed_date", null)));
                vulnerability.setVendorAckDate(StringUtils.trimToNull((String)object.optString("vendor_ack_date", null)));
                vulnerability.setThirdPartySolutionDate(StringUtils.trimToNull((String)object.optString("third_party_solution_date", null)));
                JSONArray classifications = object.optJSONArray("classifications");
                if (classifications != null) {
                    for (int j = 0; j < classifications.length(); ++j) {
                        JSONObject jso = classifications.getJSONObject(j);
                        Classification classification = new Classification();
                        classification.setId(jso.getInt("id"));
                        classification.setName(StringUtils.trimToNull((String)jso.optString("name", null)));
                        classification.setLongname(StringUtils.trimToNull((String)jso.optString("longname", null)));
                        classification.setDescription(StringUtils.trimToNull((String)jso.optString("description", null)));
                        classification.setMediumtext(StringUtils.trimToNull((String)jso.optString("mediumtext", null)));
                        vulnerability.addClassifications(classification);
                    }
                }
                if ((authors = object.optJSONArray("authors")) != null) {
                    for (int j = 0; j < authors.length(); ++j) {
                        JSONObject jso = authors.getJSONObject(j);
                        Author author = new Author();
                        author.setId(jso.getInt("id"));
                        author.setName(StringUtils.trimToNull((String)jso.optString("name", null)));
                        author.setCompany(StringUtils.trimToNull((String)jso.optString("company", null)));
                        author.setEmail(StringUtils.trimToNull((String)jso.optString("email", null)));
                        author.setCompanyUrl(StringUtils.trimToNull((String)jso.optString("company_url", null)));
                        author.setCountry(StringUtils.trimToNull((String)jso.optString("country", null)));
                        vulnerability.addAuthor(author);
                    }
                }
                if ((extRefs = object.optJSONArray("ext_references")) != null) {
                    for (int j = 0; j < extRefs.length(); ++j) {
                        JSONObject jso = extRefs.getJSONObject(j);
                        ExternalReference externalReference = new ExternalReference();
                        externalReference.setType(StringUtils.trimToNull((String)jso.optString("type", null)));
                        externalReference.setValue(StringUtils.trimToNull((String)jso.optString("value", null)));
                        vulnerability.addExtReference(externalReference);
                    }
                }
                if ((extTexts = object.optJSONArray("ext_texts")) != null) {
                    for (int j = 0; j < extTexts.length(); ++j) {
                        JSONObject jso = extTexts.getJSONObject(j);
                        ExternalText externalText = new ExternalText();
                        externalText.setType(StringUtils.trimToNull((String)jso.optString("type", null)));
                        externalText.setValue(StringUtils.trimToNull((String)jso.optString("value", null)));
                        vulnerability.addExtText(externalText);
                    }
                }
                if ((cvssv2Metrics = object.optJSONArray("cvss_metrics")) != null) {
                    for (int j = 0; j < cvssv2Metrics.length(); ++j) {
                        JSONObject jso = cvssv2Metrics.getJSONObject(j);
                        CvssV2Metric metric = new CvssV2Metric();
                        metric.setId(jso.getInt("id"));
                        metric.setAccessComplexity(StringUtils.trimToNull((String)jso.optString("access_complexity", null)));
                        metric.setCveId(StringUtils.trimToNull((String)jso.optString("cve_id", null)));
                        metric.setSource(StringUtils.trimToNull((String)jso.optString("source", null)));
                        metric.setAvailabilityImpact(StringUtils.trimToNull((String)jso.optString("availability_impact", null)));
                        metric.setConfidentialityImpact(StringUtils.trimToNull((String)jso.optString("confidentiality_impact", null)));
                        metric.setAuthentication(StringUtils.trimToNull((String)jso.optString("authentication", null)));
                        metric.setCalculatedCvssBaseScore(jso.optBigDecimal("calculated_cvss_base_score", null));
                        metric.setGeneratedOn(StringUtils.trimToNull((String)jso.optString("generated_on", null)));
                        metric.setScore(jso.optBigDecimal("score", null));
                        metric.setAccessVector(StringUtils.trimToNull((String)jso.optString("access_vector", null)));
                        metric.setIntegrityImpact(StringUtils.trimToNull((String)jso.optString("integrity_impact", null)));
                        vulnerability.addCvssV2Metric(metric);
                    }
                }
                if ((cvssv3Metrics = object.optJSONArray("cvss_version_three_metrics")) != null) {
                    for (int j = 0; j < cvssv3Metrics.length(); ++j) {
                        JSONObject jso = cvssv3Metrics.getJSONObject(j);
                        CvssV3Metric metric = new CvssV3Metric();
                        metric.setId(jso.getInt("id"));
                        metric.setAttackComplexity(StringUtils.trimToNull((String)jso.optString("attack_complexity", null)));
                        metric.setScope(StringUtils.trimToNull((String)jso.optString("scope", null)));
                        metric.setAttackVector(StringUtils.trimToNull((String)jso.optString("attack_vector", null)));
                        metric.setAvailabilityImpact(StringUtils.trimToNull((String)jso.optString("availability_impact", null)));
                        metric.setScore(jso.optBigDecimal("score", null));
                        metric.setPrivilegesRequired(StringUtils.trimToNull((String)jso.optString("privileges_required", null)));
                        metric.setUserInteraction(StringUtils.trimToNull((String)jso.optString("user_interaction", null)));
                        metric.setCveId(StringUtils.trimToNull((String)jso.optString("cve_id", null)));
                        metric.setSource(StringUtils.trimToNull((String)jso.optString("source", null)));
                        metric.setConfidentialityImpact(StringUtils.trimToNull((String)jso.optString("confidentiality_impact", null)));
                        metric.setCalculatedCvssBaseScore(jso.optBigDecimal("calculated_cvss_base_score", null));
                        metric.setGeneratedOn(StringUtils.trimToNull((String)jso.optString("generated_on", null)));
                        metric.setIntegrityImpact(StringUtils.trimToNull((String)jso.optString("integrity_impact", null)));
                        vulnerability.addCvssV3Metric(metric);
                    }
                }
                if ((nvdInfo = object.optJSONArray("nvd_additional_information")) != null) {
                    for (int j = 0; j < nvdInfo.length(); ++j) {
                        JSONObject jso = nvdInfo.getJSONObject(j);
                        NvdAdditionalInfo nvdAdditionalInfo = new NvdAdditionalInfo();
                        nvdAdditionalInfo.setSummary(StringUtils.trimToNull((String)jso.optString("summary", null)));
                        nvdAdditionalInfo.setCweId(StringUtils.trimToNull((String)jso.optString("cwe_id", null)));
                        nvdAdditionalInfo.setCveId(StringUtils.trimToNull((String)jso.optString("cve_id", null)));
                        vulnerability.setNvdAdditionalInfo(nvdAdditionalInfo);
                    }
                }
                JSONArray vendors = object.optJSONArray("vendors");
                vulnerability.setVendors(this.parseVendors(vendors));
                vulnerabilities.add(vulnerability);
            }
        }
        return vulnerabilities;
    }
}

