/*
 * Decompiled with CFR 0.152.
 */
package us.springett.vulndbdatamirror.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import kong.unirest.UnirestInstance;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.exception.OAuthException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.vulndbdatamirror.parser.VulnDbParser;
import us.springett.vulndbdatamirror.parser.model.ApiObject;
import us.springett.vulndbdatamirror.parser.model.Product;
import us.springett.vulndbdatamirror.parser.model.Results;
import us.springett.vulndbdatamirror.parser.model.Status;
import us.springett.vulndbdatamirror.parser.model.Vendor;
import us.springett.vulndbdatamirror.parser.model.Version;
import us.springett.vulndbdatamirror.parser.model.Vulnerability;

public class VulnDbApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(VulnDbApi.class);
    private static final String USER_AGENT = "VulnDB Data Mirror (https://github.com/stevespringett/vulndb-data-mirror)";
    private static final String STATUS_URL = "https://vulndb.cyberriskanalytics.com/api/v1/account_status";
    private static final String VENDORS_URL = "https://vulndb.cyberriskanalytics.com/api/v1/vendors/";
    private static final String PRODUCTS_URL = "https://vulndb.cyberriskanalytics.com/api/v1/products/";
    private static final String VERSIONS_URL = "https://vulndb.cyberriskanalytics.com/api/v1/versions/by_product_id?product_id=";
    private static final String VULNERABILITIES_URL = "https://vulndb.cyberriskanalytics.com/api/v1/vulnerabilities/?nested=true&additional_info=true&show_cpe_full=true&show_cvss_v3=true&package_info=true&vtem=true";
    private static final String VULNERABILITIES_FIND_BY_CPE_URL = "https://vulndb.cyberriskanalytics.com/api/v1/vulnerabilities/find_by_cpe?&cpe=";
    private final UnirestInstance ui;
    private final String consumerKey;
    private final String consumerSecret;

    public VulnDbApi(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.ui = Unirest.primaryInstance();
    }

    public VulnDbApi(String consumerKey, String consumerSecret, UnirestInstance ui) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.ui = ui;
    }

    public Status getStatus() {
        HttpResponse<JsonNode> response = this.makeRequest(STATUS_URL);
        if (response != null) {
            if (response.getStatus() == 200) {
                VulnDbParser parser = new VulnDbParser();
                return parser.parseStatus((JsonNode)response.getBody());
            }
            this.logHttpResponseError(response);
        }
        return new Status();
    }

    public Results getVendors(int size, int page) {
        return this.getResults(VENDORS_URL, Vendor.class, size, page);
    }

    public Results getProducts(int size, int page) {
        return this.getResults(PRODUCTS_URL, Product.class, size, page);
    }

    public Results getVersions(int productId, int size, int page) {
        return this.getResults(VERSIONS_URL + productId, Version.class, size, page);
    }

    public Results getVulnerabilities(int size, int page) {
        return this.getResults(VULNERABILITIES_URL, Vulnerability.class, size, page);
    }

    public Results getVulnerabilitiesByCpe(String cpe, int size, int page) {
        String encodedCpe = cpe;
        try {
            encodedCpe = URLEncoder.encode(cpe, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("An error occurred while URL encoding a CPE", (Throwable)e);
        }
        return this.getResults(VULNERABILITIES_FIND_BY_CPE_URL + encodedCpe, Vulnerability.class, size, page);
    }

    private Results getResults(String url, Class clazz, int size, int page) {
        String modifiedUrl = url.contains("?") ? url + "&" : url + "?";
        HttpResponse<JsonNode> response = this.makeRequest(modifiedUrl + "size=" + size + "&page=" + page);
        if (response != null) {
            if (response.getStatus() == 200) {
                VulnDbParser parser = new VulnDbParser();
                Results results = parser.parse((JsonNode)response.getBody(), (Class<? extends ApiObject>)clazz);
                return results;
            }
            Results results = new Results();
            results.setErrorCondition("An unexpected response was returned from VulnDB. Request unsuccessful: " + response.getStatus() + " - " + response.getStatusText() + " - " + response.getBody());
            this.logHttpResponseError(response);
            return results;
        }
        Results results = new Results();
        results.setErrorCondition("No response was returned from VulnDB. No further information is available.");
        return results;
    }

    private HttpResponse<JsonNode> makeRequest(String url) {
        try {
            DefaultOAuthConsumer consumer = new DefaultOAuthConsumer(this.consumerKey, this.consumerSecret);
            String signed = consumer.sign(url);
            return ((GetRequest)this.ui.get(signed).header("X-User-Agent", USER_AGENT)).asJson();
        }
        catch (UnirestException | OAuthException e) {
            LOGGER.error("An error occurred making request: " + url, e);
            return null;
        }
    }

    private void logHttpResponseError(HttpResponse<JsonNode> response) {
        LOGGER.error("Response was not successful: " + response.getStatus() + " - " + response.getStatusText() + " - " + response.getBody());
        System.err.println("\n" + response.getStatus() + " - " + response.getStatusText() + " - " + response.getBody());
    }

    public static enum Type {
        VENDORS,
        PRODUCTS,
        VULNERABILITIES;

    }
}

