/*
 * Decompiled with CFR 0.152.
 */
package us.vchain.jvcn;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import us.vchain.jvcn.Level;
import us.vchain.jvcn.Status;

public class Asset {
    private static final String ALGORITHM = "SHA-256";
    private static final String UNIT = "0x0000000000000000000000000000000000000000";
    private String hash;
    private String signer;
    private Level level;
    private Status status;
    private LocalDateTime timestamp;
    private String name;
    private Long size;
    private String url;
    private String publisher;
    private Long verificationCount;
    private Long publisherCount;
    private String publisherCompany;
    private String publisherWebsiteUrl;
    private String kind;
    private String contentType;
    private Map<String, Object> metadata;
    private LocalDateTime createdAt;

    public Boolean isPresent() {
        return !UNIT.equals(this.signer);
    }

    public String getMetaHash() {
        try {
            String format = String.format("%s-%d-%d-%d", this.signer, this.level.getValue(), this.status.getValue(), this.timestamp.toEpochSecond(ZoneOffset.UTC));
            MessageDigest messageDigest = MessageDigest.getInstance(ALGORITHM);
            messageDigest.update(format.getBytes(StandardCharsets.UTF_8));
            byte[] digest = messageDigest.digest();
            return String.format("%064x", new BigInteger(1, digest));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getSigner() {
        return this.signer;
    }

    public void setSigner(String signer) {
        this.signer = signer;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public Long getVerificationCount() {
        return this.verificationCount;
    }

    public void setVerificationCount(Long verificationCount) {
        this.verificationCount = verificationCount;
    }

    public Long getPublisherCount() {
        return this.publisherCount;
    }

    public void setPublisherCount(Long publisherCount) {
        this.publisherCount = publisherCount;
    }

    public String getPublisherCompany() {
        return this.publisherCompany;
    }

    public void setPublisherCompany(String publisherCompany) {
        this.publisherCompany = publisherCompany;
    }

    public String getPublisherWebsiteUrl() {
        return this.publisherWebsiteUrl;
    }

    public void setPublisherWebsiteUrl(String publisherWebsiteUrl) {
        this.publisherWebsiteUrl = publisherWebsiteUrl;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public String toString() {
        return new StringJoiner(", ", Asset.class.getSimpleName() + "[", "]").add("hash='" + this.hash + "'").add("signer='" + this.signer + "'").add("level=" + (Object)((Object)this.level)).add("status=" + (Object)((Object)this.status)).add("timestamp=" + this.timestamp).add("name='" + this.name + "'").add("size=" + this.size).add("url='" + this.url + "'").add("publisher='" + this.publisher + "'").add("verificationCount=" + this.verificationCount).add("publisherCount=" + this.publisherCount).add("publisherCompany='" + this.publisherCompany + "'").add("publisherWebsiteUrl='" + this.publisherWebsiteUrl + "'").add("kind='" + this.kind + "'").add("contentType='" + this.contentType + "'").add("metadata=" + this.metadata).add("createdAt=" + this.createdAt).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)o;
        return Objects.equals(this.hash, asset.hash) && Objects.equals(this.signer, asset.signer) && Objects.equals((Object)this.level, (Object)asset.level) && Objects.equals((Object)this.status, (Object)asset.status) && Objects.equals(this.timestamp, asset.timestamp) && Objects.equals(this.name, asset.name) && Objects.equals(this.size, asset.size) && Objects.equals(this.url, asset.url) && Objects.equals(this.publisher, asset.publisher) && Objects.equals(this.verificationCount, asset.verificationCount) && Objects.equals(this.publisherCount, asset.publisherCount) && Objects.equals(this.publisherCompany, asset.publisherCompany) && Objects.equals(this.publisherWebsiteUrl, asset.publisherWebsiteUrl) && Objects.equals(this.kind, asset.kind) && Objects.equals(this.contentType, asset.contentType) && Objects.equals(this.metadata, asset.metadata) && Objects.equals(this.createdAt, asset.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hash, this.signer, this.level, this.status, this.timestamp, this.name, this.size, this.url, this.publisher, this.verificationCount, this.publisherCount, this.publisherCompany, this.publisherWebsiteUrl, this.kind, this.contentType, this.metadata, this.createdAt});
    }
}

