/*
 * Decompiled with CFR 0.152.
 */
package us.vchain.jvcn;

import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.web3j.crypto.Keys;
import org.web3j.tuples.generated.Tuple4;
import us.vchain.jvcn.Asset;
import us.vchain.jvcn.Level;
import us.vchain.jvcn.Metadata;
import us.vchain.jvcn.Status;

class AssetMapper {
    AssetMapper() {
    }

    Asset from(String hash, Tuple4<String, BigInteger, BigInteger, BigInteger> tuple) {
        Asset asset = new Asset();
        asset.setHash(hash);
        asset.setSigner(Keys.toChecksumAddress((String)((String)tuple.getValue1())));
        asset.setLevel(Level.from(((BigInteger)tuple.getValue2()).intValue()));
        asset.setStatus(Status.from(((BigInteger)tuple.getValue3()).intValue()));
        Instant instant = Instant.ofEpochSecond(((BigInteger)tuple.getValue4()).longValue());
        asset.setTimestamp(LocalDateTime.ofInstant(instant, ZoneOffset.UTC));
        return asset;
    }

    void enrich(Asset asset, Metadata metadata) {
        asset.setName(metadata.getName());
        asset.setSize(metadata.getSize());
        asset.setUrl(metadata.getUrl());
        asset.setPublisher(metadata.getPublisher());
        asset.setVerificationCount(metadata.getVerificationCount());
        asset.setPublisherCount(metadata.getPublisherCount());
        asset.setPublisherCompany(metadata.getPublisherCompany());
        asset.setPublisherWebsiteUrl(metadata.getPublisherWebsiteUrl());
        asset.setKind(metadata.getKind());
        asset.setContentType(metadata.getContentType());
        asset.setMetadata(metadata.getMetadata());
        asset.setCreatedAt(metadata.getCreatedAt());
    }
}

