/*
 * Decompiled with CFR 0.152.
 */
package us.vchain.jvcn;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import us.vchain.jvcn.Metadata;
import us.vchain.jvcn.SystemConfiguration;

class AssetsClient {
    private final SystemConfiguration systemConfiguration;
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public AssetsClient(SystemConfiguration systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
        this.httpClient = new OkHttpClient.Builder().build();
        this.objectMapper = new ObjectMapper();
        this.objectMapper.findAndRegisterModules();
    }

    public Metadata fetchMetadata(String hash, String metaHash) throws IOException {
        Request request = new Request.Builder().url(this.systemConfiguration.getArtifactUrl(hash, metaHash)).build();
        Response response = this.httpClient.newCall(request).execute();
        InputStream inputStream = response.body() == null ? null : response.body().byteStream();
        return (Metadata)this.objectMapper.readValue(inputStream, Metadata.class);
    }
}

