/*
 * Decompiled with CFR 0.152.
 */
package us.vchain.jvcn;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.web3j.protocol.Web3j;
import org.web3j.tuples.generated.Tuple4;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;
import us.vchain.jvcn.Asset;
import us.vchain.jvcn.AssetMapper;
import us.vchain.jvcn.AssetsClient;
import us.vchain.jvcn.AssetsRelay;
import us.vchain.jvcn.Configuration;
import us.vchain.jvcn.Metadata;
import us.vchain.jvcn.SystemConfiguration;

public class AssetsRelayFacade {
    private final AssetsRelay assetsRelay;
    private final AssetMapper assetMapper;
    private final AssetsClient assetsClient;

    public AssetsRelayFacade(Web3j web3j, Configuration configuration, SystemConfiguration systemConfiguration) {
        ReadonlyTransactionManager transactionManager = new ReadonlyTransactionManager(web3j, configuration.getPublicKey());
        StaticGasProvider contractGasProvider = new StaticGasProvider(systemConfiguration.getGasPrice(), systemConfiguration.getGasLimit());
        this.assetMapper = new AssetMapper();
        this.assetsClient = new AssetsClient(systemConfiguration);
        this.assetsRelay = AssetsRelay.load(systemConfiguration.getContractAddress(), web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider);
    }

    public Optional<Asset> verify(String hash) throws Exception {
        Tuple4 tuple = (Tuple4)this.assetsRelay.verify(hash).send();
        Asset asset = this.assetMapper.from(hash, (Tuple4<String, BigInteger, BigInteger, BigInteger>)tuple);
        if (!asset.isPresent().booleanValue()) {
            return Optional.empty();
        }
        Metadata metadata = this.assetsClient.fetchMetadata(hash, asset.getMetaHash());
        this.assetMapper.enrich(asset, metadata);
        return Optional.of(asset);
    }

    public List<Asset> listAllAssetsMatchingHash(String hash) throws Exception {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        BigInteger count = (BigInteger)this.assetsRelay.getAssetCountForHash(hash).send();
        for (long i = 0L; i < count.longValue(); ++i) {
            Tuple4 tuple = (Tuple4)this.assetsRelay.verifyByIndex(hash, BigInteger.valueOf(i)).send();
            Asset asset = this.assetMapper.from(hash, (Tuple4<String, BigInteger, BigInteger, BigInteger>)tuple);
            if (!asset.isPresent().booleanValue()) continue;
            Metadata metadata = this.assetsClient.fetchMetadata(hash, asset.getMetaHash());
            this.assetMapper.enrich(asset, metadata);
            assets.add(asset);
        }
        return assets;
    }

    public List<Asset> listAllAssetsMatchingHashAndSigner(String hash, Set<String> signers) throws Exception {
        Set sanitisedSigners = signers.stream().map(String::toLowerCase).collect(Collectors.toSet());
        return this.listAllAssetsMatchingHash(hash).stream().filter(asset -> sanitisedSigners.contains(asset.getSigner().toLowerCase())).collect(Collectors.toList());
    }
}

