/*
 * Decompiled with CFR 0.152.
 */
package us.vchain.jvcn;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;
import us.vchain.jvcn.Asset;
import us.vchain.jvcn.AssetsRelayFacade;
import us.vchain.jvcn.Configuration;
import us.vchain.jvcn.DigestHelper;
import us.vchain.jvcn.JVCNException;
import us.vchain.jvcn.SystemConfiguration;

public class JVCN {
    private final AssetsRelayFacade assetsRelayFacade;
    private final DigestHelper digestHelper;

    private JVCN(Configuration configuration, SystemConfiguration systemConfiguration, Web3j web3j) {
        this.assetsRelayFacade = new AssetsRelayFacade(web3j, configuration, systemConfiguration);
        this.digestHelper = new DigestHelper();
    }

    public Optional<Asset> verify(String hash) {
        try {
            return this.assetsRelayFacade.verify(hash);
        }
        catch (Exception e) {
            throw new JVCNException(e);
        }
    }

    public Optional<Asset> verify(String hash, Set<String> signers) {
        List<Asset> assets = this.listAllAssetsMatchingHashAndSigner(hash, signers);
        return assets.isEmpty() ? Optional.empty() : Optional.of(assets.get(assets.size() - 1));
    }

    public Optional<Asset> verify(File file) {
        try {
            String hash = this.digestHelper.sha256Hash(file);
            return this.verify(hash);
        }
        catch (Exception e) {
            throw new JVCNException(e);
        }
    }

    public Optional<Asset> verify(File file, Set<String> signers) {
        try {
            String hash = this.digestHelper.sha256Hash(file);
            List<Asset> assets = this.listAllAssetsMatchingHashAndSigner(hash, signers);
            return assets.isEmpty() ? Optional.empty() : Optional.of(assets.get(assets.size() - 1));
        }
        catch (Exception e) {
            throw new JVCNException(e);
        }
    }

    public List<Asset> listAllAssetsMatchingHash(String hash) {
        try {
            return this.assetsRelayFacade.listAllAssetsMatchingHash(hash);
        }
        catch (Exception e) {
            throw new JVCNException(e);
        }
    }

    public List<Asset> listAllAssetsMatchingFile(File file) {
        try {
            String hash = this.digestHelper.sha256Hash(file);
            return this.assetsRelayFacade.listAllAssetsMatchingHash(hash);
        }
        catch (Exception e) {
            throw new JVCNException(e);
        }
    }

    public List<Asset> listAllAssetsMatchingHashAndSigner(String hash, Set<String> signers) {
        try {
            return this.assetsRelayFacade.listAllAssetsMatchingHashAndSigner(hash, signers);
        }
        catch (Exception e) {
            throw new JVCNException(e);
        }
    }

    public List<Asset> listAllAssetsMatchingFileAndSigner(File file, Set<String> signers) {
        try {
            String hash = this.digestHelper.sha256Hash(file);
            return this.assetsRelayFacade.listAllAssetsMatchingHashAndSigner(hash, signers);
        }
        catch (Exception e) {
            throw new JVCNException(e);
        }
    }

    public static class Builder {
        private Configuration configuration = new Configuration();
        private SystemConfiguration systemConfiguration = new SystemConfiguration();
        private Web3j web3j = Web3j.build((Web3jService)new HttpService(this.systemConfiguration.getNetwork()));

        public Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder systemConfiguration(SystemConfiguration systemConfiguration) {
            this.systemConfiguration = systemConfiguration;
            return this;
        }

        public Builder web3j(Web3j web3j) {
            this.web3j = web3j;
            return this;
        }

        public JVCN build() {
            return new JVCN(this.configuration, this.systemConfiguration, this.web3j);
        }
    }
}

