/*
 * Decompiled with CFR 0.152.
 */
package uy.kohesive.solr.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.RequestLimit;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.util.Headers;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uy.klutter.core.jdk.ChildFirstClassloader;
import uy.klutter.core.jdk.NumbersKt;
import uy.klutter.core.jdk7.PathsKt;
import uy.kohesive.solr.undertow.RequestLimitConfig;
import uy.kohesive.solr.undertow.ServerConfig;
import uy.kohesive.solr.undertow.ServerConfigLoader;
import uy.kohesive.solr.undertow.ServerStartupStatus;
import uy.kohesive.solr.undertow.SolrDefaultServletConfig;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00043456B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u000201J\u0018\u00102\u001a\u0002012\u0006\u0010!\u001a\u00020 2\u0006\u0010\r\u001a\u00020\fH\u0002R\u0017\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR*\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R*\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u00198B@BX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0013\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR*\u0010!\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020 8B@BX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010\u0013\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00067"}, d2={"Luy/kohesive/solr/undertow/Server;", "", "cfgLoader", "Luy/kohesive/solr/undertow/ServerConfigLoader;", "(Luy/kohesive/solr/undertow/ServerConfigLoader;)V", "cfg", "Luy/kohesive/solr/undertow/ServerConfig;", "getCfg", "()Luy/kohesive/solr/undertow/ServerConfig;", "cfg$delegate", "Lkotlin/Lazy;", "<set-?>", "Lio/undertow/server/handlers/GracefulShutdownHandler;", "gracefulShutdownWrapperHandler", "getGracefulShutdownWrapperHandler", "()Lio/undertow/server/handlers/GracefulShutdownHandler;", "setGracefulShutdownWrapperHandler", "(Lio/undertow/server/handlers/GracefulShutdownHandler;)V", "gracefulShutdownWrapperHandler$delegate", "Lkotlin/properties/ReadWriteProperty;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "Lio/undertow/Undertow;", "server", "getServer", "()Lio/undertow/Undertow;", "setServer", "(Lio/undertow/Undertow;)V", "server$delegate", "Lio/undertow/servlet/api/DeploymentManager;", "servletDeploymentMgr", "getServletDeploymentMgr", "()Lio/undertow/servlet/api/DeploymentManager;", "setServletDeploymentMgr", "(Lio/undertow/servlet/api/DeploymentManager;)V", "servletDeploymentMgr$delegate", "buildSolrServletHandler", "Luy/kohesive/solr/undertow/Server$ServletDeploymentAndHandler;", "solrWarDeployment", "Luy/kohesive/solr/undertow/Server$DeployedDistributionInfo;", "deploySolrDistributionToCache", "solrDistribution", "Ljava/nio/file/Path;", "run", "Luy/kohesive/solr/undertow/ServerStartupStatus;", "shutdown", "", "shutdownNicely", "DeployedDistributionInfo", "RequestLimitHelper", "ServletDeploymentAndHandler", "ShutdownRequestHandler", "solr-undertow-compileKotlin"})
@KotlinClass(version={1, 1, 0}, data={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00043456B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u000201J\u0018\u00102\u001a\u0002012\u0006\u0010!\u001a\u00020 2\u0006\u0010\r\u001a\u00020\fH\u0002R\u0017\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR*\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R*\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u00198B@BX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0013\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR*\u0010!\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020 8B@BX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010\u0013\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00067"}, strings={"Luy/kohesive/solr/undertow/Server;", "", "cfgLoader", "Luy/kohesive/solr/undertow/ServerConfigLoader;", "(Luy/kohesive/solr/undertow/ServerConfigLoader;)V", "cfg", "Luy/kohesive/solr/undertow/ServerConfig;", "getCfg", "()Luy/kohesive/solr/undertow/ServerConfig;", "cfg$delegate", "Lkotlin/Lazy;", "<set-?>", "Lio/undertow/server/handlers/GracefulShutdownHandler;", "gracefulShutdownWrapperHandler", "getGracefulShutdownWrapperHandler", "()Lio/undertow/server/handlers/GracefulShutdownHandler;", "setGracefulShutdownWrapperHandler", "(Lio/undertow/server/handlers/GracefulShutdownHandler;)V", "gracefulShutdownWrapperHandler$delegate", "Lkotlin/properties/ReadWriteProperty;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "Lio/undertow/Undertow;", "server", "getServer", "()Lio/undertow/Undertow;", "setServer", "(Lio/undertow/Undertow;)V", "server$delegate", "Lio/undertow/servlet/api/DeploymentManager;", "servletDeploymentMgr", "getServletDeploymentMgr", "()Lio/undertow/servlet/api/DeploymentManager;", "setServletDeploymentMgr", "(Lio/undertow/servlet/api/DeploymentManager;)V", "servletDeploymentMgr$delegate", "buildSolrServletHandler", "Luy/kohesive/solr/undertow/Server$ServletDeploymentAndHandler;", "solrWarDeployment", "Luy/kohesive/solr/undertow/Server$DeployedDistributionInfo;", "deploySolrDistributionToCache", "solrDistribution", "Ljava/nio/file/Path;", "run", "Luy/kohesive/solr/undertow/ServerStartupStatus;", "shutdown", "", "shutdownNicely", "DeployedDistributionInfo", "RequestLimitHelper", "ServletDeploymentAndHandler", "ShutdownRequestHandler", "solr-undertow-compileKotlin"})
public final class Server {
    private final Logger log;
    @NotNull
    private final Lazy<ServerConfig> cfg$delegate;
    private final ReadWriteProperty<Object, Undertow> server$delegate;
    private final ReadWriteProperty<Object, GracefulShutdownHandler> gracefulShutdownWrapperHandler$delegate;
    private final ReadWriteProperty<Object, DeploymentManager> servletDeploymentMgr$delegate;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    public final Logger getLog() {
        return this.log;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ServerConfig getCfg() {
        void $receiver$iv;
        Lazy<ServerConfig> lazy = this.cfg$delegate;
        Server server = this;
        KProperty property$iv = $$delegatedProperties[0];
        return (ServerConfig)$receiver$iv.getValue();
    }

    private final Undertow getServer() {
        return (Undertow)this.server$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setServer(Undertow undertow) {
        this.server$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)undertow);
    }

    private final GracefulShutdownHandler getGracefulShutdownWrapperHandler() {
        return (GracefulShutdownHandler)this.gracefulShutdownWrapperHandler$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final void setGracefulShutdownWrapperHandler(GracefulShutdownHandler gracefulShutdownHandler) {
        this.gracefulShutdownWrapperHandler$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)gracefulShutdownHandler);
    }

    private final DeploymentManager getServletDeploymentMgr() {
        return (DeploymentManager)this.servletDeploymentMgr$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final void setServletDeploymentMgr(DeploymentManager deploymentManager) {
        this.servletDeploymentMgr$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)deploymentManager);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ServerStartupStatus run() {
        this.log.warn("Solr + Undertow = small server, happy days, fast, and maybe other cool things.");
        try {
            void $receiver$iv;
            void servletDeploymentMgr;
            void servletHandler;
            DeployedDistributionInfo deployedDistributionInfo;
            this.log.warn("Starting SolrServer");
            if (!this.getCfg().validate()) {
                return new ServerStartupStatus(false, "Configuration is not valid, terminating server");
            }
            this.getCfg().print();
            if (this.getCfg().omittingSolrWarLegally()) {
                Path path = null;
                ClassLoader classLoader = this.getClass().getClassLoader();
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"this.javaClass.getClassLoader()");
                deployedDistributionInfo = new DeployedDistributionInfo(true, path, classLoader);
            } else {
                DeployedDistributionInfo deployment;
                Path path = this.getCfg().getSolrWarFile();
                if (path == null) {
                    Intrinsics.throwNpe();
                }
                if (!(deployment = this.deploySolrDistributionToCache(path)).getSuccessfulDeploy()) {
                    return new ServerStartupStatus(false, "WAR file failed to deploy, terminating server");
                }
                deployedDistributionInfo = deployment;
            }
            DeployedDistributionInfo solrWarDeployment = deployedDistributionInfo;
            int ioThreads = NumbersKt.minimum((int)(this.getCfg().getHttpIoThreads() == 0 ? Runtime.getRuntime().availableProcessors() : this.getCfg().getHttpIoThreads()), (int)2);
            int workerThreads = NumbersKt.minimum((int)(this.getCfg().getHttpWorkerThreads() == 0 ? Runtime.getRuntime().availableProcessors() * 8 : this.getCfg().getHttpWorkerThreads()), (int)8);
            ServletDeploymentAndHandler servletDeploymentAndHandler = this.buildSolrServletHandler(solrWarDeployment);
            DeploymentManager deploymentManager = servletDeploymentAndHandler.component1();
            HttpHandler httpHandler = servletDeploymentAndHandler.component2();
            servletDeploymentAndHandler = null;
            AccessLogHandler loggedHandler2 = new AccessLogHandler((HttpHandler)servletHandler, new AccessLogReceiver(this){
                final /* synthetic */ Server this$0;

                public void logMessage(@Nullable String message) {
                    this.this$0.getCfg().getAccessLogger().info(message);
                }
                {
                    this.this$0 = $outer;
                }
            }, this.getCfg().getAccessLogFormat(), Server.class.getClassLoader());
            GracefulShutdownHandler gracefulShutdownHandler = Handlers.gracefulShutdown((HttpHandler)((HttpHandler)loggedHandler2));
            Intrinsics.checkExpressionValueIsNotNull((Object)gracefulShutdownHandler, (String)"Handlers.gracefulShutdown(loggedHandler)");
            this.setGracefulShutdownWrapperHandler(gracefulShutdownHandler);
            Thread gracefulShutdownHook2 = new Thread(new Runnable(this, (DeploymentManager)servletDeploymentMgr){
                final /* synthetic */ Server this$0;
                final /* synthetic */ DeploymentManager $servletDeploymentMgr;

                public final void run() {
                    if (Intrinsics.areEqual((Object)this.$servletDeploymentMgr.getState(), (Object)DeploymentManager.State.STARTED)) {
                        this.this$0.getLog().warn("Shutdown Hook triggered:  Undeploying servlets...");
                        boolean wasGraceful = Server.access$shutdownNicely(this.this$0, this.$servletDeploymentMgr, Server.access$getGracefulShutdownWrapperHandler$p(this.this$0));
                        if (wasGraceful) {
                            this.this$0.getLog().warn("Undeploy complete and graceful.");
                        } else {
                            this.this$0.getLog().error("Undeploy complete, but shutdown was not graceful.");
                        }
                    } else {
                        this.this$0.getLog().warn("Shutdown Hook triggered: servlets already undeployed.");
                    }
                }
                {
                    this.this$0 = server;
                    this.$servletDeploymentMgr = deploymentManager;
                }
            });
            Runtime.getRuntime().addShutdownHook(gracefulShutdownHook2);
            ShutdownRequestHandler shutdownRequestHandler = new ShutdownRequestHandler((DeploymentManager)servletDeploymentMgr, this.getGracefulShutdownWrapperHandler());
            this.log.info("Building Undertow server [port:" + this.getCfg().getHttpClusterPort() + ",host:" + this.getCfg().getHttpHost() + ",ioThreads:" + ioThreads + ",workerThreads:" + workerThreads + "]");
            Undertow undertow = Undertow.builder().addHttpListener(this.getCfg().getHttpClusterPort(), this.getCfg().getHttpHost()).addHttpListener(this.getCfg().getShutdownConfig().getHttpPort(), this.getCfg().getShutdownConfig().getHttpHost(), (HttpHandler)shutdownRequestHandler).setDirectBuffers(true).setHandler((HttpHandler)this.getGracefulShutdownWrapperHandler()).setIoThreads(ioThreads).setWorkerThreads(workerThreads).setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, (Object)this.getCfg().getAccessLogEnableRequestTiming()).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)undertow, (String)"Undertow.builder()\n     \u2026                 .build()");
            this.setServer(undertow);
            this.log.warn("Starting Undertow HTTP server...");
            this.getServer().start();
            String listeningUrl = "http://" + this.getCfg().getHttpHost() + ":" + this.getCfg().getHttpClusterPort() + this.getCfg().getSolrContextPath();
            this.log.warn("Undertow HTTP Server started, listening on " + listeningUrl);
            String shutdownUrl = "http://" + this.getCfg().getShutdownConfig().getHttpHost() + ":" + this.getCfg().getShutdownConfig().getHttpPort() + "?password=*****";
            this.log.warn("Shutdown port configured as " + shutdownUrl + " with graceful delay of " + this.getCfg().getShutdownConfig().getGracefulDelayString());
            CharSequence charSequence = this.getCfg().getShutdownConfig().getPassword();
            if ($receiver$iv == null || StringsKt.isBlank((CharSequence)$receiver$iv)) {
                this.log.warn("Shutdown password is not configured, therefore shutdown requests via HTTP will fail.");
            }
            this.log.info("Loading one Solr admin page to confirm not in a wait state...");
            this.log.warn("!!!! SERVER READY:  Listening, and ready at " + listeningUrl + " !!!!");
            return new ServerStartupStatus(true, "OK");
        }
        catch (Throwable ex) {
            StringBuilder stringBuilder = new StringBuilder().append("Server unhandled exception during startup '");
            String string = ex.getMessage();
            if (string == null) {
                string = ex.getClass().getName();
            }
            this.log.error(stringBuilder.append(string).append("'").toString(), ex);
            return new ServerStartupStatus(false, "Server unhandled exception during startup '" + ex.getMessage() + "'");
        }
    }

    public final boolean shutdown() {
        return this.shutdownNicely(this.getServletDeploymentMgr(), this.getGracefulShutdownWrapperHandler());
    }

    private final boolean shutdownNicely(DeploymentManager servletDeploymentMgr, GracefulShutdownHandler gracefulShutdownWrapperHandler) {
        gracefulShutdownWrapperHandler.shutdown();
        boolean wasGraceful = gracefulShutdownWrapperHandler.awaitShutdown(this.getCfg().getShutdownConfig().getGracefulDelay());
        servletDeploymentMgr.stop();
        servletDeploymentMgr.undeploy();
        return wasGraceful;
    }

    /*
     * WARNING - void declaration
     */
    private final DeployedDistributionInfo deploySolrDistributionToCache(Path solrDistribution) {
        void warCopyFailed;
        Object element$iv;
        Object $receiver$iv;
        void warRootPath;
        void warLibPath;
        Iterator warJarFs;
        Object warUri;
        Pair pair;
        Object checkRootOfZip;
        this.log.warn("Extracting Solr from file: " + solrDistribution);
        Path tempDirThisSolr = this.getCfg().getTempDir().resolve(this.getCfg().getSolrVersion());
        Path tempDirHtml = tempDirThisSolr.resolve("html-root");
        Path tempDirJars = tempDirThisSolr.resolve("lib");
        PathsKt.deleteRecursively((Path)tempDirThisSolr);
        Files.createDirectories(tempDirThisSolr, new FileAttribute[0]);
        Files.createDirectories(tempDirHtml, new FileAttribute[0]);
        Files.createDirectories(tempDirJars, new FileAttribute[0]);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        DeployedDistributionInfo FAILED_DEPLOYMENT = new DeployedDistributionInfo(false, tempDirHtml, classLoader);
        Path normalizedPathToDistribution = solrDistribution.normalize().toAbsolutePath();
        String unixStylePathForUri = StringsKt.replace$default((String)StringsKt.replace$default((String)((Object)normalizedPathToDistribution).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), (char)'\\', (char)'/', (boolean)false, (int)4, null);
        if (StringsKt.endsWith$default((String)unixStylePathForUri, (String)".zip", (boolean)false, (int)2, null)) {
            URI checkZip = new URI("jar:file", uy.klutter.core.jdk.StringsKt.mustStartWith((String)unixStylePathForUri, (char)'/'), null);
            this.log.warn("  " + checkZip);
            FileSystem checkZipFs = FileSystems.newFileSystem(checkZip, MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)"false")));
            checkRootOfZip = checkZipFs.getPath("/", new String[0]);
            Path rootDir = (Path)CollectionsKt.firstOrNull((Iterable)Files.newDirectoryStream((Path)checkRootOfZip));
            if (rootDir != null) {
                Path correctWar;
                String firstLevelDir = uy.klutter.core.jdk.StringsKt.mustNotEndWith((String)uy.klutter.core.jdk.StringsKt.mustNotStartWith((String)((Object)rootDir.getName(0)).toString(), (char)'/'), (char)'/');
                Path checkInnerWar = checkZipFs.getPath("/" + firstLevelDir + "/server/webapps/solr.war", new String[0]);
                Path checkOldInnerWar = checkZipFs.getPath("/" + firstLevelDir + "/example/webapps/solr.war", new String[0]);
                Path path = PathsKt.exists((Path)checkInnerWar) ? checkInnerWar : (correctWar = PathsKt.exists((Path)checkOldInnerWar) ? checkOldInnerWar : (Path)null);
                if (correctWar != null) {
                    FileSystem fileSystem;
                    Path tempWar = tempDirThisSolr.resolve("extracted-solr.war");
                    Files.copy(correctWar, tempWar, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    URI warUri2 = new URI("jar:file", uy.klutter.core.jdk.StringsKt.mustStartWith((String)((Object)tempWar).toString(), (char)'/'), null);
                    try {
                        this.log.warn("  " + warUri2);
                        fileSystem = FileSystems.newFileSystem(warUri2, MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)"false")));
                    }
                    catch (Throwable ex) {
                        StringBuilder stringBuilder = new StringBuilder().append("The extracted distribution WAR file from ").append(solrDistribution).append(" cannot be opened as a Zip file, due to '");
                        String string = ex.getMessage();
                        if (string == null) {
                            string = ex.getClass().getName();
                        }
                        this.log.error(stringBuilder.append(string).append("'").toString(), ex);
                        return FAILED_DEPLOYMENT;
                    }
                    FileSystem warJarFs2 = fileSystem;
                    pair = new Pair((Object)warJarFs2.getPath("/WEB-INF/lib/", new String[0]), (Object)warJarFs2.getPath("/", new String[0]));
                } else {
                    Path checkInnerDir = checkZipFs.getPath("/" + firstLevelDir + "/server/solr-webapp/webapp", new String[0]);
                    this.log.warn("  " + checkZip + "!" + checkInnerDir);
                    pair = new Pair((Object)checkInnerDir.resolve("WEB-INF/lib/"), (Object)checkInnerDir);
                }
            } else {
                this.log.error("The distribution Zip file from " + solrDistribution + " does not seem to contain a solr-* root directory");
                pair = new Pair(null, null);
            }
        } else {
            warUri = new URI("jar:file", uy.klutter.core.jdk.StringsKt.mustStartWith((String)unixStylePathForUri, (char)'/'), null);
            try {
                this.log.warn("  " + warUri);
                checkRootOfZip = FileSystems.newFileSystem((URI)warUri, MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)"false")));
            }
            catch (Throwable ex) {
                StringBuilder stringBuilder = new StringBuilder().append("The WAR file ").append(solrDistribution).append(" cannot be opened as a Zip file, due to '");
                String string = ex.getMessage();
                if (string == null) {
                    string = ex.getClass().getName();
                }
                this.log.error(stringBuilder.append(string).append("'").toString(), ex);
                return FAILED_DEPLOYMENT;
            }
            warJarFs = checkRootOfZip;
            pair = new Pair((Object)((FileSystem)((Object)warJarFs)).getPath("/WEB-INF/lib/", new String[0]), (Object)((FileSystem)((Object)warJarFs)).getPath("/", new String[0]));
        }
        Pair pair2 = pair;
        Path path = (Path)pair2.component1();
        Path path2 = (Path)pair2.component2();
        pair2 = null;
        if (warLibPath == null || warRootPath == null || PathsKt.notExists((Path)warLibPath) || !Files.isDirectory((Path)warLibPath, new LinkOption[0])) {
            this.log.error("The WAR file " + solrDistribution + " does not contain WEB-INF/lib/ directory for the classpath jars");
            return FAILED_DEPLOYMENT;
        }
        ArrayList<URL> jarFiles = new ArrayList<URL>();
        warUri = Files.newDirectoryStream((Path)warLibPath, "*.jar");
        warJarFs = $receiver$iv.iterator();
        while (warJarFs.hasNext()) {
            element$iv = warJarFs.next();
            Path zippedJar = (Path)element$iv;
            Path jarDestination = tempDirJars.resolve(((Object)zippedJar.getFileName()).toString());
            Files.copy(zippedJar, jarDestination, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            jarFiles.add(jarDestination.toUri().toURL());
        }
        if (this.getCfg().hasLibExtDir()) {
            $receiver$iv = Files.newDirectoryStream(this.getCfg().getLibExtDir(), "*.jar");
            warJarFs = $receiver$iv.iterator();
            while (warJarFs.hasNext()) {
                element$iv = warJarFs.next();
                Path extJar = (Path)element$iv;
                jarFiles.add(extJar.toUri().toURL());
            }
        }
        $receiver$iv = new Ref.BooleanRef();
        ((Ref.BooleanRef)$receiver$iv).element = false;
        Files.walkFileTree((Path)warRootPath, (FileVisitor<? super Path>)new FileVisitor<Path>(this, (Path)warRootPath, tempDirHtml, (Ref.BooleanRef)warCopyFailed){
            final /* synthetic */ Server this$0;
            final /* synthetic */ Path $warRootPath;
            final /* synthetic */ Path $tempDirHtml;
            final /* synthetic */ Ref.BooleanRef $warCopyFailed;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public FileVisitResult preVisitDirectory(@Nullable Path dir, @NotNull BasicFileAttributes attrs) {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                Path path = dir;
                if (path == null) {
                    Intrinsics.throwNpe();
                }
                String relativeSourceDir = ((Object)this.$warRootPath.relativize(path)).toString();
                CharSequence charSequence = relativeSourceDir;
                if ($receiver$iv.length() == 0) {
                    return FileVisitResult.CONTINUE;
                }
                if (Intrinsics.areEqual((Object)relativeSourceDir, (Object)"WEB-INF/") || Intrinsics.areEqual((Object)relativeSourceDir, (Object)"META-INF/")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path destination = this.$tempDirHtml.resolve(relativeSourceDir);
                try {
                    Files.copy(dir, destination, StandardCopyOption.COPY_ATTRIBUTES);
                }
                catch (FileAlreadyExistsException ex) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@Nullable Path dir, @Nullable IOException exc) {
                if (exc == null) {
                    Path path = dir;
                    if (path == null) {
                        Intrinsics.throwNpe();
                    }
                    Path destination = this.$tempDirHtml.resolve(((Object)this.$warRootPath.relativize(path)).toString());
                    FileTime lastModTime = Files.getLastModifiedTime(dir, new LinkOption[0]);
                    Files.setLastModifiedTime(destination, lastModTime);
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult visitFile(@Nullable Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                Path path = file;
                if (path == null) {
                    Intrinsics.throwNpe();
                }
                Path destination = this.$tempDirHtml.resolve(((Object)this.$warRootPath.relativize(path)).toString());
                Files.copy(file, destination, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult visitFileFailed(@Nullable Path file, @Nullable IOException ex) {
                Object object;
                Logger logger = this.this$0.getLog();
                Path path = file;
                StringBuilder stringBuilder = new StringBuilder().append("Unable to copy from WAR to temp directory, file ").append(String.valueOf(path != null ? path.toAbsolutePath() : null)).append(", due to '");
                Object object2 = ex;
                if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                    Serializable serializable = ex;
                    object2 = serializable != null && (serializable = serializable.getClass()) != null ? ((Class)serializable).getName() : (object = null);
                }
                if (object2 == null) {
                    object = "unknown";
                }
                logger.error(stringBuilder.append((String)object).append("'").toString(), (Throwable)ex);
                this.$warCopyFailed.element = true;
                return FileVisitResult.TERMINATE;
            }
            {
                this.this$0 = $outer;
                this.$warRootPath = $captured_local_variable$1;
                this.$tempDirHtml = $captured_local_variable$2;
                this.$warCopyFailed = $captured_local_variable$3;
            }
        });
        if (warCopyFailed.element) {
            this.log.error("The WAR file " + solrDistribution + " could not be copied to temp directory");
            return FAILED_DEPLOYMENT;
        }
        ChildFirstClassloader classLoader2 = new ChildFirstClassloader((List)jarFiles, this.getClass().getClassLoader());
        return new DeployedDistributionInfo(true, tempDirHtml, (ClassLoader)classLoader2);
    }

    /*
     * WARNING - void declaration
     */
    private final ServletDeploymentAndHandler buildSolrServletHandler(DeployedDistributionInfo solrWarDeployment) {
        void wrappedHandlers;
        Object rl;
        Object element$iv2;
        RequestLimitHelper requestLimitHelper;
        void it;
        void var20_20;
        void destination$iv$iv;
        Object item$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Unit unit;
        Path it2;
        DeploymentInfo deploymentInfo;
        Path $receiver$iv2;
        Class<?> ex3;
        Class<?> clazz;
        Class<Servlet> clazz2;
        Class<Filter> solrDispatchFilterClass = solrWarDeployment.getClassLoader().loadClass("org.apache.solr.servlet.SolrDispatchFilter").asSubclass(Filter.class);
        try {
            clazz2 = solrWarDeployment.getClassLoader().loadClass("org.apache.solr.servlet.ZookeeperInfoServlet").asSubclass(Servlet.class);
        }
        catch (ClassNotFoundException ex2) {
            clazz2 = null;
        }
        Class<Servlet> solrZookeeprServletClass = clazz2;
        Class<Servlet> solrAdminUiServletClass = solrWarDeployment.getClassLoader().loadClass("org.apache.solr.servlet.LoadAdminUiServlet").asSubclass(Servlet.class);
        Class<Servlet> solrRestApiServletClass = solrWarDeployment.getClassLoader().loadClass("org.restlet.ext.servlet.ServerServlet").asSubclass(Servlet.class);
        try {
            clazz = solrWarDeployment.getClassLoader().loadClass("org.apache.solr.rest.SolrSchemaRestApi");
        }
        catch (ClassNotFoundException ex3) {
            clazz = solrWarDeployment.getClassLoader().loadClass("org.apache.solr.rest.SolrRestApi");
        }
        Class<?> solrRestApiClass = clazz;
        try {
            ex3 = solrWarDeployment.getClassLoader().loadClass("org.apache.solr.rest.SolrConfigRestApi");
        }
        catch (ClassNotFoundException ex4) {
            ex3 = null;
        }
        Class<?> solrRestConfigApiClass = ex3;
        DeploymentInfo deployment = Servlets.deployment().setClassLoader(solrWarDeployment.getClassLoader()).setContextPath(this.getCfg().getSolrContextPath()).setDefaultServletConfig((DefaultServletConfig)new SolrDefaultServletConfig()).setDefaultEncoding("UTF-8").setDeploymentName("solr.war").setEagerFilterInit(true).addFilters(new FilterInfo[]{Servlets.filter((String)"SolrRequestFilter", solrDispatchFilterClass).addInitParam("path-prefix", (String)null).addInitParam("excludePatterns", "/css/.+,/js/.+,/img/.+,/tpl/.+")}).addFilterUrlMapping("SolrRequestFilter", "/*", DispatcherType.REQUEST).addServlets(new ServletInfo[]{Servlets.servlet((String)"LoadAdminUI", solrAdminUiServletClass).addMapping("index.html").addMapping("admin.html").addMapping("old.html").setRequireWelcomeFileMapping(true), Servlets.servlet((String)"SolrRestApi", solrRestApiServletClass).addInitParam("org.restlet.application", solrRestApiClass.getName()).addMapping("/schema/*").setRequireWelcomeFileMapping(true)}).addMimeMapping(new MimeMapping(".xsl", "application/xslt+xml")).addWelcomePages(new String[]{"index.html", "admin.html"});
        Path path = solrWarDeployment.getHtmlDir();
        if (path != null) {
            Path ex4 = path;
            Path htmlDir = $receiver$iv2;
            deploymentInfo = deployment.setResourceManager((ResourceManager)new FileResourceManager(solrWarDeployment.getHtmlDir().toFile(), 1024L));
        } else {
            deploymentInfo = null;
        }
        if (solrRestConfigApiClass != null) {
            deployment.addServlet(Servlets.servlet((String)"SolrConfigRestApi", solrRestApiServletClass).addInitParam("org.restlet.application", solrRestConfigApiClass.getName()).addMapping("/config/*"));
        }
        if (solrZookeeprServletClass != null) {
            deployment.addServlet(Servlets.servlet((String)"Zookeeper", solrZookeeprServletClass).addMapping("/zookeeper"));
        }
        this.log.warn("Initializing Solr, deploying the Servlet Container...");
        Path path2 = solrWarDeployment.getHtmlDir();
        if (path2 != null) {
            $receiver$iv2 = path2;
            it2 = $receiver$iv2;
            this.log.warn("  using static files: " + it2.toFile().getAbsolutePath());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        DeploymentManager deploymentManager = Servlets.defaultContainer().addDeployment(deployment);
        Intrinsics.checkExpressionValueIsNotNull((Object)deploymentManager, (String)"Servlets.defaultContaine\u2026addDeployment(deployment)");
        this.setServletDeploymentMgr(deploymentManager);
        this.getServletDeploymentMgr().deploy();
        HttpHandler deploymentHandler = this.getServletDeploymentMgr().start();
        this.log.warn("Solr Servlet Container deployed.");
        it2 = new Ref.ObjectRef();
        ((Ref.ObjectRef)it2).element = deploymentHandler;
        Iterable $i$a$2 = this.getCfg().getRequestLimiters().values();
        void $i$f$let = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            RequestLimitConfig requestLimitConfig = (RequestLimitConfig)item$iv$iv;
            var20_20 = destination$iv$iv;
            void v5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
            requestLimitHelper = new RequestLimitHelper((RequestLimitConfig)v5);
            var20_20.add(requestLimitHelper);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv2 : $receiver$iv) {
            rl = (RequestLimitHelper)element$iv2;
            HttpHandler httpHandler = (HttpHandler)wrappedHandlers.element;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpHandler, (String)"wrappedHandlers");
            HttpHandler httpHandler2 = deploymentHandler;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpHandler2, (String)"deploymentHandler");
            wrappedHandlers.element = ((RequestLimitHelper)rl).nestHandlerInsideRateLimitingBySuffixHandler(httpHandler, httpHandler2);
        }
        $receiver$iv = this.getCfg().getRequestLimiters().values();
        $receiver$iv$iv = $receiver$iv;
        element$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        rl = $receiver$iv$iv.iterator();
        while (rl.hasNext()) {
            item$iv$iv = rl.next();
            RequestLimitConfig $i$f$forEach = (RequestLimitConfig)item$iv$iv;
            var20_20 = destination$iv$iv;
            void v8 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
            requestLimitHelper = new RequestLimitHelper((RequestLimitConfig)v8);
            var20_20.add(requestLimitHelper);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv2 : $receiver$iv) {
            rl = (RequestLimitHelper)element$iv2;
            HttpHandler httpHandler = (HttpHandler)wrappedHandlers.element;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpHandler, (String)"wrappedHandlers");
            HttpHandler httpHandler3 = deploymentHandler;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpHandler3, (String)"deploymentHandler");
            wrappedHandlers.element = ((RequestLimitHelper)rl).nestHandlerInsideRateLimitingByExactHandler(httpHandler, httpHandler3);
        }
        PathHandler pathHandler = Handlers.path((HttpHandler)((HttpHandler)Handlers.redirect((String)(uy.klutter.core.jdk.StringsKt.mustEndWith((String)this.getCfg().getSolrContextPath(), (char)'/') + "index.html")))).addPrefixPath(this.getCfg().getSolrContextPath(), (HttpHandler)wrappedHandlers.element);
        DeploymentManager deploymentManager2 = this.getServletDeploymentMgr();
        HttpHandler httpHandler = (HttpHandler)pathHandler;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpHandler, (String)"pathHandler");
        return new ServletDeploymentAndHandler(deploymentManager2, httpHandler);
    }

    public Server(@NotNull ServerConfigLoader cfgLoader) {
        Intrinsics.checkParameterIsNotNull((Object)cfgLoader, (String)"cfgLoader");
        this.log = LoggerFactory.getLogger((String)"SolrServer");
        this.cfg$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ServerConfig>(this, cfgLoader){
            final /* synthetic */ Server this$0;
            final /* synthetic */ ServerConfigLoader $cfgLoader;

            @NotNull
            public final ServerConfig invoke() {
                Logger logger = this.this$0.getLog();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
                return new ServerConfig(logger, this.$cfgLoader);
            }
            {
                this.this$0 = server;
                this.$cfgLoader = serverConfigLoader;
                super(0);
            }
        }));
        this.server$delegate = Delegates.INSTANCE.notNull();
        this.gracefulShutdownWrapperHandler$delegate = Delegates.INSTANCE.notNull();
        this.servletDeploymentMgr$delegate = Delegates.INSTANCE.notNull();
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Server.class), "cfg", "getCfg()Luy/kohesive/solr/undertow/ServerConfig;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Server.class), "server", "getServer()Lio/undertow/Undertow;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Server.class), "gracefulShutdownWrapperHandler", "getGracefulShutdownWrapperHandler()Lio/undertow/server/handlers/GracefulShutdownHandler;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Server.class), "servletDeploymentMgr", "getServletDeploymentMgr()Lio/undertow/servlet/api/DeploymentManager;"))};
    }

    public static final /* synthetic */ void access$setServer$p(Server $this, @NotNull Undertow undertow) {
        $this.setServer(undertow);
    }

    @NotNull
    public static final /* synthetic */ GracefulShutdownHandler access$getGracefulShutdownWrapperHandler$p(Server $this) {
        return $this.getGracefulShutdownWrapperHandler();
    }

    public static final /* synthetic */ void access$setGracefulShutdownWrapperHandler$p(Server $this, @NotNull GracefulShutdownHandler gracefulShutdownHandler) {
        $this.setGracefulShutdownWrapperHandler(gracefulShutdownHandler);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Luy/kohesive/solr/undertow/Server$DeployedDistributionInfo;", "", "successfulDeploy", "", "htmlDir", "Ljava/nio/file/Path;", "classLoader", "Ljava/lang/ClassLoader;", "(ZLjava/nio/file/Path;Ljava/lang/ClassLoader;)V", "getClassLoader", "()Ljava/lang/ClassLoader;", "getHtmlDir", "()Ljava/nio/file/Path;", "getSuccessfulDeploy", "()Z", "component1", "component2", "component3", "copy", "solr-undertow-compileKotlin"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, strings={"Luy/kohesive/solr/undertow/Server$DeployedDistributionInfo;", "", "successfulDeploy", "", "htmlDir", "Ljava/nio/file/Path;", "classLoader", "Ljava/lang/ClassLoader;", "(ZLjava/nio/file/Path;Ljava/lang/ClassLoader;)V", "getClassLoader", "()Ljava/lang/ClassLoader;", "getHtmlDir", "()Ljava/nio/file/Path;", "getSuccessfulDeploy", "()Z", "component1", "component2", "component3", "copy", "solr-undertow-compileKotlin"})
    private static final class DeployedDistributionInfo {
        private final boolean successfulDeploy;
        @Nullable
        private final Path htmlDir;
        @NotNull
        private final ClassLoader classLoader;

        public final boolean getSuccessfulDeploy() {
            return this.successfulDeploy;
        }

        @Nullable
        public final Path getHtmlDir() {
            return this.htmlDir;
        }

        @NotNull
        public final ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public DeployedDistributionInfo(boolean successfulDeploy, @Nullable Path htmlDir, @NotNull ClassLoader classLoader) {
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            this.successfulDeploy = successfulDeploy;
            this.htmlDir = htmlDir;
            this.classLoader = classLoader;
        }

        public final boolean component1() {
            return this.successfulDeploy;
        }

        @Nullable
        public final Path component2() {
            return this.htmlDir;
        }

        @NotNull
        public final ClassLoader component3() {
            return this.classLoader;
        }

        @NotNull
        public final DeployedDistributionInfo copy(boolean successfulDeploy, @Nullable Path htmlDir, @NotNull ClassLoader classLoader) {
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            return new DeployedDistributionInfo(successfulDeploy, htmlDir, classLoader);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ DeployedDistributionInfo copy$default(DeployedDistributionInfo deployedDistributionInfo, boolean bl, Path path, ClassLoader classLoader, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                bl = deployedDistributionInfo.successfulDeploy;
            }
            if ((n & 2) != 0) {
                path = deployedDistributionInfo.htmlDir;
            }
            if ((n & 4) != 0) {
                classLoader = deployedDistributionInfo.classLoader;
            }
            return deployedDistributionInfo.copy(bl, path, classLoader);
        }

        public String toString() {
            return "DeployedDistributionInfo(successfulDeploy=" + this.successfulDeploy + ", htmlDir=" + this.htmlDir + ", classLoader=" + this.classLoader + ")";
        }

        public int hashCode() {
            int n = this.successfulDeploy ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            Path path = this.htmlDir;
            ClassLoader classLoader = this.classLoader;
            return (n * 31 + (path != null ? ((Object)path).hashCode() : 0)) * 31 + (classLoader != null ? classLoader.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DeployedDistributionInfo)) break block3;
                    DeployedDistributionInfo deployedDistributionInfo = (DeployedDistributionInfo)object;
                    if (!(this.successfulDeploy == deployedDistributionInfo.successfulDeploy) || !Intrinsics.areEqual((Object)this.htmlDir, (Object)deployedDistributionInfo.htmlDir) || !Intrinsics.areEqual((Object)this.classLoader, (Object)deployedDistributionInfo.classLoader)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Luy/kohesive/solr/undertow/Server$ServletDeploymentAndHandler;", "", "deploymentManager", "Lio/undertow/servlet/api/DeploymentManager;", "pathHandler", "Lio/undertow/server/HttpHandler;", "(Lio/undertow/servlet/api/DeploymentManager;Lio/undertow/server/HttpHandler;)V", "getDeploymentManager", "()Lio/undertow/servlet/api/DeploymentManager;", "getPathHandler", "()Lio/undertow/server/HttpHandler;", "component1", "component2", "copy", "solr-undertow-compileKotlin"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, strings={"Luy/kohesive/solr/undertow/Server$ServletDeploymentAndHandler;", "", "deploymentManager", "Lio/undertow/servlet/api/DeploymentManager;", "pathHandler", "Lio/undertow/server/HttpHandler;", "(Lio/undertow/servlet/api/DeploymentManager;Lio/undertow/server/HttpHandler;)V", "getDeploymentManager", "()Lio/undertow/servlet/api/DeploymentManager;", "getPathHandler", "()Lio/undertow/server/HttpHandler;", "component1", "component2", "copy", "solr-undertow-compileKotlin"})
    private static final class ServletDeploymentAndHandler {
        @NotNull
        private final DeploymentManager deploymentManager;
        @NotNull
        private final HttpHandler pathHandler;

        @NotNull
        public final DeploymentManager getDeploymentManager() {
            return this.deploymentManager;
        }

        @NotNull
        public final HttpHandler getPathHandler() {
            return this.pathHandler;
        }

        public ServletDeploymentAndHandler(@NotNull DeploymentManager deploymentManager, @NotNull HttpHandler pathHandler) {
            Intrinsics.checkParameterIsNotNull((Object)deploymentManager, (String)"deploymentManager");
            Intrinsics.checkParameterIsNotNull((Object)pathHandler, (String)"pathHandler");
            this.deploymentManager = deploymentManager;
            this.pathHandler = pathHandler;
        }

        @NotNull
        public final DeploymentManager component1() {
            return this.deploymentManager;
        }

        @NotNull
        public final HttpHandler component2() {
            return this.pathHandler;
        }

        @NotNull
        public final ServletDeploymentAndHandler copy(@NotNull DeploymentManager deploymentManager, @NotNull HttpHandler pathHandler) {
            Intrinsics.checkParameterIsNotNull((Object)deploymentManager, (String)"deploymentManager");
            Intrinsics.checkParameterIsNotNull((Object)pathHandler, (String)"pathHandler");
            return new ServletDeploymentAndHandler(deploymentManager, pathHandler);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ServletDeploymentAndHandler copy$default(ServletDeploymentAndHandler servletDeploymentAndHandler, DeploymentManager deploymentManager, HttpHandler httpHandler, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                deploymentManager = servletDeploymentAndHandler.deploymentManager;
            }
            if ((n & 2) != 0) {
                httpHandler = servletDeploymentAndHandler.pathHandler;
            }
            return servletDeploymentAndHandler.copy(deploymentManager, httpHandler);
        }

        public String toString() {
            return "ServletDeploymentAndHandler(deploymentManager=" + this.deploymentManager + ", pathHandler=" + this.pathHandler + ")";
        }

        public int hashCode() {
            DeploymentManager deploymentManager = this.deploymentManager;
            HttpHandler httpHandler = this.pathHandler;
            return (deploymentManager != null ? deploymentManager.hashCode() : 0) * 31 + (httpHandler != null ? httpHandler.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ServletDeploymentAndHandler)) break block3;
                    ServletDeploymentAndHandler servletDeploymentAndHandler = (ServletDeploymentAndHandler)object;
                    if (!Intrinsics.areEqual((Object)this.deploymentManager, (Object)servletDeploymentAndHandler.deploymentManager) || !Intrinsics.areEqual((Object)this.pathHandler, (Object)servletDeploymentAndHandler.pathHandler)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Luy/kohesive/solr/undertow/Server$ShutdownRequestHandler;", "Lio/undertow/server/HttpHandler;", "servletDeploymentMgr", "Lio/undertow/servlet/api/DeploymentManager;", "gracefulShutdownWrapperHandler", "Lio/undertow/server/handlers/GracefulShutdownHandler;", "(Luy/kohesive/solr/undertow/Server;Lio/undertow/servlet/api/DeploymentManager;Lio/undertow/server/handlers/GracefulShutdownHandler;)V", "getGracefulShutdownWrapperHandler", "()Lio/undertow/server/handlers/GracefulShutdownHandler;", "getServletDeploymentMgr", "()Lio/undertow/servlet/api/DeploymentManager;", "handleRequest", "", "exchange", "Lio/undertow/server/HttpServerExchange;", "solr-undertow-compileKotlin"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, strings={"Luy/kohesive/solr/undertow/Server$ShutdownRequestHandler;", "Lio/undertow/server/HttpHandler;", "servletDeploymentMgr", "Lio/undertow/servlet/api/DeploymentManager;", "gracefulShutdownWrapperHandler", "Lio/undertow/server/handlers/GracefulShutdownHandler;", "(Luy/kohesive/solr/undertow/Server;Lio/undertow/servlet/api/DeploymentManager;Lio/undertow/server/handlers/GracefulShutdownHandler;)V", "getGracefulShutdownWrapperHandler", "()Lio/undertow/server/handlers/GracefulShutdownHandler;", "getServletDeploymentMgr", "()Lio/undertow/servlet/api/DeploymentManager;", "handleRequest", "", "exchange", "Lio/undertow/server/HttpServerExchange;", "solr-undertow-compileKotlin"})
    private final class ShutdownRequestHandler
    implements HttpHandler {
        @NotNull
        private final DeploymentManager servletDeploymentMgr;
        @NotNull
        private final GracefulShutdownHandler gracefulShutdownWrapperHandler;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest(@NotNull HttpServerExchange exchange) {
            Intrinsics.checkParameterIsNotNull((Object)exchange, (String)"exchange");
            CharSequence $receiver$iv = Server.this.getCfg().getShutdownConfig().getPassword();
            if ($receiver$iv == null || StringsKt.isBlank((CharSequence)$receiver$iv)) {
                exchange.setStatusCode(403).getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                exchange.getResponseSender().send("forbidden");
                Server.this.getLog().error("Forbidden attempt to talk to shutdown port");
            } else {
                Deque deque = (Deque)exchange.getQueryParameters().get("password");
                if (Intrinsics.areEqual((Object)(deque != null ? (String)CollectionsKt.firstOrNull((Iterable)deque) : null), (Object)Server.this.getCfg().getShutdownConfig().getPassword()) ^ true) {
                    exchange.setStatusCode(401).getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                    exchange.getResponseSender().send("unauthorized");
                    Server.this.getLog().error("Unauthorized attempt to talk to shutdown port");
                } else {
                    if (exchange.isInIoThread()) {
                        exchange.dispatch((HttpHandler)this);
                        return;
                    }
                    Server.this.getLog().warn("Shutdown requested via shutdown port...");
                    boolean wasGraceful = Server.this.shutdownNicely(this.servletDeploymentMgr, this.gracefulShutdownWrapperHandler);
                    if (wasGraceful) {
                        try {
                            exchange.setStatusCode(200).getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                            exchange.getResponseSender().send("OK");
                        }
                        finally {
                            Server.this.getServer().stop();
                            Server.this.getLog().warn("Undeploy complete and graceful.");
                        }
                    }
                    try {
                        exchange.setStatusCode(500).getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                        exchange.getResponseSender().send("ERROR");
                    }
                    finally {
                        Server.this.getServer().stop();
                        Server.this.getLog().error("Undeploy complete, but shutdown was not graceful.");
                        System.exit(1);
                    }
                }
            }
        }

        @NotNull
        public final DeploymentManager getServletDeploymentMgr() {
            return this.servletDeploymentMgr;
        }

        @NotNull
        public final GracefulShutdownHandler getGracefulShutdownWrapperHandler() {
            return this.gracefulShutdownWrapperHandler;
        }

        public ShutdownRequestHandler(@NotNull DeploymentManager servletDeploymentMgr, GracefulShutdownHandler gracefulShutdownWrapperHandler) {
            Intrinsics.checkParameterIsNotNull((Object)servletDeploymentMgr, (String)"servletDeploymentMgr");
            Intrinsics.checkParameterIsNotNull((Object)gracefulShutdownWrapperHandler, (String)"gracefulShutdownWrapperHandler");
            this.servletDeploymentMgr = servletDeploymentMgr;
            this.gracefulShutdownWrapperHandler = gracefulShutdownWrapperHandler;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Luy/kohesive/solr/undertow/Server$RequestLimitHelper;", "", "rlCfg", "Luy/kohesive/solr/undertow/RequestLimitConfig;", "(Luy/kohesive/solr/undertow/RequestLimitConfig;)V", "exactPredicate", "Lio/undertow/predicate/Predicate;", "kotlin.jvm.PlatformType", "requestLimit", "Lio/undertow/server/handlers/RequestLimit;", "suffixPredicate", "hasExactPaths", "", "hasSuffixes", "nestHandlerInsideRateLimitingByExactHandler", "Lio/undertow/server/HttpHandler;", "handlerToNest", "handlerToRateLimit", "nestHandlerInsideRateLimitingBySuffixHandler", "solr-undertow-compileKotlin"})
    @KotlinClass(version={1, 1, 0}, data={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, strings={"Luy/kohesive/solr/undertow/Server$RequestLimitHelper;", "", "rlCfg", "Luy/kohesive/solr/undertow/RequestLimitConfig;", "(Luy/kohesive/solr/undertow/RequestLimitConfig;)V", "exactPredicate", "Lio/undertow/predicate/Predicate;", "kotlin.jvm.PlatformType", "requestLimit", "Lio/undertow/server/handlers/RequestLimit;", "suffixPredicate", "hasExactPaths", "", "hasSuffixes", "nestHandlerInsideRateLimitingByExactHandler", "Lio/undertow/server/HttpHandler;", "handlerToNest", "handlerToRateLimit", "nestHandlerInsideRateLimitingBySuffixHandler", "solr-undertow-compileKotlin"})
    private static final class RequestLimitHelper {
        private final RequestLimit requestLimit;
        private final Predicate exactPredicate;
        private final Predicate suffixPredicate;
        private final RequestLimitConfig rlCfg;

        private final boolean hasExactPaths() {
            Collection $receiver$iv = this.rlCfg.getExactPaths();
            return !$receiver$iv.isEmpty();
        }

        private final boolean hasSuffixes() {
            Collection $receiver$iv = this.rlCfg.getPathSuffixes();
            return !$receiver$iv.isEmpty();
        }

        @NotNull
        public final HttpHandler nestHandlerInsideRateLimitingBySuffixHandler(@NotNull HttpHandler handlerToNest, @NotNull HttpHandler handlerToRateLimit) {
            HttpHandler httpHandler;
            Intrinsics.checkParameterIsNotNull((Object)handlerToNest, (String)"handlerToNest");
            Intrinsics.checkParameterIsNotNull((Object)handlerToRateLimit, (String)"handlerToRateLimit");
            if (this.hasSuffixes()) {
                HttpHandler httpHandler2 = (HttpHandler)Handlers.predicate((Predicate)this.suffixPredicate, (HttpHandler)((HttpHandler)Handlers.requestLimitingHandler((RequestLimit)this.requestLimit, (HttpHandler)handlerToRateLimit)), (HttpHandler)handlerToNest);
                httpHandler = httpHandler2;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpHandler2, (String)"Handlers.predicate(suffi\u2026ateLimit), handlerToNest)");
            } else {
                httpHandler = handlerToNest;
            }
            return httpHandler;
        }

        @NotNull
        public final HttpHandler nestHandlerInsideRateLimitingByExactHandler(@NotNull HttpHandler handlerToNest, @NotNull HttpHandler handlerToRateLimit) {
            HttpHandler httpHandler;
            Intrinsics.checkParameterIsNotNull((Object)handlerToNest, (String)"handlerToNest");
            Intrinsics.checkParameterIsNotNull((Object)handlerToRateLimit, (String)"handlerToRateLimit");
            if (this.hasExactPaths()) {
                HttpHandler httpHandler2 = (HttpHandler)Handlers.predicate((Predicate)this.exactPredicate, (HttpHandler)((HttpHandler)Handlers.requestLimitingHandler((RequestLimit)this.requestLimit, (HttpHandler)handlerToRateLimit)), (HttpHandler)handlerToNest);
                httpHandler = httpHandler2;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpHandler2, (String)"Handlers.predicate(exact\u2026ateLimit), handlerToNest)");
            } else {
                httpHandler = handlerToNest;
            }
            return httpHandler;
        }

        public RequestLimitHelper(@NotNull RequestLimitConfig rlCfg) {
            Collection $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)rlCfg, (String)"rlCfg");
            this.rlCfg = rlCfg;
            this.requestLimit = new RequestLimit(this.rlCfg.getConcurrentRequestLimit(), this.rlCfg.getMaxQueuedRequestLimit());
            Collection collection = this.rlCfg.getExactPaths();
            RequestLimitHelper requestLimitHelper = this;
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v0;
            String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = stringArray;
            String[] stringArray2 = (String[])objectArray;
            requestLimitHelper.exactPredicate = Predicates.paths((String[])Arrays.copyOf(stringArray2, stringArray2.length));
            $receiver$iv = this.rlCfg.getPathSuffixes();
            requestLimitHelper = this;
            Collection collection2 = $receiver$iv;
            if (collection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            thisCollection$iv = collection2;
            String[] stringArray3 = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray = stringArray3;
            String[] stringArray4 = (String[])objectArray;
            requestLimitHelper.suffixPredicate = Predicates.suffixes((String[])Arrays.copyOf(stringArray4, stringArray4.length));
        }
    }
}

