/*
 * Decompiled with CFR 0.152.
 */
package uy.kohesive.solr.undertow;

import com.google.common.util.concurrent.RateLimiter;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import uy.klutter.core.common.NumbersKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0019\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006\u001d"}, d2={"Luy/kohesive/solr/undertow/RequestPerSecondRateLimiter;", "Lio/undertow/server/HttpHandler;", "maxRPS", "", "nextHandler", "minPauseOnBusyMillis", "maxPauseOnBusyMillis", "httpCodeWhenBusy", "", "(JLio/undertow/server/HttpHandler;JJI)V", "burstLimiter", "Lcom/google/common/util/concurrent/RateLimiter;", "kotlin.jvm.PlatformType", "getBurstLimiter", "()Lcom/google/common/util/concurrent/RateLimiter;", "failureHandler", "getFailureHandler", "()Lio/undertow/server/HttpHandler;", "getHttpCodeWhenBusy", "()I", "getMaxPauseOnBusyMillis", "()J", "getMaxRPS", "getMinPauseOnBusyMillis", "getNextHandler", "handleRequest", "", "exchange", "Lio/undertow/server/HttpServerExchange;", "solr-undertow"})
public final class RequestPerSecondRateLimiter
implements HttpHandler {
    private final RateLimiter burstLimiter;
    @NotNull
    private final HttpHandler failureHandler;
    private final long maxRPS;
    @NotNull
    private final HttpHandler nextHandler;
    private final long minPauseOnBusyMillis;
    private final long maxPauseOnBusyMillis;
    private final int httpCodeWhenBusy;

    public final RateLimiter getBurstLimiter() {
        return this.burstLimiter;
    }

    @NotNull
    public final HttpHandler getFailureHandler() {
        return this.failureHandler;
    }

    public void handleRequest(@NotNull HttpServerExchange exchange) {
        Intrinsics.checkParameterIsNotNull((Object)exchange, (String)"exchange");
        if (exchange.isInIoThread()) {
            if (this.burstLimiter.tryAcquire(1)) {
                this.nextHandler.handleRequest(exchange);
                return;
            }
            if (this.maxPauseOnBusyMillis <= 0L) {
                this.failureHandler.handleRequest(exchange);
                return;
            }
            exchange.dispatch((HttpHandler)this);
            return;
        }
        if (!this.burstLimiter.tryAcquire(1, this.maxPauseOnBusyMillis, TimeUnit.MILLISECONDS)) {
            if (this.minPauseOnBusyMillis > 0L) {
                try {
                    Thread.sleep(NumbersKt.minimum((long)this.minPauseOnBusyMillis, (long)this.maxPauseOnBusyMillis));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.failureHandler.handleRequest(exchange);
            return;
        }
        this.nextHandler.handleRequest(exchange);
    }

    public final long getMaxRPS() {
        return this.maxRPS;
    }

    @NotNull
    public final HttpHandler getNextHandler() {
        return this.nextHandler;
    }

    public final long getMinPauseOnBusyMillis() {
        return this.minPauseOnBusyMillis;
    }

    public final long getMaxPauseOnBusyMillis() {
        return this.maxPauseOnBusyMillis;
    }

    public final int getHttpCodeWhenBusy() {
        return this.httpCodeWhenBusy;
    }

    public RequestPerSecondRateLimiter(long maxRPS, @NotNull HttpHandler nextHandler, long minPauseOnBusyMillis, long maxPauseOnBusyMillis, int httpCodeWhenBusy) {
        Intrinsics.checkParameterIsNotNull((Object)nextHandler, (String)"nextHandler");
        this.maxRPS = maxRPS;
        this.nextHandler = nextHandler;
        this.minPauseOnBusyMillis = minPauseOnBusyMillis;
        this.maxPauseOnBusyMillis = maxPauseOnBusyMillis;
        this.httpCodeWhenBusy = httpCodeWhenBusy;
        this.burstLimiter = RateLimiter.create((double)this.maxRPS);
        this.failureHandler = (HttpHandler)new ResponseCodeHandler(this.httpCodeWhenBusy);
    }

    public /* synthetic */ RequestPerSecondRateLimiter(long l, HttpHandler httpHandler, long l2, long l3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l2 = 10L;
        }
        if ((n2 & 8) != 0) {
            l3 = 0L;
        }
        if ((n2 & 0x10) != 0) {
            n = 503;
        }
        this(l, httpHandler, l2, l3, n);
    }
}

