/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.angellist.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import vc.inreach.angellist.api.Tag;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ChildTags {
    public static final String CHILDREN = "children";
    public static final String TOTAL = "total";
    public static final String PER_PAGE = "per_page";
    public static final String PAGE = "page";
    public static final String LAST_PAGE = "last_page";
    @JsonProperty(value="children")
    private Set<Tag> children = ImmutableSet.of();
    @JsonProperty(value="total")
    private long total;
    @JsonProperty(value="per_page")
    private int perPage;
    @JsonProperty(value="page")
    private int page;
    @JsonProperty(value="last_page")
    private int lastPage;

    private ChildTags(Set<Tag> children, long total, int perPage, int page, int lastPage) {
        this.children = children;
        this.total = total;
        this.perPage = perPage;
        this.page = page;
        this.lastPage = lastPage;
    }

    private ChildTags() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<Tag> getChildren() {
        return this.children;
    }

    public long getTotal() {
        return this.total;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getPage() {
        return this.page;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChildTags other = (ChildTags)obj;
        return Objects.equals(this.children, other.children) && Objects.equals(this.total, other.total) && Objects.equals(this.perPage, other.perPage) && Objects.equals(this.page, other.page) && Objects.equals(this.lastPage, other.lastPage);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.total, this.perPage, this.page, this.lastPage);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(CHILDREN, this.children).add(TOTAL, this.total).add(PER_PAGE, this.perPage).add(PAGE, this.page).add(LAST_PAGE, this.lastPage).toString();
    }

    public static class Builder {
        private Set<Tag> children;
        private long total;
        private int perPage;
        private int page;
        private int lastPage;

        private Builder() {
        }

        private Builder(ChildTags parentTags) {
            this.children = parentTags.getChildren();
            this.total = parentTags.getTotal();
            this.perPage = parentTags.getPerPage();
            this.page = parentTags.getPage();
            this.lastPage = parentTags.getLastPage();
        }

        public Builder withChildren(Set<Tag> children) {
            this.children = children;
            return this;
        }

        public Builder withTotal(long total) {
            this.total = total;
            return this;
        }

        public Builder withPerPage(int perPage) {
            this.perPage = perPage;
            return this;
        }

        public Builder withPage(int page) {
            this.page = page;
            return this;
        }

        public Builder withLastPage(int lastPage) {
            this.lastPage = lastPage;
            return this;
        }

        public ChildTags build() {
            return new ChildTags(this.children, this.total, this.perPage, this.page, this.lastPage);
        }
    }
}

