/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.angellist.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Entity {
    public static final String ID = "id";
    public static final String URL = "url";
    public static final String SLUG = "slug";
    public static final String TYPE = "type";
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="slug")
    private String slug;
    @JsonProperty(value="type")
    private String type;

    private Entity(long id, String url, String slug, String type) {
        this.id = id;
        this.url = url;
        this.slug = slug;
        this.type = type;
    }

    private Entity() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getType() {
        return this.type;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.url, other.url) && Objects.equals(this.slug, other.slug) && Objects.equals(this.type, other.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url, this.slug, this.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(ID, this.id).add(URL, (Object)this.url).add(SLUG, (Object)this.slug).add(TYPE, (Object)this.type).toString();
    }

    public static class Builder {
        private long id;
        private String url;
        private String slug;
        private String type;

        private Builder() {
        }

        private Builder(Entity entity) {
            this.id = entity.getId();
            this.url = entity.getUrl();
            this.slug = entity.getSlug();
            this.type = entity.getType();
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withSlug(String slug) {
            this.slug = slug;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Entity build() {
            return new Entity(this.id, this.url, this.slug, this.type);
        }
    }
}

