/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.angellist.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import vc.inreach.angellist.api.Tag;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ParentTags {
    public static final String PARENTS = "parents";
    public static final String TOTAL = "total";
    public static final String PER_PAGE = "per_page";
    public static final String PAGE = "page";
    public static final String LAST_PAGE = "last_page";
    @JsonProperty(value="parents")
    private Set<Tag> parents = ImmutableSet.of();
    @JsonProperty(value="total")
    private long total;
    @JsonProperty(value="per_page")
    private int perPage;
    @JsonProperty(value="page")
    private int page;
    @JsonProperty(value="last_page")
    private int lastPage;

    private ParentTags(Set<Tag> parents, long total, int perPage, int page, int lastPage) {
        this.parents = parents;
        this.total = total;
        this.perPage = perPage;
        this.page = page;
        this.lastPage = lastPage;
    }

    private ParentTags() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<Tag> getParents() {
        return this.parents;
    }

    public long getTotal() {
        return this.total;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getPage() {
        return this.page;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParentTags other = (ParentTags)obj;
        return Objects.equals(this.parents, other.parents) && Objects.equals(this.total, other.total) && Objects.equals(this.perPage, other.perPage) && Objects.equals(this.page, other.page) && Objects.equals(this.lastPage, other.lastPage);
    }

    public int hashCode() {
        return Objects.hash(this.parents, this.total, this.perPage, this.page, this.lastPage);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(PARENTS, this.parents).add(TOTAL, this.total).add(PER_PAGE, this.perPage).add(PAGE, this.page).add(LAST_PAGE, this.lastPage).toString();
    }

    public static class Builder {
        private Set<Tag> parents;
        private long total;
        private int perPage;
        private int page;
        private int lastPage;

        private Builder() {
        }

        private Builder(ParentTags parentTags) {
            this.parents = parentTags.getParents();
            this.total = parentTags.getTotal();
            this.perPage = parentTags.getPerPage();
            this.page = parentTags.getPage();
            this.lastPage = parentTags.getLastPage();
        }

        public Builder withParents(Set<Tag> parents) {
            this.parents = parents;
            return this;
        }

        public Builder withTotal(long total) {
            this.total = total;
            return this;
        }

        public Builder withPerPage(int perPage) {
            this.perPage = perPage;
            return this;
        }

        public Builder withPage(int page) {
            this.page = page;
            return this;
        }

        public Builder withLastPage(int lastPage) {
            this.lastPage = lastPage;
            return this;
        }

        public ParentTags build() {
            return new ParentTags(this.parents, this.total, this.perPage, this.page, this.lastPage);
        }
    }
}

