/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.angellist.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import vc.inreach.angellist.api.CompanyType;
import vc.inreach.angellist.api.Market;
import vc.inreach.angellist.api.StartupRole;
import vc.inreach.angellist.api.Status;
import vc.inreach.angellist.api.StringDeserializer;
import vc.inreach.angellist.api.StringSerializer;
import vc.inreach.angellist.api.Tag;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Startup {
    public static final String ID = "id";
    public static final String HIDDEN = "hidden";
    public static final String COMMUNITY_PROFILE = "community_profile";
    public static final String NAME = "name";
    public static final String ANGELLIST_URL = "angellist_url";
    public static final String LOGO_URL = "logo_url";
    public static final String THUMB_URL = "thumb_url";
    public static final String QUALITY = "quality";
    public static final String PRODUCT_DESC = "product_desc";
    public static final String HIGH_CONCEPT = "high_concept";
    public static final String FOLLOWER_COUNT = "follower_count";
    public static final String COMPANY_URL = "company_url";
    public static final String CREATED_AT = "created_at";
    public static final String UPDATED_AT = "updated_at";
    public static final String TWITTER_URL = "twitter_url";
    public static final String BLOG_URL = "blog_url";
    public static final String VIDEO_URL = "video_url";
    public static final String MARKETS = "markets";
    public static final String LOCATIONS = "locations";
    public static final String STATUS = "status";
    public static final String SCREENSHOTS = "screenshots";
    public static final String COMPANY_SIZE = "company_size";
    public static final String COMPANY_TYPES = "company_types";
    public static final String ORGANIZATION_ID = "organization_id";
    public static final String ROLES = "roles";
    public static final String ANGELLIST_BASE_URL = "https://angel.co/";
    private static final String EMPTY = "";
    @JsonProperty(value="id")
    private Optional<Long> id = Optional.empty();
    @JsonProperty(value="hidden")
    private Optional<Boolean> hidden = Optional.empty();
    @JsonProperty(value="community_profile")
    private Optional<Boolean> communityProfile = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="name")
    private Optional<String> name = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="angellist_url")
    private Optional<String> angellistUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="logo_url")
    private Optional<String> logoUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="thumb_url")
    private Optional<String> thumbUrl = Optional.empty();
    @JsonProperty(value="quality")
    private Optional<Integer> quality = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="product_desc")
    private Optional<String> productDesc = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="high_concept")
    private Optional<String> highConcept = Optional.empty();
    @JsonProperty(value="follower_count")
    private Optional<Long> followerCount = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="company_url")
    private Optional<String> companyUrl = Optional.empty();
    @JsonProperty(value="created_at")
    private Optional<ZonedDateTime> createdAt = Optional.empty();
    @JsonProperty(value="updated_at")
    private Optional<ZonedDateTime> updatedAt = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="twitter_url")
    private Optional<String> twitterUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="blog_url")
    private Optional<String> blogUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="video_url")
    private Optional<String> videoUrl = Optional.empty();
    @JsonProperty(value="markets")
    private List<Market> markets = ImmutableList.of();
    @JsonProperty(value="locations")
    private List<Tag> locations = ImmutableList.of();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="company_size")
    private Optional<String> companySize = Optional.empty();
    @JsonProperty(value="company_types")
    private List<CompanyType> companyTypes = ImmutableList.of();
    @JsonProperty(value="status")
    private Optional<Status> status = Optional.empty();
    @JsonProperty(value="screenshots")
    private List<Map<String, String>> screenshots = ImmutableList.of();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="organization_id")
    private Optional<String> organizationId = Optional.empty();
    @JsonProperty(value="roles")
    private Optional<Set<StartupRole>> roles = Optional.empty();
    public static final Predicate<Startup> IS_NOT_HIDDEN = startup -> startup != null && startup.getHidden().orElse(Boolean.FALSE) == false;

    private Startup() {
    }

    private Startup(Optional<Long> id, Optional<Boolean> hidden, Optional<Boolean> communityProfile, Optional<String> name, Optional<String> angellistUrl, Optional<String> logoUrl, Optional<String> thumbUrl, Optional<Integer> quality, Optional<String> productDesc, Optional<String> highConcept, Optional<Long> followerCount, Optional<String> companyUrl, Optional<ZonedDateTime> createdAt, Optional<ZonedDateTime> updatedAt, Optional<String> twitterUrl, Optional<String> blogUrl, Optional<String> videoUrl, List<Market> markets, List<Tag> locations, Optional<String> companySize, List<CompanyType> companyTypes, Optional<Status> status, List<Map<String, String>> screenshots, Optional<String> organizationId, Optional<Set<StartupRole>> roles) {
        this.id = id;
        this.hidden = hidden;
        this.communityProfile = communityProfile;
        this.name = name;
        this.angellistUrl = angellistUrl;
        this.logoUrl = logoUrl;
        this.thumbUrl = thumbUrl;
        this.quality = quality;
        this.productDesc = productDesc;
        this.highConcept = highConcept;
        this.followerCount = followerCount;
        this.companyUrl = companyUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.twitterUrl = twitterUrl;
        this.blogUrl = blogUrl;
        this.videoUrl = videoUrl;
        this.markets = markets;
        this.locations = locations;
        this.companySize = companySize;
        this.companyTypes = companyTypes;
        this.status = status;
        this.screenshots = screenshots;
        this.organizationId = organizationId;
        this.roles = roles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Long> getId() {
        return this.id;
    }

    public Long requireId() {
        return this.id.get();
    }

    public Optional<Boolean> getHidden() {
        return this.hidden;
    }

    public Boolean requireHidden() {
        return this.hidden.get();
    }

    public Optional<Boolean> getCommunityProfile() {
        return this.communityProfile;
    }

    public Boolean requireCommunityProfile() {
        return this.communityProfile.get();
    }

    public Optional<String> getName() {
        return this.name;
    }

    public String requireName() {
        return this.name.get();
    }

    public Optional<String> getAngellistUrl() {
        return this.angellistUrl;
    }

    public String requireAngellistUrl() {
        return this.angellistUrl.get();
    }

    @JsonIgnore
    public Optional<String> getSlug() {
        return this.angellistUrl.map(url -> url.replaceAll(ANGELLIST_BASE_URL, EMPTY));
    }

    public String requireSlug() {
        return this.getSlug().get();
    }

    public Optional<String> getLogoUrl() {
        return this.logoUrl;
    }

    public String requireLogoUrl() {
        return this.logoUrl.get();
    }

    public Optional<String> getThumbUrl() {
        return this.thumbUrl;
    }

    public String requireThumbUrl() {
        return this.thumbUrl.get();
    }

    public Optional<Integer> getQuality() {
        return this.quality;
    }

    public Integer requireQuality() {
        return this.quality.get();
    }

    public Optional<String> getProductDesc() {
        return this.productDesc;
    }

    public String requireProductDesc() {
        return this.productDesc.get();
    }

    public Optional<String> getHighConcept() {
        return this.highConcept;
    }

    public String requireHighConcept() {
        return this.highConcept.get();
    }

    public Optional<Long> getFollowerCount() {
        return this.followerCount;
    }

    public Long requireFollowerCount() {
        return this.followerCount.get();
    }

    public Optional<String> getCompanyUrl() {
        return this.companyUrl;
    }

    public String requireCompanyUrl() {
        return this.companyUrl.get();
    }

    public Optional<ZonedDateTime> getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime requireCreatedAt() {
        return this.createdAt.get();
    }

    public Optional<ZonedDateTime> getUpdatedAt() {
        return this.updatedAt;
    }

    public ZonedDateTime requireUpdatedAt() {
        return this.updatedAt.get();
    }

    public Optional<String> getTwitterUrl() {
        return this.twitterUrl;
    }

    public String requireTwitterUrl() {
        return this.twitterUrl.get();
    }

    public Optional<String> getBlogUrl() {
        return this.blogUrl;
    }

    public String requireBlogUrl() {
        return this.blogUrl.get();
    }

    public Optional<String> getVideoUrl() {
        return this.videoUrl;
    }

    public String requireVideoUrl() {
        return this.videoUrl.get();
    }

    public List<Market> getMarkets() {
        return this.markets;
    }

    public List<Tag> getLocations() {
        return this.locations;
    }

    public Optional<Status> getStatus() {
        return this.status;
    }

    public Status requireStatus() {
        return this.status.get();
    }

    public List<Map<String, String>> getScreenshots() {
        return this.screenshots;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Startup other = (Startup)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.hidden, other.hidden) && Objects.equals(this.communityProfile, other.communityProfile) && Objects.equals(this.name, other.name) && Objects.equals(this.angellistUrl, other.angellistUrl) && Objects.equals(this.logoUrl, other.logoUrl) && Objects.equals(this.thumbUrl, other.thumbUrl) && Objects.equals(this.quality, other.quality) && Objects.equals(this.productDesc, other.productDesc) && Objects.equals(this.highConcept, other.highConcept) && Objects.equals(this.followerCount, other.followerCount) && Objects.equals(this.companyUrl, other.companyUrl) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.twitterUrl, other.twitterUrl) && Objects.equals(this.blogUrl, other.blogUrl) && Objects.equals(this.videoUrl, other.videoUrl) && Objects.equals(this.markets, other.markets) && Objects.equals(this.locations, other.locations) && Objects.equals(this.companySize, other.companySize) && Objects.equals(this.companyTypes, other.companyTypes) && Objects.equals(this.status, other.status) && Objects.equals(this.screenshots, other.screenshots) && Objects.equals(this.organizationId, other.organizationId) && Objects.equals(this.roles, other.roles);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.hidden, this.communityProfile, this.name, this.angellistUrl, this.logoUrl, this.thumbUrl, this.quality, this.productDesc, this.highConcept, this.followerCount, this.companyUrl, this.createdAt, this.updatedAt, this.twitterUrl, this.blogUrl, this.videoUrl, this.markets, this.locations, this.companySize, this.companyTypes, this.status, this.screenshots, this.organizationId, this.roles);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(ID, this.id).add(HIDDEN, this.hidden).add(COMMUNITY_PROFILE, this.communityProfile).add(NAME, this.name).add(ANGELLIST_URL, this.angellistUrl).add(LOGO_URL, this.logoUrl).add(THUMB_URL, this.thumbUrl).add(QUALITY, this.quality).add(PRODUCT_DESC, this.productDesc).add(HIGH_CONCEPT, this.highConcept).add(FOLLOWER_COUNT, this.followerCount).add(COMPANY_URL, this.companyUrl).add(CREATED_AT, this.createdAt).add(UPDATED_AT, this.updatedAt).add(TWITTER_URL, this.twitterUrl).add(BLOG_URL, this.blogUrl).add(VIDEO_URL, this.videoUrl).add(MARKETS, this.markets).add(LOCATIONS, this.locations).add(COMPANY_SIZE, this.companySize).add(COMPANY_TYPES, this.companyTypes).add(STATUS, this.status).add(SCREENSHOTS, this.screenshots).add(ORGANIZATION_ID, this.organizationId).add(ROLES, this.roles).toString();
    }

    public Optional<String> getCompanySize() {
        return this.companySize;
    }

    public String requireCompanySize() {
        return this.companySize.get();
    }

    public List<CompanyType> getCompanyTypes() {
        return this.companyTypes;
    }

    public Optional<String> getOrganizationId() {
        return this.organizationId;
    }

    public String requireOrganizationId() {
        return this.organizationId.get();
    }

    public Optional<Set<StartupRole>> getRoles() {
        return this.roles;
    }

    public Set<StartupRole> requireRoles() {
        return this.roles.get();
    }

    @JsonIgnore
    public Set<StartupRole> getRolesOrEmpty() {
        return this.roles.orElse((Set<StartupRole>)ImmutableSet.of());
    }

    public static class Builder {
        private Optional<Long> id = Optional.empty();
        private Optional<Boolean> hidden = Optional.empty();
        private Optional<Boolean> communityProfile = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> angellistUrl = Optional.empty();
        private Optional<String> logoUrl = Optional.empty();
        private Optional<String> thumbUrl = Optional.empty();
        private Optional<Integer> quality = Optional.empty();
        private Optional<String> productDesc = Optional.empty();
        private Optional<String> highConcept = Optional.empty();
        private Optional<Long> followerCount = Optional.empty();
        private Optional<String> companyUrl = Optional.empty();
        private Optional<ZonedDateTime> createdAt = Optional.empty();
        private Optional<ZonedDateTime> updatedAt = Optional.empty();
        private Optional<String> twitterUrl = Optional.empty();
        private Optional<String> blogUrl = Optional.empty();
        private Optional<String> videoUrl = Optional.empty();
        private List<Market> markets;
        private List<Tag> locations;
        private Optional<String> companySize = Optional.empty();
        private List<CompanyType> companyTypes;
        private Optional<Status> status = Optional.empty();
        private List<Map<String, String>> screenshots;
        private Optional<String> organizationId = Optional.empty();
        private Optional<Set<StartupRole>> roles = Optional.empty();

        private Builder() {
        }

        private Builder(Startup startup) {
            this.id = startup.getId();
            this.hidden = startup.getHidden();
            this.communityProfile = startup.getCommunityProfile();
            this.name = startup.getName();
            this.angellistUrl = startup.getAngellistUrl();
            this.logoUrl = startup.getLogoUrl();
            this.thumbUrl = startup.getThumbUrl();
            this.quality = startup.getQuality();
            this.productDesc = startup.getProductDesc();
            this.highConcept = startup.getHighConcept();
            this.followerCount = startup.getFollowerCount();
            this.companyUrl = startup.getCompanyUrl();
            this.createdAt = startup.getCreatedAt();
            this.updatedAt = startup.getUpdatedAt();
            this.twitterUrl = startup.getTwitterUrl();
            this.blogUrl = startup.getBlogUrl();
            this.videoUrl = startup.getVideoUrl();
            this.markets = startup.getMarkets();
            this.locations = startup.getLocations();
            this.companySize = startup.getCompanySize();
            this.companyTypes = startup.getCompanyTypes();
            this.status = startup.getStatus();
            this.screenshots = startup.getScreenshots();
            this.organizationId = startup.getOrganizationId();
            this.roles = startup.getRoles();
        }

        public Builder withId(Optional<Long> id) {
            this.id = id;
            return this;
        }

        public Builder withId(Long id) {
            this.id = Optional.of(id);
            return this;
        }

        public Builder withHidden(Optional<Boolean> hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder withHidden(Boolean hidden) {
            this.hidden = Optional.of(hidden);
            return this;
        }

        public Builder withCommunityProfile(Optional<Boolean> communityProfile) {
            this.communityProfile = communityProfile;
            return this;
        }

        public Builder withCommunityProfile(Boolean communityProfile) {
            this.communityProfile = Optional.of(communityProfile);
            return this;
        }

        public Builder withName(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder withName(String name) {
            this.name = Optional.of(name);
            return this;
        }

        public Builder withAngellistUrl(Optional<String> angellistUrl) {
            this.angellistUrl = angellistUrl;
            return this;
        }

        public Builder withAngellistUrl(String angellistUrl) {
            this.angellistUrl = Optional.of(angellistUrl);
            return this;
        }

        public Builder withLogoUrl(Optional<String> logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        public Builder withLogoUrl(String logoUrl) {
            this.logoUrl = Optional.of(logoUrl);
            return this;
        }

        public Builder withThumbUrl(Optional<String> thumbUrl) {
            this.thumbUrl = thumbUrl;
            return this;
        }

        public Builder withThumbUrl(String thumbUrl) {
            this.thumbUrl = Optional.of(thumbUrl);
            return this;
        }

        public Builder withQuality(Optional<Integer> quality) {
            this.quality = quality;
            return this;
        }

        public Builder withQuality(Integer quality) {
            this.quality = Optional.of(quality);
            return this;
        }

        public Builder withProductDesc(Optional<String> productDesc) {
            this.productDesc = productDesc;
            return this;
        }

        public Builder withProductDesc(String productDesc) {
            this.productDesc = Optional.of(productDesc);
            return this;
        }

        public Builder withHighConcept(Optional<String> highConcept) {
            this.highConcept = highConcept;
            return this;
        }

        public Builder withHighConcept(String highConcept) {
            this.highConcept = Optional.of(highConcept);
            return this;
        }

        public Builder withFollowerCount(Optional<Long> followerCount) {
            this.followerCount = followerCount;
            return this;
        }

        public Builder withFollowerCount(Long followerCount) {
            this.followerCount = Optional.of(followerCount);
            return this;
        }

        public Builder withCompanyUrl(Optional<String> companyUrl) {
            this.companyUrl = companyUrl;
            return this;
        }

        public Builder withCompanyUrl(String companyUrl) {
            this.companyUrl = Optional.of(companyUrl);
            return this;
        }

        public Builder withCreatedAt(Optional<ZonedDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder withCreatedAt(ZonedDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        public Builder withUpdatedAt(Optional<ZonedDateTime> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder withUpdatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = Optional.of(updatedAt);
            return this;
        }

        public Builder withTwitterUrl(Optional<String> twitterUrl) {
            this.twitterUrl = twitterUrl;
            return this;
        }

        public Builder withTwitterUrl(String twitterUrl) {
            this.twitterUrl = Optional.of(twitterUrl);
            return this;
        }

        public Builder withBlogUrl(Optional<String> blogUrl) {
            this.blogUrl = blogUrl;
            return this;
        }

        public Builder withBlogUrl(String blogUrl) {
            this.blogUrl = Optional.of(blogUrl);
            return this;
        }

        public Builder withVideoUrl(Optional<String> videoUrl) {
            this.videoUrl = videoUrl;
            return this;
        }

        public Builder withVideoUrl(String videoUrl) {
            this.videoUrl = Optional.of(videoUrl);
            return this;
        }

        public Builder withMarkets(List<Market> markets) {
            this.markets = markets;
            return this;
        }

        public Builder withLocations(List<Tag> locations) {
            this.locations = locations;
            return this;
        }

        public Builder withCompanySize(Optional<String> companySize) {
            this.companySize = companySize;
            return this;
        }

        public Builder withCompanySize(String companySize) {
            this.companySize = Optional.of(companySize);
            return this;
        }

        public Builder withCompanyTypes(List<CompanyType> companyTypes) {
            this.companyTypes = companyTypes;
            return this;
        }

        public Builder withStatus(Optional<Status> status) {
            this.status = status;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = Optional.of(status);
            return this;
        }

        public Builder withScreenshots(List<Map<String, String>> screenshots) {
            this.screenshots = screenshots;
            return this;
        }

        public Builder withOrganizationId(Optional<String> organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public Builder withOrganizationId(String organizationId) {
            this.organizationId = Optional.of(organizationId);
            return this;
        }

        public Builder withRoles(Optional<Set<StartupRole>> roles) {
            this.roles = roles;
            return this;
        }

        public Builder withRoles(Set<StartupRole> roles) {
            this.roles = Optional.of(roles);
            return this;
        }

        public Startup build() {
            return new Startup(this.id, this.hidden, this.communityProfile, this.name, this.angellistUrl, this.logoUrl, this.thumbUrl, this.quality, this.productDesc, this.highConcept, this.followerCount, this.companyUrl, this.createdAt, this.updatedAt, this.twitterUrl, this.blogUrl, this.videoUrl, this.markets, this.locations, this.companySize, this.companyTypes, this.status, this.screenshots, this.organizationId, this.roles);
        }
    }
}

