/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.angellist.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import vc.inreach.angellist.api.StringDeserializer;
import vc.inreach.angellist.api.StringSerializer;
import vc.inreach.angellist.api.User;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class StartupRole {
    public static final String ID = "id";
    public static final String ROLE = "role";
    public static final String CREATED_AT = "created_at";
    public static final String STARTED_AT = "started_at";
    public static final String ENDED_AT = "ended_at";
    public static final String CONFIRMED = "confirmed";
    public static final String TAGGED = "tagged";
    public static final String USER = "user";
    public static final String TITLE = "title";
    private static final Optional<String> USER_TYPE = Optional.of("User");
    private static final String TYPE = "type";
    private static final String PAST_INVESTOR = "past_investor";
    private static final String BIO = "bio";
    private static final String LOGO_URL = "logo_url";
    private static final String IMAGE = "image";
    private static final String PRODUCT_DESC = "product_desc";
    private static final String ANGELLIST_URL = "angellist_url";
    private static final String COMPANY_URL = "company_url";
    private static final String NAME = "name";
    @JsonProperty(value="id")
    private Optional<Long> id = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="role")
    private Optional<String> role = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="title")
    private Optional<String> title = Optional.empty();
    @JsonProperty(value="created_at")
    private Optional<ZonedDateTime> createdAt = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="started_at")
    private Optional<String> startedAt = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="ended_at")
    private Optional<String> endedAt = Optional.empty();
    @JsonProperty(value="confirmed")
    private boolean confirmed;
    @JsonProperty(value="tagged")
    private Optional<Map<String, Object>> tagged = Optional.empty();
    @JsonProperty(value="user")
    private Optional<User> user = Optional.empty();

    private StartupRole() {
    }

    private StartupRole(Optional<Long> id, Optional<String> role, Optional<String> title, Optional<ZonedDateTime> createdAt, Optional<String> startedAt, Optional<String> endedAt, boolean confirmed, Optional<Map<String, Object>> tagged, Optional<User> user) {
        this.id = id;
        this.role = role;
        this.title = title;
        this.createdAt = createdAt;
        this.startedAt = startedAt;
        this.endedAt = endedAt;
        this.confirmed = confirmed;
        this.tagged = tagged;
        this.user = user;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Long> getId() {
        return this.id;
    }

    public Long requireId() {
        return this.id.get();
    }

    public Optional<String> getRole() {
        return this.role;
    }

    public String requireRole() {
        return this.role.get();
    }

    public Optional<ZonedDateTime> getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime requireCreatedAt() {
        return this.createdAt.get();
    }

    public Optional<String> getStartedAt() {
        return this.startedAt;
    }

    public String requireStartedAt() {
        return this.startedAt.get();
    }

    public Optional<String> getEndedAt() {
        return this.endedAt;
    }

    public String requireEndedAt() {
        return this.endedAt.get();
    }

    public boolean getConfirmed() {
        return this.confirmed;
    }

    public Optional<Map<String, Object>> getTagged() {
        return this.tagged;
    }

    public Map<String, Object> requireTagged() {
        return this.tagged.get();
    }

    @JsonIgnore
    public Map<String, Object> getTaggedOrEmpty() {
        return this.tagged.orElse((Map<String, Object>)ImmutableMap.of());
    }

    public boolean isUser() {
        Map<String, Object> tagged = this.getTaggedOrEmpty();
        return Optional.ofNullable(tagged.get(TYPE)).equals(USER_TYPE) && tagged.containsKey(ID);
    }

    public long requireUserId() {
        Object o = Preconditions.checkNotNull((Object)this.getTaggedOrEmpty().get(ID));
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        return (Long)o;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StartupRole other = (StartupRole)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.role, other.role) && Objects.equals(this.title, other.title) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.startedAt, other.startedAt) && Objects.equals(this.endedAt, other.endedAt) && Objects.equals(this.confirmed, other.confirmed) && Objects.equals(this.tagged, other.tagged) && Objects.equals(this.user, other.user);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.role, this.title, this.createdAt, this.startedAt, this.endedAt, this.confirmed, this.tagged, this.user);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(ID, this.id).add(ROLE, this.role).add(TITLE, this.title).add(CREATED_AT, this.createdAt).add(STARTED_AT, this.startedAt).add(ENDED_AT, this.endedAt).add(CONFIRMED, this.confirmed).add(TAGGED, this.tagged).add(USER, this.user).toString();
    }

    public boolean isInvestor() {
        return this.role.equals(Optional.of(PAST_INVESTOR));
    }

    public Optional<User> getUser() {
        return this.user;
    }

    @JsonIgnore
    public User getUserOrEmpty() {
        return this.user.orElse(User.builder().build());
    }

    public User requireUser() {
        return this.user.get();
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public String requireTitle() {
        return this.title.get();
    }

    public static class Builder {
        private Optional<Long> id = Optional.empty();
        private Optional<String> role = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<ZonedDateTime> createdAt = Optional.empty();
        private Optional<String> startedAt = Optional.empty();
        private Optional<String> endedAt = Optional.empty();
        private boolean confirmed;
        private Optional<Map<String, Object>> tagged = Optional.empty();
        private Optional<User> user = Optional.empty();

        private Builder() {
        }

        private Builder(StartupRole startupRole) {
            this.id = startupRole.getId();
            this.role = startupRole.getRole();
            this.title = startupRole.getTitle();
            this.createdAt = startupRole.getCreatedAt();
            this.startedAt = startupRole.getStartedAt();
            this.endedAt = startupRole.getEndedAt();
            this.confirmed = startupRole.getConfirmed();
            this.tagged = startupRole.getTagged();
            this.user = startupRole.getUser();
        }

        public Builder withId(Optional<Long> id) {
            this.id = id;
            return this;
        }

        public Builder withId(Long id) {
            this.id = Optional.of(id);
            return this;
        }

        public Builder withRole(Optional<String> role) {
            this.role = role;
            return this;
        }

        public Builder withRole(String role) {
            this.role = Optional.of(role);
            return this;
        }

        public Builder withTitle(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = Optional.of(title);
            return this;
        }

        public Builder withCreatedAt(Optional<ZonedDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder withCreatedAt(ZonedDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        public Builder withStartedAt(Optional<String> startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public Builder withStartedAt(String startedAt) {
            this.startedAt = Optional.of(startedAt);
            return this;
        }

        public Builder withEndedAt(Optional<String> endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public Builder withEndedAt(String endedAt) {
            this.endedAt = Optional.of(endedAt);
            return this;
        }

        public Builder withConfirmed(boolean confirmed) {
            this.confirmed = confirmed;
            return this;
        }

        public Builder withTagged(Optional<Map<String, Object>> tagged) {
            this.tagged = tagged;
            return this;
        }

        public Builder withTagged(Map<String, Object> tagged) {
            this.tagged = Optional.of(tagged);
            return this;
        }

        public Builder withUser(Optional<User> user) {
            this.user = user;
            return this;
        }

        public Builder withUser(User user) {
            this.user = Optional.of(user);
            return this;
        }

        public StartupRole build() {
            return new StartupRole(this.id, this.role, this.title, this.createdAt, this.startedAt, this.endedAt, this.confirmed, this.tagged, this.user);
        }
    }
}

