/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.angellist.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import vc.inreach.angellist.api.StartupRole;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class StartupRoles {
    public static final String STARTUP_ROLES = "startup_roles";
    public static final String TOTAL = "total";
    public static final String PER_PAGE = "per_page";
    public static final String PAGE = "page";
    public static final String LAST_PAGE = "last_page";
    @JsonProperty(value="startup_roles")
    private List<StartupRole> startupRoles = ImmutableList.of();
    @JsonProperty(value="total")
    private int total;
    @JsonProperty(value="per_page")
    private int perPage;
    @JsonProperty(value="page")
    private int page;
    @JsonProperty(value="last_page")
    private int lastPage;

    private StartupRoles(List<StartupRole> startupRoles, int total, int perPage, int page, int lastPage) {
        this.startupRoles = startupRoles;
        this.total = total;
        this.perPage = perPage;
        this.page = page;
        this.lastPage = lastPage;
    }

    private StartupRoles() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<StartupRole> getStartupRoles() {
        return this.startupRoles;
    }

    public int getTotal() {
        return this.total;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getPage() {
        return this.page;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StartupRoles other = (StartupRoles)obj;
        return Objects.equals(this.startupRoles, other.startupRoles) && Objects.equals(this.total, other.total) && Objects.equals(this.perPage, other.perPage) && Objects.equals(this.page, other.page) && Objects.equals(this.lastPage, other.lastPage);
    }

    public int hashCode() {
        return Objects.hash(this.startupRoles, this.total, this.perPage, this.page, this.lastPage);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(STARTUP_ROLES, this.startupRoles).add(TOTAL, this.total).add(PER_PAGE, this.perPage).add(PAGE, this.page).add(LAST_PAGE, this.lastPage).toString();
    }

    public static class Builder {
        private List<StartupRole> startupRoles;
        private int total;
        private int perPage;
        private int page;
        private int lastPage;

        private Builder() {
        }

        private Builder(StartupRoles startupRoles) {
            this.startupRoles = startupRoles.getStartupRoles();
            this.total = startupRoles.getTotal();
            this.perPage = startupRoles.getPerPage();
            this.page = startupRoles.getPage();
            this.lastPage = startupRoles.getLastPage();
        }

        public Builder withStartupRoles(List<StartupRole> startupRoles) {
            this.startupRoles = startupRoles;
            return this;
        }

        public Builder withTotal(int total) {
            this.total = total;
            return this;
        }

        public Builder withPerPage(int perPage) {
            this.perPage = perPage;
            return this;
        }

        public Builder withPage(int page) {
            this.page = page;
            return this;
        }

        public Builder withLastPage(int lastPage) {
            this.lastPage = lastPage;
            return this;
        }

        public StartupRoles build() {
            return new StartupRoles(this.startupRoles, this.total, this.perPage, this.page, this.lastPage);
        }
    }
}

