/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.angellist.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import vc.inreach.angellist.api.Startup;

public class Startups {
    public static final String STARTUPS = "startups";
    public static final String TOTAL = "total";
    public static final String PER_PAGE = "per_page";
    public static final String PAGE = "page";
    public static final String LAST_PAGE = "last_page";
    @JsonProperty(value="startups")
    private List<Startup> startups = ImmutableList.of();
    @JsonProperty(value="total")
    private int total;
    @JsonProperty(value="per_page")
    private int perPage;
    @JsonProperty(value="page")
    private int page;
    @JsonProperty(value="last_page")
    private int lastPage;

    private Startups(List<Startup> startups, int total, int perPage, int page, int lastPage) {
        this.startups = startups;
        this.total = total;
        this.perPage = perPage;
        this.page = page;
        this.lastPage = lastPage;
    }

    private Startups() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Startup> getStartups() {
        return this.startups;
    }

    public int getTotal() {
        return this.total;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getPage() {
        return this.page;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Startups other = (Startups)obj;
        return Objects.equals(this.startups, other.startups) && Objects.equals(this.total, other.total) && Objects.equals(this.perPage, other.perPage) && Objects.equals(this.page, other.page) && Objects.equals(this.lastPage, other.lastPage);
    }

    public int hashCode() {
        return Objects.hash(this.startups, this.total, this.perPage, this.page, this.lastPage);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(STARTUPS, this.startups).add(TOTAL, this.total).add(PER_PAGE, this.perPage).add(PAGE, this.page).add(LAST_PAGE, this.lastPage).toString();
    }

    public static class Builder {
        private List<Startup> startups;
        private int total;
        private int perPage;
        private int page;
        private int lastPage;

        private Builder() {
        }

        private Builder(Startups startups) {
            this.startups = startups.getStartups();
            this.total = startups.getTotal();
            this.perPage = startups.getPerPage();
            this.page = startups.getPage();
            this.lastPage = startups.getLastPage();
        }

        public Builder withStartups(List<Startup> startups) {
            this.startups = startups;
            return this;
        }

        public Builder withTotal(int total) {
            this.total = total;
            return this;
        }

        public Builder withPerPage(int perPage) {
            this.perPage = perPage;
            return this;
        }

        public Builder withPage(int page) {
            this.page = page;
            return this;
        }

        public Builder withLastPage(int lastPage) {
            this.lastPage = lastPage;
            return this;
        }

        public Startups build() {
            return new Startups(this.startups, this.total, this.perPage, this.page, this.lastPage);
        }
    }
}

