/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.angellist.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Status {
    public static final String MESSAGE = "message";
    public static final String CREATED_AT = "created_at";
    @JsonProperty(value="message")
    private Optional<String> message = Optional.empty();
    @JsonProperty(value="created_at")
    private Optional<ZonedDateTime> createdAt = Optional.empty();

    private Status(Optional<String> message, Optional<ZonedDateTime> createdAt) {
        this.message = message;
        this.createdAt = createdAt;
    }

    private Status() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public String requireMessage() {
        return this.message.get();
    }

    public Optional<ZonedDateTime> getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime requireCreatedAt() {
        return this.createdAt.get();
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Status other = (Status)obj;
        return Objects.equals(this.message, other.message) && Objects.equals(this.createdAt, other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.createdAt);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(MESSAGE, this.message).add(CREATED_AT, this.createdAt).toString();
    }

    public static class Builder {
        private Optional<String> message = Optional.empty();
        private Optional<ZonedDateTime> createdAt = Optional.empty();

        private Builder() {
        }

        private Builder(Status status) {
            this.message = status.getMessage();
            this.createdAt = status.getCreatedAt();
        }

        public Builder withMessage(Optional<String> message) {
            this.message = message;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = Optional.of(message);
            return this;
        }

        public Builder withCreatedAt(Optional<ZonedDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder withCreatedAt(ZonedDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        public Status build() {
            return new Status(this.message, this.createdAt);
        }
    }
}

