/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.angellist.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import vc.inreach.angellist.api.Role;
import vc.inreach.angellist.api.StringDeserializer;
import vc.inreach.angellist.api.StringSerializer;
import vc.inreach.angellist.api.Tag;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class User {
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String BIO = "bio";
    public static final String BLOG_URL = "blog_url";
    public static final String ONLINE_BIO_URL = "online_bio_url";
    public static final String TWITTER_URL = "twitter_url";
    public static final String FACEBOOK_URL = "facebook_url";
    public static final String LINKEDIN_URL = "linkedin_url";
    public static final String FOLLOWER_COUNT = "follower_count";
    public static final String INVESTOR = "investor";
    public static final String ANGELLIST_URL = "angellist_url";
    public static final String IMAGE = "image";
    public static final String LOCATIONS = "locations";
    public static final String ROLES = "roles";
    public static final String ABOUTME_URL = "aboutme_url";
    public static final String GITHUB_URL = "github_url";
    public static final String DRIBBLE_URL = "dribble_url";
    public static final String BEHANCE_URL = "behance_url";
    public static final String RESUME_URL = "resume_url";
    public static final String WHAT_IVE_BUILT = "what_ive_built";
    public static final String WHAT_I_DO = "what_i_do";
    public static final String CRITERIA = "criteria";
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="name")
    private Optional<String> name = Optional.empty();
    @JsonProperty(value="id")
    private long id;
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="bio")
    private Optional<String> bio = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="blog_url")
    private Optional<String> blogUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="online_bio_url")
    private Optional<String> onlineBioUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="twitter_url")
    private Optional<String> twitterUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="facebook_url")
    private Optional<String> facebookUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="linkedin_url")
    private Optional<String> linkedinUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="aboutme_url")
    private Optional<String> aboutmeUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="github_url")
    private Optional<String> githubUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="dribble_url")
    private Optional<String> dribbleUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="behance_url")
    private Optional<String> behanceUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="resume_url")
    private Optional<String> resumeUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="what_ive_built")
    private Optional<String> whatIveBuilt = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="what_i_do")
    private Optional<String> whatIDo = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="criteria")
    private Optional<String> criteria = Optional.empty();
    @JsonProperty(value="follower_count")
    private Optional<Integer> followerCount = Optional.empty();
    @JsonProperty(value="investor")
    private boolean investor;
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="angellist_url")
    private Optional<String> angellistUrl = Optional.empty();
    @JsonSerialize(using=StringSerializer.class)
    @JsonDeserialize(using=StringDeserializer.class)
    @JsonProperty(value="image")
    private Optional<String> image = Optional.empty();
    @JsonProperty(value="locations")
    private Optional<Set<Tag>> locations = Optional.empty();
    @JsonProperty(value="roles")
    private Optional<Set<Role>> roles = Optional.empty();

    private User() {
    }

    private User(Optional<String> name, long id, Optional<String> bio, Optional<String> blogUrl, Optional<String> onlineBioUrl, Optional<String> twitterUrl, Optional<String> facebookUrl, Optional<String> linkedinUrl, Optional<String> aboutmeUrl, Optional<String> githubUrl, Optional<String> dribbleUrl, Optional<String> behanceUrl, Optional<String> resumeUrl, Optional<String> whatIveBuilt, Optional<String> whatIDo, Optional<String> criteria, Optional<Integer> followerCount, boolean investor, Optional<String> angellistUrl, Optional<String> image, Optional<Set<Tag>> locations, Optional<Set<Role>> roles) {
        this.name = name;
        this.id = id;
        this.bio = bio;
        this.blogUrl = blogUrl;
        this.onlineBioUrl = onlineBioUrl;
        this.twitterUrl = twitterUrl;
        this.facebookUrl = facebookUrl;
        this.linkedinUrl = linkedinUrl;
        this.aboutmeUrl = aboutmeUrl;
        this.githubUrl = githubUrl;
        this.dribbleUrl = dribbleUrl;
        this.behanceUrl = behanceUrl;
        this.resumeUrl = resumeUrl;
        this.whatIveBuilt = whatIveBuilt;
        this.whatIDo = whatIDo;
        this.criteria = criteria;
        this.followerCount = followerCount;
        this.investor = investor;
        this.angellistUrl = angellistUrl;
        this.image = image;
        this.locations = locations;
        this.roles = roles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getName() {
        return this.name;
    }

    public String requireName() {
        return this.name.get();
    }

    public long getId() {
        return this.id;
    }

    public Optional<String> getBio() {
        return this.bio;
    }

    public String requireBio() {
        return this.bio.get();
    }

    public Optional<String> getBlogUrl() {
        return this.blogUrl;
    }

    public String requireBlogUrl() {
        return this.blogUrl.get();
    }

    public Optional<String> getOnlineBioUrl() {
        return this.onlineBioUrl;
    }

    public String requireOnlineBioUrl() {
        return this.onlineBioUrl.get();
    }

    public Optional<String> getTwitterUrl() {
        return this.twitterUrl;
    }

    public String requireTwitterUrl() {
        return this.twitterUrl.get();
    }

    public Optional<String> getFacebookUrl() {
        return this.facebookUrl;
    }

    public String requireFacebookUrl() {
        return this.facebookUrl.get();
    }

    public Optional<String> getLinkedinUrl() {
        return this.linkedinUrl;
    }

    public String requireLinkedinUrl() {
        return this.linkedinUrl.get();
    }

    public Optional<Integer> getFollowerCount() {
        return this.followerCount;
    }

    public Integer requireFollowerCount() {
        return this.followerCount.get();
    }

    public boolean getInvestor() {
        return this.investor;
    }

    public Optional<String> getAngellistUrl() {
        return this.angellistUrl;
    }

    public String requireAngellistUrl() {
        return this.angellistUrl.get();
    }

    public Optional<String> getImage() {
        return this.image;
    }

    public String requireImage() {
        return this.image.get();
    }

    public Optional<Set<Tag>> getLocations() {
        return this.locations;
    }

    public Set<Tag> requireLocations() {
        return this.locations.get();
    }

    @JsonIgnore
    public Set<Tag> getLocationsOrEmpty() {
        return this.locations.orElse((Set<Tag>)ImmutableSet.of());
    }

    public Optional<Set<Role>> getRoles() {
        return this.roles;
    }

    public Set<Role> requireRoles() {
        return this.roles.get();
    }

    @JsonIgnore
    public Set<Role> getRolesOrEmpty() {
        return this.roles.orElse((Set<Role>)ImmutableSet.of());
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.id, other.id) && Objects.equals(this.bio, other.bio) && Objects.equals(this.blogUrl, other.blogUrl) && Objects.equals(this.onlineBioUrl, other.onlineBioUrl) && Objects.equals(this.twitterUrl, other.twitterUrl) && Objects.equals(this.facebookUrl, other.facebookUrl) && Objects.equals(this.linkedinUrl, other.linkedinUrl) && Objects.equals(this.aboutmeUrl, other.aboutmeUrl) && Objects.equals(this.githubUrl, other.githubUrl) && Objects.equals(this.dribbleUrl, other.dribbleUrl) && Objects.equals(this.behanceUrl, other.behanceUrl) && Objects.equals(this.resumeUrl, other.resumeUrl) && Objects.equals(this.whatIveBuilt, other.whatIveBuilt) && Objects.equals(this.whatIDo, other.whatIDo) && Objects.equals(this.criteria, other.criteria) && Objects.equals(this.followerCount, other.followerCount) && Objects.equals(this.investor, other.investor) && Objects.equals(this.angellistUrl, other.angellistUrl) && Objects.equals(this.image, other.image) && Objects.equals(this.locations, other.locations) && Objects.equals(this.roles, other.roles);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.bio, this.blogUrl, this.onlineBioUrl, this.twitterUrl, this.facebookUrl, this.linkedinUrl, this.aboutmeUrl, this.githubUrl, this.dribbleUrl, this.behanceUrl, this.resumeUrl, this.whatIveBuilt, this.whatIDo, this.criteria, this.followerCount, this.investor, this.angellistUrl, this.image, this.locations, this.roles);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(NAME, this.name).add(ID, this.id).add(BIO, this.bio).add(BLOG_URL, this.blogUrl).add(ONLINE_BIO_URL, this.onlineBioUrl).add(TWITTER_URL, this.twitterUrl).add(FACEBOOK_URL, this.facebookUrl).add(LINKEDIN_URL, this.linkedinUrl).add(ABOUTME_URL, this.aboutmeUrl).add(GITHUB_URL, this.githubUrl).add(DRIBBLE_URL, this.dribbleUrl).add(BEHANCE_URL, this.behanceUrl).add(RESUME_URL, this.resumeUrl).add(WHAT_IVE_BUILT, this.whatIveBuilt).add(WHAT_I_DO, this.whatIDo).add(CRITERIA, this.criteria).add(FOLLOWER_COUNT, this.followerCount).add(INVESTOR, this.investor).add(ANGELLIST_URL, this.angellistUrl).add(IMAGE, this.image).add(LOCATIONS, this.locations).add(ROLES, this.roles).toString();
    }

    public Optional<String> getAboutmeUrl() {
        return this.aboutmeUrl;
    }

    public String requireAboutmeUrl() {
        return this.aboutmeUrl.get();
    }

    public Optional<String> getGithubUrl() {
        return this.githubUrl;
    }

    public String requireGithubUrl() {
        return this.githubUrl.get();
    }

    public Optional<String> getDribbleUrl() {
        return this.dribbleUrl;
    }

    public String requireDribbleUrl() {
        return this.dribbleUrl.get();
    }

    public Optional<String> getBehanceUrl() {
        return this.behanceUrl;
    }

    public String requireBehanceUrl() {
        return this.behanceUrl.get();
    }

    public Optional<String> getResumeUrl() {
        return this.resumeUrl;
    }

    public String requireResumeUrl() {
        return this.resumeUrl.get();
    }

    public Optional<String> getWhatIveBuilt() {
        return this.whatIveBuilt;
    }

    public String requireWhatIveBuilt() {
        return this.whatIveBuilt.get();
    }

    public Optional<String> getWhatIDo() {
        return this.whatIDo;
    }

    public String requireWhatIDo() {
        return this.whatIDo.get();
    }

    public Optional<String> getCriteria() {
        return this.criteria;
    }

    public String requireCriteria() {
        return this.criteria.get();
    }

    public static class Builder {
        private Optional<String> name = Optional.empty();
        private long id;
        private Optional<String> bio = Optional.empty();
        private Optional<String> blogUrl = Optional.empty();
        private Optional<String> onlineBioUrl = Optional.empty();
        private Optional<String> twitterUrl = Optional.empty();
        private Optional<String> facebookUrl = Optional.empty();
        private Optional<String> linkedinUrl = Optional.empty();
        private Optional<String> aboutmeUrl = Optional.empty();
        private Optional<String> githubUrl = Optional.empty();
        private Optional<String> dribbleUrl = Optional.empty();
        private Optional<String> behanceUrl = Optional.empty();
        private Optional<String> resumeUrl = Optional.empty();
        private Optional<String> whatIveBuilt = Optional.empty();
        private Optional<String> whatIDo = Optional.empty();
        private Optional<String> criteria = Optional.empty();
        private Optional<Integer> followerCount = Optional.empty();
        private boolean investor;
        private Optional<String> angellistUrl = Optional.empty();
        private Optional<String> image = Optional.empty();
        private Optional<Set<Tag>> locations = Optional.empty();
        private Optional<Set<Role>> roles = Optional.empty();

        private Builder() {
        }

        private Builder(User user) {
            this.name = user.getName();
            this.id = user.getId();
            this.bio = user.getBio();
            this.blogUrl = user.getBlogUrl();
            this.onlineBioUrl = user.getOnlineBioUrl();
            this.twitterUrl = user.getTwitterUrl();
            this.facebookUrl = user.getFacebookUrl();
            this.linkedinUrl = user.getLinkedinUrl();
            this.aboutmeUrl = user.getAboutmeUrl();
            this.githubUrl = user.getGithubUrl();
            this.dribbleUrl = user.getDribbleUrl();
            this.behanceUrl = user.getBehanceUrl();
            this.resumeUrl = user.getResumeUrl();
            this.whatIveBuilt = user.getWhatIveBuilt();
            this.whatIDo = user.getWhatIDo();
            this.criteria = user.getCriteria();
            this.followerCount = user.getFollowerCount();
            this.investor = user.getInvestor();
            this.angellistUrl = user.getAngellistUrl();
            this.image = user.getImage();
            this.locations = user.getLocations();
            this.roles = user.getRoles();
        }

        public Builder withName(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder withName(String name) {
            this.name = Optional.of(name);
            return this;
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withBio(Optional<String> bio) {
            this.bio = bio;
            return this;
        }

        public Builder withBio(String bio) {
            this.bio = Optional.of(bio);
            return this;
        }

        public Builder withBlogUrl(Optional<String> blogUrl) {
            this.blogUrl = blogUrl;
            return this;
        }

        public Builder withBlogUrl(String blogUrl) {
            this.blogUrl = Optional.of(blogUrl);
            return this;
        }

        public Builder withOnlineBioUrl(Optional<String> onlineBioUrl) {
            this.onlineBioUrl = onlineBioUrl;
            return this;
        }

        public Builder withOnlineBioUrl(String onlineBioUrl) {
            this.onlineBioUrl = Optional.of(onlineBioUrl);
            return this;
        }

        public Builder withTwitterUrl(Optional<String> twitterUrl) {
            this.twitterUrl = twitterUrl;
            return this;
        }

        public Builder withTwitterUrl(String twitterUrl) {
            this.twitterUrl = Optional.of(twitterUrl);
            return this;
        }

        public Builder withFacebookUrl(Optional<String> facebookUrl) {
            this.facebookUrl = facebookUrl;
            return this;
        }

        public Builder withFacebookUrl(String facebookUrl) {
            this.facebookUrl = Optional.of(facebookUrl);
            return this;
        }

        public Builder withLinkedinUrl(Optional<String> linkedinUrl) {
            this.linkedinUrl = linkedinUrl;
            return this;
        }

        public Builder withLinkedinUrl(String linkedinUrl) {
            this.linkedinUrl = Optional.of(linkedinUrl);
            return this;
        }

        public Builder withAboutmeUrl(Optional<String> aboutmeUrl) {
            this.aboutmeUrl = aboutmeUrl;
            return this;
        }

        public Builder withAboutmeUrl(String aboutmeUrl) {
            this.aboutmeUrl = Optional.of(aboutmeUrl);
            return this;
        }

        public Builder withGithubUrl(Optional<String> githubUrl) {
            this.githubUrl = githubUrl;
            return this;
        }

        public Builder withGithubUrl(String githubUrl) {
            this.githubUrl = Optional.of(githubUrl);
            return this;
        }

        public Builder withDribbleUrl(Optional<String> dribbleUrl) {
            this.dribbleUrl = dribbleUrl;
            return this;
        }

        public Builder withDribbleUrl(String dribbleUrl) {
            this.dribbleUrl = Optional.of(dribbleUrl);
            return this;
        }

        public Builder withBehanceUrl(Optional<String> behanceUrl) {
            this.behanceUrl = behanceUrl;
            return this;
        }

        public Builder withBehanceUrl(String behanceUrl) {
            this.behanceUrl = Optional.of(behanceUrl);
            return this;
        }

        public Builder withResumeUrl(Optional<String> resumeUrl) {
            this.resumeUrl = resumeUrl;
            return this;
        }

        public Builder withResumeUrl(String resumeUrl) {
            this.resumeUrl = Optional.of(resumeUrl);
            return this;
        }

        public Builder withWhatIveBuilt(Optional<String> whatIveBuilt) {
            this.whatIveBuilt = whatIveBuilt;
            return this;
        }

        public Builder withWhatIveBuilt(String whatIveBuilt) {
            this.whatIveBuilt = Optional.of(whatIveBuilt);
            return this;
        }

        public Builder withWhatIDo(Optional<String> whatIDo) {
            this.whatIDo = whatIDo;
            return this;
        }

        public Builder withWhatIDo(String whatIDo) {
            this.whatIDo = Optional.of(whatIDo);
            return this;
        }

        public Builder withCriteria(Optional<String> criteria) {
            this.criteria = criteria;
            return this;
        }

        public Builder withCriteria(String criteria) {
            this.criteria = Optional.of(criteria);
            return this;
        }

        public Builder withFollowerCount(Optional<Integer> followerCount) {
            this.followerCount = followerCount;
            return this;
        }

        public Builder withFollowerCount(Integer followerCount) {
            this.followerCount = Optional.of(followerCount);
            return this;
        }

        public Builder withInvestor(boolean investor) {
            this.investor = investor;
            return this;
        }

        public Builder withAngellistUrl(Optional<String> angellistUrl) {
            this.angellistUrl = angellistUrl;
            return this;
        }

        public Builder withAngellistUrl(String angellistUrl) {
            this.angellistUrl = Optional.of(angellistUrl);
            return this;
        }

        public Builder withImage(Optional<String> image) {
            this.image = image;
            return this;
        }

        public Builder withImage(String image) {
            this.image = Optional.of(image);
            return this;
        }

        public Builder withLocations(Optional<Set<Tag>> locations) {
            this.locations = locations;
            return this;
        }

        public Builder withLocations(Set<Tag> locations) {
            this.locations = Optional.of(locations);
            return this;
        }

        public Builder withRoles(Optional<Set<Role>> roles) {
            this.roles = roles;
            return this;
        }

        public Builder withRoles(Set<Role> roles) {
            this.roles = Optional.of(roles);
            return this;
        }

        public User build() {
            return new User(this.name, this.id, this.bio, this.blogUrl, this.onlineBioUrl, this.twitterUrl, this.facebookUrl, this.linkedinUrl, this.aboutmeUrl, this.githubUrl, this.dribbleUrl, this.behanceUrl, this.resumeUrl, this.whatIveBuilt, this.whatIDo, this.criteria, this.followerCount, this.investor, this.angellistUrl, this.image, this.locations, this.roles);
        }
    }
}

