/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.angellist.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vc.inreach.angellist.api.ChildTags;
import vc.inreach.angellist.api.Entity;
import vc.inreach.angellist.api.ParentTags;
import vc.inreach.angellist.api.Startup;
import vc.inreach.angellist.api.StartupRole;
import vc.inreach.angellist.api.StartupRoles;
import vc.inreach.angellist.api.Startups;
import vc.inreach.angellist.api.User;
import vc.inreach.angellist.client.AngellistClient;

public class HttpAngellistClient
implements AngellistClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpAngellistClient.class);
    private static final String PREFIX = "/1/";
    private static final String STARTUP = "/1/startups/{id}";
    private static final String STARTUP_ROLES = "/1/startups/{id}/roles";
    private static final String USER = "/1/users/{id}";
    private static final String STARTUPS = "/1/tags/{tag}/startups";
    private static final String TAG_PARENTS = "/1/tags/{tag}/parents";
    private static final String TAG_CHILDREN = "/1/tags/{tag}/children";
    private static final String ID = "id";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String PAGE = "page";
    private static final String TAG = "tag";
    private static final String SLUGS = "/1/search/slugs";
    private static final String QUERY = "query";
    private final Client client;
    private final String apiKey;
    private final String host;

    public HttpAngellistClient(Client client, String apiKey, String host) {
        this.client = client;
        this.apiKey = apiKey;
        this.host = host;
    }

    @Override
    public Optional<Startup> get(long id) {
        LOGGER.info("Requesting Angellist Startup: {}", (Object)id);
        try {
            return Optional.of(this.client.target(this.uriBuilder(STARTUP).buildFromMap((Map)ImmutableMap.of((Object)ID, (Object)id))).queryParam(ACCESS_TOKEN, new Object[]{this.apiKey}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Startup.class));
        }
        catch (NotFoundException e) {
            LOGGER.info("Unable to find Angellist startup {}", (Object)id);
            return Optional.empty();
        }
    }

    @Override
    public Startups startups(int tagId, int page) {
        LOGGER.info("Requesting Angellist Startups from tag: {}, page: {}", (Object)tagId, (Object)page);
        try {
            return (Startups)this.client.target(this.uriBuilder(STARTUPS).buildFromMap((Map)ImmutableMap.of((Object)TAG, (Object)tagId))).queryParam(ACCESS_TOKEN, new Object[]{this.apiKey}).queryParam(PAGE, new Object[]{page}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Startups.class);
        }
        catch (NotFoundException e) {
            return Startups.builder().withStartups((List<Startup>)ImmutableList.of()).withLastPage(0).withPage(page).withPerPage(0).withTotal(0).build();
        }
    }

    @Override
    public Optional<User> user(long id) {
        LOGGER.info("Requesting Angellist user: {}", (Object)id);
        try {
            return Optional.of(this.client.target(this.uriBuilder(USER).buildFromMap((Map)ImmutableMap.of((Object)ID, (Object)id))).queryParam(ACCESS_TOKEN, new Object[]{this.apiKey}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(User.class));
        }
        catch (NotFoundException e) {
            LOGGER.info("Unable to find Angellist user {}", (Object)id);
            return Optional.empty();
        }
    }

    @Override
    public Optional<Entity> entity(String slug) {
        LOGGER.info("Requesting Angellist entity for: {}", (Object)slug);
        try {
            return Optional.of(this.client.target(this.uriBuilder(SLUGS)).queryParam(ACCESS_TOKEN, new Object[]{this.apiKey}).queryParam(QUERY, new Object[]{slug}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Entity.class));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public StartupRoles startupRoles(long id) {
        LOGGER.info("Requesting Angellist Startup roles for: {}", (Object)id);
        try {
            return (StartupRoles)this.client.target(this.uriBuilder(STARTUP_ROLES).buildFromMap((Map)ImmutableMap.of((Object)ID, (Object)id))).queryParam(ACCESS_TOKEN, new Object[]{this.apiKey}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(StartupRoles.class);
        }
        catch (NotFoundException e) {
            return StartupRoles.builder().withLastPage(1).withPage(1).withPerPage(50).withTotal(0).withStartupRoles((List<StartupRole>)ImmutableList.of()).build();
        }
    }

    @Override
    public Optional<ParentTags> parentTags(long id, int page) {
        LOGGER.info("Requesting Angellist parent tags for: {}", (Object)id);
        try {
            return Optional.of(this.client.target(this.uriBuilder(TAG_PARENTS).buildFromMap((Map)ImmutableMap.of((Object)TAG, (Object)id))).queryParam(ACCESS_TOKEN, new Object[]{this.apiKey}).queryParam(PAGE, new Object[]{page}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ParentTags.class));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<ChildTags> childTags(long id, int page) {
        LOGGER.info("Requesting Angellist child tags for: {}", (Object)id);
        try {
            return Optional.of(this.client.target(this.uriBuilder(TAG_CHILDREN).buildFromMap((Map)ImmutableMap.of((Object)TAG, (Object)id))).queryParam(ACCESS_TOKEN, new Object[]{this.apiKey}).queryParam(PAGE, new Object[]{page}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ChildTags.class));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    private UriBuilder uriBuilder(String path) {
        return UriBuilder.fromPath((String)(this.host + path));
    }
}

