/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox;

import com.thoughtworks.qdox.Searcher;
import com.thoughtworks.qdox.directorywalker.DirectoryScanner;
import com.thoughtworks.qdox.directorywalker.FileVisitor;
import com.thoughtworks.qdox.directorywalker.SuffixFilter;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassCache;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.ModelBuilder;
import com.thoughtworks.qdox.parser.impl.JFlexLexer;
import com.thoughtworks.qdox.parser.impl.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JavaDocBuilder
implements Serializable,
JavaClassCache {
    private Map classes = new HashMap();
    private ClassLibrary classLibrary;
    private List sources = new ArrayList();

    public JavaDocBuilder() {
        this.classLibrary = new ClassLibrary(this);
        this.classLibrary.addDefaultLoader();
    }

    private void addClasses(JavaSource javaSource) {
        JavaClass[] javaClassArray = javaSource.getClasses();
        int n = 0;
        while (n < javaClassArray.length) {
            JavaClass javaClass = javaClassArray[n];
            this.classes.put(javaClass.getFullyQualifiedName(), javaClass);
            javaClass.setJavaClassCache(this);
            ++n;
        }
    }

    public JavaClass getClassByName(String string) {
        return (JavaClass)this.classes.get(string);
    }

    public JavaSource addSource(Reader reader) {
        ModelBuilder modelBuilder = new ModelBuilder(this.classLibrary);
        JFlexLexer jFlexLexer = new JFlexLexer(reader);
        Parser parser = new Parser(jFlexLexer, modelBuilder);
        parser.parse();
        JavaSource javaSource = modelBuilder.getSource();
        this.sources.add(javaSource);
        this.addClasses(javaSource);
        return javaSource;
    }

    public void addSource(File file) throws FileNotFoundException {
        JavaSource javaSource = this.addSource(new FileReader(file));
        javaSource.setFile(file);
    }

    public JavaSource[] getSources() {
        return this.sources.toArray(new JavaSource[this.sources.size()]);
    }

    public void addSourceTree(File file) {
        DirectoryScanner directoryScanner = new DirectoryScanner(file);
        directoryScanner.addFilter(new SuffixFilter(".java"));
        directoryScanner.scan(new FileVisitor(){

            public void visitFile(File file) {
                try {
                    JavaDocBuilder.this.addSource(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new RuntimeException("Cannot read file : " + file.getName());
                }
            }
        });
    }

    public List search(Searcher searcher) {
        LinkedList<JavaClass> linkedList = new LinkedList<JavaClass>();
        Iterator iterator = this.classLibrary.all().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JavaClass javaClass = this.getClassByName(string);
            if (!searcher.eval(javaClass)) continue;
            linkedList.add(javaClass);
        }
        return linkedList;
    }

    public ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        try {
            objectOutputStream.writeObject(this);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            objectOutputStream.close();
            fileOutputStream.close();
            throw throwable;
        }
        objectOutputStream.close();
        fileOutputStream.close();
    }

    public static JavaDocBuilder load(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        JavaDocBuilder javaDocBuilder = null;
        try {
            try {
                javaDocBuilder = (JavaDocBuilder)objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error("Couldn't load class : " + classNotFoundException.getMessage());
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            objectInputStream.close();
            fileInputStream.close();
            throw throwable;
        }
        objectInputStream.close();
        fileInputStream.close();
        return javaDocBuilder;
    }
}

