/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;

public class JavaMethod
extends AbstractJavaEntity {
    protected Type returns;
    private JavaParameter[] parameters;
    private Type[] exceptions;
    private boolean constructor;
    private JavaClass parentClass;

    public Type getReturns() {
        return this.returns;
    }

    public JavaParameter[] getParameters() {
        return this.parameters == null ? new JavaParameter[]{} : this.parameters;
    }

    public Type[] getExceptions() {
        return this.exceptions;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    protected void writeBody(IndentBuffer indentBuffer) {
        int n;
        this.writeAccessibilityModifier(indentBuffer);
        this.writeNonAccessibilityModifiers(indentBuffer);
        if (!this.constructor) {
            indentBuffer.write(this.returns.getValue());
            n = 0;
            while (n < this.returns.getDimensions()) {
                indentBuffer.write("[]");
                ++n;
            }
            indentBuffer.write(' ');
        }
        indentBuffer.write(this.name);
        indentBuffer.write('(');
        n = 0;
        while (this.parameters != null && n < this.parameters.length) {
            JavaParameter javaParameter = this.parameters[n];
            if (n > 0) {
                indentBuffer.write(", ");
            }
            indentBuffer.write(javaParameter.getType().getValue());
            int n2 = 0;
            while (n2 < javaParameter.getType().getDimensions()) {
                indentBuffer.write("[]");
                ++n2;
            }
            indentBuffer.write(' ');
            indentBuffer.write(javaParameter.getName());
            ++n;
        }
        indentBuffer.write(')');
        if (this.exceptions != null && this.exceptions.length > 0) {
            indentBuffer.write(" throws ");
            int n3 = 0;
            while (n3 < this.exceptions.length) {
                if (n3 > 0) {
                    indentBuffer.write(", ");
                }
                indentBuffer.write(this.exceptions[n3].getValue());
                ++n3;
            }
        }
        indentBuffer.write(';');
        indentBuffer.newline();
    }

    public void setReturns(Type type) {
        this.returns = type;
    }

    public void setParameters(JavaParameter[] javaParameterArray) {
        int n = 0;
        while (n < javaParameterArray.length) {
            javaParameterArray[n].setParentMethod(this);
            ++n;
        }
        this.parameters = javaParameterArray;
    }

    public void setExceptions(Type[] typeArray) {
        this.exceptions = typeArray;
    }

    public void setConstructor(boolean bl) {
        this.constructor = bl;
    }

    public boolean equals(Object object) {
        JavaMethod javaMethod = (JavaMethod)object;
        if (!javaMethod.getName().equals(this.getName())) {
            return false;
        }
        if (!javaMethod.getReturns().equals(this.getReturns())) {
            return false;
        }
        JavaParameter[] javaParameterArray = this.getParameters();
        JavaParameter[] javaParameterArray2 = javaMethod.getParameters();
        if (javaParameterArray2.length != javaParameterArray.length) {
            return false;
        }
        int n = 0;
        while (n < javaParameterArray.length) {
            if (!javaParameterArray2[n].equals(javaParameterArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return this.name.hashCode() * this.returns.hashCode() * this.getParameters().length;
    }

    public JavaClass getParentClass() {
        return this.parentClass;
    }

    public void setParentClass(JavaClass javaClass) {
        this.parentClass = javaClass;
    }
}

