/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassParent;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaSource
implements Serializable,
JavaClassParent {
    private static final Set PRIMITIVE_TYPES = new HashSet();
    private File file;
    private String packge;
    private List imports = new LinkedList();
    private String[] importsArray;
    private List classes = new LinkedList();
    private JavaClass[] classesArray;
    private ClassLibrary classLibrary;
    private Map typeCache = new HashMap();

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String getPackage() {
        return this.packge;
    }

    public void setPackage(String string) {
        this.packge = string;
    }

    public void addImport(String string) {
        this.imports.add(string);
        this.importsArray = null;
    }

    public String[] getImports() {
        if (this.importsArray == null) {
            this.importsArray = new String[this.imports.size()];
            this.imports.toArray(this.importsArray);
        }
        return this.importsArray;
    }

    public void addClass(JavaClass javaClass) {
        this.classes.add(javaClass);
        javaClass.setParent(this);
        this.classesArray = null;
    }

    public JavaClass[] getClasses() {
        if (this.classesArray == null) {
            this.classesArray = new JavaClass[this.classes.size()];
            this.classes.toArray(this.classesArray);
        }
        return this.classesArray;
    }

    public ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }

    public void setClassLibrary(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
    }

    public String toString() {
        IndentBuffer indentBuffer = new IndentBuffer();
        if (this.packge != null) {
            indentBuffer.write("package ");
            indentBuffer.write(this.packge);
            indentBuffer.write(';');
            indentBuffer.newline();
            indentBuffer.newline();
        }
        String[] stringArray = this.getImports();
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            indentBuffer.write("import ");
            indentBuffer.write(stringArray[n]);
            indentBuffer.write(';');
            indentBuffer.newline();
            ++n;
        }
        if (stringArray != null && stringArray.length > 0) {
            indentBuffer.newline();
        }
        JavaClass[] javaClassArray = this.getClasses();
        int n2 = 0;
        while (n2 < javaClassArray.length) {
            if (n2 > 0) {
                indentBuffer.newline();
            }
            javaClassArray[n2].write(indentBuffer);
            ++n2;
        }
        return indentBuffer.toString();
    }

    public String resolveType(String string) {
        String string2 = (String)this.typeCache.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = this.resolveTypeInternal(string);
        if (string2 != null) {
            this.typeCache.put(string, string2);
        }
        return string2;
    }

    private String resolveTypeInternal(String string) {
        if (string.indexOf(46) != -1) {
            return string;
        }
        if (PRIMITIVE_TYPES.contains(string)) {
            return string;
        }
        String[] stringArray = this.getImports();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith("." + string)) {
                return stringArray[n];
            }
            ++n;
        }
        if (this.getClassLibrary() == null) {
            return null;
        }
        String string2 = this.packge + "." + string;
        if (this.getClassLibrary().contains(string2)) {
            return string2;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].endsWith(".*")) {
                string2 = stringArray[n2].substring(0, stringArray[n2].length() - 1) + string;
                if (this.getClassLibrary().contains(string2)) {
                    return string2;
                }
            }
            ++n2;
        }
        string2 = "java.lang." + string;
        if (this.getClassLibrary().contains(string2)) {
            return string2;
        }
        return null;
    }

    public String asClassNamespace() {
        return this.getPackage();
    }

    public JavaSource getParentSource() {
        return this;
    }

    static {
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("char");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("void");
    }
}

