/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTool {
    public static final String DEFAULT_FORMAT = "default";

    public static final Date getSystemDate() {
        return DateTool.getSystemCalendar().getTime();
    }

    public static final Calendar getSystemCalendar() {
        return Calendar.getInstance();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public Date getDate() {
        return this.getCalendar().getTime();
    }

    public Calendar getCalendar() {
        return Calendar.getInstance(this.getTimeZone(), this.getLocale());
    }

    public String getFormat() {
        return DEFAULT_FORMAT;
    }

    public String getFormattedDate(String string) {
        return this.format(string, this.getDate());
    }

    public String get(String string) {
        return this.format(string, this.getDate());
    }

    public String get(String string, String string2) {
        return this.format(string, string2, this.getDate(), this.getLocale());
    }

    public String format(Object object) {
        return this.format(this.getFormat(), object);
    }

    public String format(String string, Object object) {
        return this.format(string, object, this.getLocale());
    }

    public String format(String string, Object object, Locale locale) {
        return this.format(string, object, locale, this.getTimeZone());
    }

    public String format(String string, Object object, Locale locale, TimeZone timeZone) {
        Date date = this.toDate(object);
        DateFormat dateFormat = this.getDateFormat(string, locale, timeZone);
        if (date == null || dateFormat == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public String format(String string, String string2, Object object) {
        return this.format(string, string2, object, this.getLocale());
    }

    public String format(String string, String string2, Object object, Locale locale) {
        return this.format(string, string2, object, locale, this.getTimeZone());
    }

    public String format(String string, String string2, Object object, Locale locale, TimeZone timeZone) {
        Date date = this.toDate(object);
        DateFormat dateFormat = this.getDateFormat(string, string2, locale, timeZone);
        if (date == null || dateFormat == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public DateFormat getDateFormat(String string, Locale locale, TimeZone timeZone) {
        if (string == null) {
            return null;
        }
        DateFormat dateFormat = null;
        if (string.endsWith("_date")) {
            String string2 = string.substring(0, string.length() - 5);
            int n = this.getStyleAsInt(string2);
            dateFormat = this.getDateFormat(n, -1, locale, timeZone);
        } else if (string.endsWith("_time")) {
            String string3 = string.substring(0, string.length() - 5);
            int n = this.getStyleAsInt(string3);
            dateFormat = this.getDateFormat(-1, n, locale, timeZone);
        } else {
            int n = this.getStyleAsInt(string);
            if (n < 0) {
                dateFormat = new SimpleDateFormat(string, locale);
                dateFormat.setTimeZone(timeZone);
            } else {
                dateFormat = this.getDateFormat(n, n, locale, timeZone);
            }
        }
        return dateFormat;
    }

    public DateFormat getDateFormat(String string, String string2, Locale locale, TimeZone timeZone) {
        int n = this.getStyleAsInt(string);
        int n2 = this.getStyleAsInt(string2);
        return this.getDateFormat(n, n2, locale, timeZone);
    }

    protected DateFormat getDateFormat(int n, int n2, Locale locale, TimeZone timeZone) {
        try {
            DateFormat dateFormat = n < 0 && n2 < 0 ? DateFormat.getInstance() : (n2 < 0 ? DateFormat.getDateInstance(n, locale) : (n < 0 ? DateFormat.getTimeInstance(n2, locale) : DateFormat.getDateTimeInstance(n, n2, locale)));
            dateFormat.setTimeZone(timeZone);
            return dateFormat;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected int getStyleAsInt(String string) {
        if (string == null || string.length() < 4 || string.length() > 7) {
            return -1;
        }
        if (string.equalsIgnoreCase("full")) {
            return 0;
        }
        if (string.equalsIgnoreCase("long")) {
            return 1;
        }
        if (string.equalsIgnoreCase("medium")) {
            return 2;
        }
        if (string.equalsIgnoreCase("short")) {
            return 3;
        }
        if (string.equalsIgnoreCase(DEFAULT_FORMAT)) {
            return 2;
        }
        return -1;
    }

    public Date toDate(Object object) {
        return this.toDate(this.getFormat(), object, this.getLocale(), this.getTimeZone());
    }

    public Date toDate(String string, Object object) {
        return this.toDate(string, object, this.getLocale(), this.getTimeZone());
    }

    public Date toDate(String string, Object object, Locale locale) {
        return this.toDate(string, object, locale, this.getTimeZone());
    }

    public Date toDate(String string, Object object, Locale locale, TimeZone timeZone) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        if (object instanceof Long) {
            Date date = new Date();
            date.setTime((Long)object);
            return date;
        }
        try {
            DateFormat dateFormat = this.getDateFormat(string, locale, timeZone);
            return dateFormat.parse(String.valueOf(object));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Calendar toCalendar(Object object) {
        return this.toCalendar(object, this.getLocale());
    }

    public Calendar toCalendar(Object object, Locale locale) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        Date date = this.toDate(object);
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        calendar.getTime();
        return calendar;
    }

    public String toString() {
        return this.format(this.getFormat(), this.getDate());
    }
}

