/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.lang.reflect.Array;
import java.util.List;

public class ListTool {
    public Object get(Object object, int n) {
        if (this.isArray(object)) {
            return this.getFromArray(object, n);
        }
        if (!this.isList(object)) {
            return null;
        }
        try {
            return ((List)object).get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private Object getFromArray(Object object, int n) {
        try {
            return Array.get(object, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public Object set(Object object, int n, Object object2) {
        if (this.isArray(object)) {
            return this.setToArray(object, n, object2);
        }
        if (!this.isList(object)) {
            return null;
        }
        try {
            ((List)object).set(n, object2);
            return "";
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private Object setToArray(Object object, int n, Object object2) {
        try {
            Array.set(object, n, object2);
            return "";
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public Integer size(Object object) {
        if (this.isArray(object)) {
            return new Integer(Array.getLength(object));
        }
        if (!this.isList(object)) {
            return null;
        }
        return new Integer(((List)object).size());
    }

    public boolean isArray(Object object) {
        if (object == null) {
            return false;
        }
        return object.getClass().isArray();
    }

    public boolean isList(Object object) {
        return object instanceof List;
    }

    public Boolean isEmpty(Object object) {
        Integer n = this.size(object);
        if (n == null) {
            return null;
        }
        return new Boolean(n == 0);
    }

    public Boolean contains(Object object, Object object2) {
        if (this.isArray(object)) {
            return this.arrayContains(object, object2);
        }
        if (!this.isList(object)) {
            return null;
        }
        return new Boolean(((List)object).contains(object2));
    }

    private Boolean arrayContains(Object object, Object object2) {
        int n = this.size(object);
        for (int i = 0; i < n; ++i) {
            if (!this.equals(object2, this.getFromArray(object, i))) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }
}

