/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.beanutils.PropertyUtils;

public class MathTool {
    public Number add(Object object, Object object2) {
        Number number = this.toNumber(object);
        Number number2 = this.toNumber(object2);
        if (number == null || number2 == null) {
            return null;
        }
        double d = number.doubleValue() + number2.doubleValue();
        return this.matchType(number, number2, d);
    }

    public Number sub(Object object, Object object2) {
        Number number = this.toNumber(object);
        Number number2 = this.toNumber(object2);
        if (number == null || number2 == null) {
            return null;
        }
        double d = number.doubleValue() - number2.doubleValue();
        return this.matchType(number, number2, d);
    }

    public Number mul(Object object, Object object2) {
        Number number = this.toNumber(object);
        Number number2 = this.toNumber(object2);
        if (number == null || number2 == null) {
            return null;
        }
        double d = number.doubleValue() * number2.doubleValue();
        return this.matchType(number, number2, d);
    }

    public Number div(Object object, Object object2) {
        Number number = this.toNumber(object);
        Number number2 = this.toNumber(object2);
        if (number == null || number2 == null || number2.doubleValue() == 0.0) {
            return null;
        }
        double d = number.doubleValue() / number2.doubleValue();
        return this.matchType(number, number2, d);
    }

    public Number pow(Object object, Object object2) {
        Number number = this.toNumber(object);
        Number number2 = this.toNumber(object2);
        if (number == null || number2 == null) {
            return null;
        }
        double d = Math.pow(number.doubleValue(), number2.doubleValue());
        return this.matchType(number, number2, d);
    }

    public Integer idiv(Object object, Object object2) {
        Number number = this.toNumber(object);
        Number number2 = this.toNumber(object2);
        if (number == null || number2 == null || number2.intValue() == 0) {
            return null;
        }
        int n = number.intValue() / number2.intValue();
        return new Integer(n);
    }

    public Integer mod(Object object, Object object2) {
        Number number = this.toNumber(object);
        Number number2 = this.toNumber(object2);
        if (number == null || number2 == null || number2.intValue() == 0) {
            return null;
        }
        int n = number.intValue() % number2.intValue();
        return new Integer(n);
    }

    public Number max(Object object, Object object2) {
        Number number = this.toNumber(object);
        Number number2 = this.toNumber(object2);
        if (number == null || number2 == null) {
            return null;
        }
        double d = Math.max(number.doubleValue(), number2.doubleValue());
        return this.matchType(number, number2, d);
    }

    public Number min(Object object, Object object2) {
        Number number = this.toNumber(object);
        Number number2 = this.toNumber(object2);
        if (number == null || number2 == null) {
            return null;
        }
        double d = Math.min(number.doubleValue(), number2.doubleValue());
        return this.matchType(number, number2, d);
    }

    public Number abs(Object object) {
        Number number = this.toNumber(object);
        if (number == null) {
            return null;
        }
        double d = Math.abs(number.doubleValue());
        return this.matchType(number, d);
    }

    public Integer ceil(Object object) {
        Number number = this.toNumber(object);
        if (number == null) {
            return null;
        }
        return new Integer((int)Math.ceil(number.doubleValue()));
    }

    public Integer floor(Object object) {
        Number number = this.toNumber(object);
        if (number == null) {
            return null;
        }
        return new Integer((int)Math.floor(number.doubleValue()));
    }

    public Integer round(Object object) {
        Number number = this.toNumber(object);
        if (number == null) {
            return null;
        }
        return new Integer((int)Math.rint(number.doubleValue()));
    }

    public Double roundTo(Object object, Object object2) {
        Number number = this.toNumber(object);
        Number number2 = this.toNumber(object2);
        if (number == null || number2 == null) {
            return null;
        }
        int n = number.intValue();
        double d = number2.doubleValue();
        if (n == 0) {
            d = (int)(d + 0.5);
        } else {
            double d2 = Math.pow(10.0, n);
            d *= d2;
            d = (int)(d + 0.5);
            d /= d2;
        }
        return new Double(d);
    }

    public Double getRandom() {
        return new Double(Math.random());
    }

    public Number random(Object object, Object object2) {
        Number number = this.toNumber(object);
        Number number2 = this.toNumber(object2);
        if (number == null || number2 == null) {
            return null;
        }
        double d = number2.doubleValue() - number.doubleValue();
        double d2 = d * Math.random() + number.doubleValue();
        String string = number.toString() + number2.toString();
        if (string.indexOf(46) < 0) {
            return this.matchType(number, number2, Math.floor(d2));
        }
        return new Double(d2);
    }

    public Integer toInteger(Object object) {
        Number number = this.toNumber(object);
        if (number == null) {
            return null;
        }
        return new Integer(number.intValue());
    }

    public Double toDouble(Object object) {
        Number number = this.toNumber(object);
        if (number == null) {
            return null;
        }
        return new Double(number.doubleValue());
    }

    public Number toNumber(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        try {
            return this.parseNumber(String.valueOf(object));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected Number matchType(Number number, double d) {
        return this.matchType(number, null, d);
    }

    protected Number matchType(Number number, Number number2, double d) {
        boolean bl;
        boolean bl2 = bl = Math.rint(d) == d;
        if (bl) {
            String string = number.toString();
            boolean bl3 = bl = string.indexOf(46) < 0;
            if (bl && number2 != null) {
                string = number2.toString();
                boolean bl4 = bl = string.indexOf(46) < 0;
            }
        }
        if (!bl) {
            return new Double(d);
        }
        if (d > 2.147483647E9 || d < -2.147483648E9) {
            return new Long((long)d);
        }
        return new Integer((int)d);
    }

    protected Number parseNumber(String string) throws NumberFormatException {
        if (string.indexOf(46) < 0) {
            long l = new Long(string);
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                return new Long(l);
            }
            return new Integer((int)l);
        }
        return new Double(string);
    }

    public Number getTotal(Collection collection, String string) {
        if (collection == null || string == null) {
            return null;
        }
        try {
            double d = 0.0;
            Number number = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object = PropertyUtils.getProperty(iterator.next(), (String)string);
                Number number2 = this.toNumber(object);
                if (number == null) {
                    number = number2;
                }
                d += number2.doubleValue();
            }
            return this.matchType(number, d);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Number getAverage(Collection collection, String string) {
        Number number = this.getTotal(collection, string);
        if (number == null) {
            return null;
        }
        double d = number.doubleValue() / (double)collection.size();
        return this.matchType(number, d);
    }

    public Number getTotal(Object[] objectArray, String string) {
        return this.getTotal(Arrays.asList(objectArray), string);
    }

    public Number getAverage(Object[] objectArray, String string) {
        return this.getAverage(Arrays.asList(objectArray), string);
    }

    public Number getTotal(Collection collection) {
        if (collection == null) {
            return null;
        }
        double d = 0.0;
        Number number = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Number number2 = this.toNumber(iterator.next());
            if (number2 == null) {
                return null;
            }
            if (number == null) {
                number = number2;
            }
            d += number2.doubleValue();
        }
        return this.matchType(number, d);
    }

    public Number getAverage(Collection collection) {
        Number number = this.getTotal(collection);
        if (number == null) {
            return null;
        }
        double d = number.doubleValue() / (double)collection.size();
        return this.matchType(number, d);
    }

    public Number getTotal(Object[] objectArray) {
        return this.getTotal(Arrays.asList(objectArray));
    }

    public Number getAverage(Object[] objectArray) {
        return this.getAverage(Arrays.asList(objectArray));
    }

    public Number getTotal(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return new Double(d);
    }

    public Number getAverage(double[] dArray) {
        Number number = this.getTotal(dArray);
        if (number == null) {
            return null;
        }
        return new Double(number.doubleValue() / (double)dArray.length);
    }

    public Number getTotal(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        long l = 0L;
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i];
        }
        return new Long(l);
    }

    public Number getAverage(long[] lArray) {
        Number number = this.getTotal(lArray);
        if (number == null) {
            return null;
        }
        double d = number.doubleValue() / (double)lArray.length;
        return this.matchType(number, d);
    }
}

