/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class SortTool {
    public Collection sort(Collection collection) {
        return this.sort(collection, (List)null);
    }

    public Collection sort(Object[] objectArray) {
        return this.sort(objectArray, (List)null);
    }

    public Collection sort(Map map) {
        return this.sort(map, (List)null);
    }

    public Collection sort(Object object, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        if (object instanceof Collection) {
            return this.sort((Collection)object, arrayList);
        }
        if (object instanceof Object[]) {
            return this.sort((Object[])object, arrayList);
        }
        if (object instanceof Map) {
            return this.sort((Map)object, arrayList);
        }
        return null;
    }

    public Collection sort(Collection collection, List list) {
        ArrayList arrayList = new ArrayList(collection.size());
        arrayList.addAll(collection);
        return this.internalSort(arrayList, list);
    }

    public Collection sort(Map map, List list) {
        return this.sort(map.values(), list);
    }

    public Collection sort(Object[] objectArray, List list) {
        return this.internalSort(Arrays.asList(objectArray), list);
    }

    protected Collection internalSort(List list, List list2) {
        try {
            if (list2 == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, new PropertiesComparator(list2));
            }
            return list;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static Comparable getComparable(Object object, String string) {
        try {
            return (Comparable)PropertyUtils.getProperty((Object)object, (String)string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not retrieve comparable value for '" + string + "' from " + object + ": " + exception);
        }
    }

    public class PropertiesComparator
    implements Comparator {
        private static final int TYPE_ASCENDING = 1;
        private static final int TYPE_DESCENDING = -1;
        public static final String TYPE_ASCENDING_SHORT = "asc";
        public static final String TYPE_DESCENDING_SHORT = "desc";
        List properties;
        int[] sortTypes;

        public PropertiesComparator(List list) {
            this.properties = list;
            this.sortTypes = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null) {
                    throw new IllegalArgumentException("Property " + i + "is null, sort properties may not be null.");
                }
                String string = list.get(i).toString();
                int n = string.indexOf(58);
                if (n != -1) {
                    String string2 = string.substring(n + 1);
                    list.set(i, string.substring(0, n));
                    if (TYPE_ASCENDING_SHORT.equalsIgnoreCase(string2)) {
                        this.sortTypes[i] = 1;
                        continue;
                    }
                    if (TYPE_DESCENDING_SHORT.equalsIgnoreCase(string2)) {
                        this.sortTypes[i] = -1;
                        continue;
                    }
                    this.sortTypes[i] = 1;
                    continue;
                }
                this.sortTypes[i] = 1;
            }
        }

        public int compare(Object object, Object object2) {
            for (int i = 0; i < this.properties.size(); ++i) {
                int n = 0;
                String string = (String)this.properties.get(i);
                Comparable comparable = SortTool.getComparable(object, string);
                Comparable comparable2 = SortTool.getComparable(object2, string);
                if (comparable == null && comparable2 != null) {
                    n = comparable2.compareTo(comparable);
                    n *= -1;
                } else {
                    n = comparable instanceof String ? ((String)((Object)comparable)).compareToIgnoreCase((String)((Object)comparable2)) : comparable.compareTo(comparable2);
                }
                if (n == 0) continue;
                return n * this.sortTypes[i];
            }
            return 0;
        }
    }
}

