/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.view.servlet.VelocityViewServlet;

public class VelocityLayoutServlet
extends VelocityViewServlet {
    public static final String PROPERTY_ERROR_TEMPLATE = "tools.view.servlet.error.template";
    public static final String PROPERTY_LAYOUT_DIR = "tools.view.servlet.layout.directory";
    public static final String PROPERTY_DEFAULT_LAYOUT = "tools.view.servlet.layout.default.template";
    public static String DEFAULT_ERROR_TEMPLATE = "Error.vm";
    public static String DEFAULT_LAYOUT_DIR = "layout/";
    public static String DEFAULT_DEFAULT_LAYOUT = "Default.vm";
    public static String KEY_SCREEN_CONTENT = "screen_content";
    public static String KEY_LAYOUT = "layout";
    public static String KEY_ERROR_CAUSE = "error_cause";
    public static String KEY_ERROR_STACKTRACE = "stack_trace";
    public static String KEY_ERROR_INVOCATION_EXCEPTION = "invocation_exception";
    protected String errorTemplate;
    protected String layoutDir;
    protected String defaultLayout;
    private VelocityEngine velocity;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.velocity = super.getVelocityEngine();
        this.errorTemplate = this.getVelocityProperty(PROPERTY_ERROR_TEMPLATE, DEFAULT_ERROR_TEMPLATE);
        this.layoutDir = this.getVelocityProperty(PROPERTY_LAYOUT_DIR, DEFAULT_LAYOUT_DIR);
        this.defaultLayout = this.getVelocityProperty(PROPERTY_DEFAULT_LAYOUT, DEFAULT_DEFAULT_LAYOUT);
        if (!this.layoutDir.endsWith("/")) {
            this.layoutDir = this.layoutDir + '/';
        }
        this.velocity.info((Object)("VelocityLayoutServlet: Error screen is '" + this.errorTemplate + "'"));
        this.velocity.info((Object)("VelocityLayoutServlet: Layout directory is '" + this.layoutDir + "'"));
        this.velocity.info((Object)("VelocityLayoutServlet: Default layout template is '" + this.defaultLayout + "'"));
        this.defaultLayout = this.layoutDir + this.defaultLayout;
    }

    protected Context createContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Context context = super.createContext(httpServletRequest, httpServletResponse);
        String string = httpServletRequest.getParameter(KEY_LAYOUT);
        if (string != null) {
            context.put(KEY_LAYOUT, (Object)string);
        }
        return context;
    }

    protected void mergeTemplate(Template template, Context context, HttpServletResponse httpServletResponse) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException, UnsupportedEncodingException, Exception {
        block2: {
            StringWriter stringWriter = new StringWriter();
            template.merge(context, (Writer)stringWriter);
            context.put(KEY_SCREEN_CONTENT, (Object)stringWriter.toString());
            Object object = context.get(KEY_LAYOUT);
            String string = object == null ? null : object.toString();
            string = string == null ? this.defaultLayout : this.layoutDir + string;
            try {
                template = this.getTemplate(string);
            }
            catch (Exception exception) {
                this.velocity.error((Object)("VelocityLayoutServlet: Can't load layout \"" + string + "\": " + exception));
                if (string.equals(this.defaultLayout)) break block2;
                template = this.getTemplate(this.defaultLayout);
            }
        }
        super.mergeTemplate(template, context, httpServletResponse);
    }

    protected void error(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) throws ServletException {
        try {
            Context context = this.createContext(httpServletRequest, httpServletResponse);
            Throwable throwable = exception;
            if (throwable instanceof MethodInvocationException) {
                context.put(KEY_ERROR_INVOCATION_EXCEPTION, (Object)exception);
                throwable = ((MethodInvocationException)exception).getWrappedThrowable();
            }
            context.put(KEY_ERROR_CAUSE, (Object)throwable);
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            context.put(KEY_ERROR_STACKTRACE, (Object)stringWriter.toString());
            Template template = this.getTemplate(this.errorTemplate);
            this.mergeTemplate(template, context, httpServletResponse);
        }
        catch (Exception exception2) {
            this.velocity.error((Object)("VelocityLayoutServlet:  Error during error template rendering - " + exception2));
            super.error(httpServletRequest, httpServletResponse, exception);
        }
    }
}

