/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public class LinkTool
implements ViewTool,
Cloneable {
    protected static final Log LOG = LogFactory.getLog((Class)(class$org$apache$velocity$tools$view$tools$LinkTool == null ? (class$org$apache$velocity$tools$view$tools$LinkTool = LinkTool.class$("org.apache.velocity.tools.view.tools.LinkTool")) : class$org$apache$velocity$tools$view$tools$LinkTool));
    public static final String HTML_QUERY_DELIMITER = "&";
    public static final String XHTML_QUERY_DELIMITER = "&amp;";
    protected ServletContext application;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    private String uri = null;
    private String anchor = null;
    private ArrayList queryData = null;
    private String queryDataDelim = "&";
    private static Method encode = null;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$tools$LinkTool;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URLEncoder;

    protected void setXhtml(boolean bl) {
        this.queryDataDelim = bl ? XHTML_QUERY_DELIMITER : HTML_QUERY_DELIMITER;
    }

    protected LinkTool copyWith(QueryPair queryPair) {
        LinkTool linkTool = this.duplicate();
        linkTool.queryData = linkTool.queryData != null ? (ArrayList)this.queryData.clone() : new ArrayList();
        linkTool.queryData.add(queryPair);
        return linkTool;
    }

    protected LinkTool copyWith(String string) {
        LinkTool linkTool = this.duplicate();
        linkTool.uri = string;
        return linkTool;
    }

    protected LinkTool copyWithAnchor(String string) {
        LinkTool linkTool = this.duplicate();
        linkTool.anchor = string;
        return linkTool;
    }

    private LinkTool duplicate() {
        try {
            return (LinkTool)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LinkTool linkTool;
            LOG.warn((Object)("Could not properly clone " + this.getClass() + " - " + cloneNotSupportedException));
            try {
                linkTool = (LinkTool)this.getClass().newInstance();
            }
            catch (Exception exception) {
                linkTool = new LinkTool();
            }
            linkTool.application = this.application;
            linkTool.request = this.request;
            linkTool.response = this.response;
            linkTool.uri = this.uri;
            linkTool.anchor = this.anchor;
            linkTool.queryData = this.queryData;
            linkTool.queryDataDelim = this.queryDataDelim;
            return linkTool;
        }
    }

    public void init(Object object) {
        if (!(object instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        ViewContext viewContext = (ViewContext)object;
        this.request = viewContext.getRequest();
        this.response = viewContext.getResponse();
        this.application = viewContext.getServletContext();
        Boolean bl = (Boolean)viewContext.getAttribute("XHTML");
        if (bl != null) {
            this.setXhtml(bl);
        }
    }

    public LinkTool setAnchor(String string) {
        return this.copyWithAnchor(string);
    }

    public String getAnchor() {
        return this.anchor;
    }

    public LinkTool setRelative(String string) {
        String string2 = this.request.getContextPath();
        if (string2.equals("/")) {
            string2 = "";
        }
        if (string.startsWith("/")) {
            return this.copyWith(string2 + string);
        }
        return this.copyWith(string2 + '/' + string);
    }

    public LinkTool setURI(String string) {
        return this.copyWith(string);
    }

    public String getURI() {
        return this.uri;
    }

    public LinkTool addQueryData(String string, Object object) {
        return this.copyWith(new QueryPair(string, object));
    }

    public String getQueryData() {
        if (this.queryData != null && !this.queryData.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.queryData.size(); ++i) {
                stringBuffer.append(this.queryData.get(i));
                if (i + 1 >= this.queryData.size()) continue;
                stringBuffer.append(this.queryDataDelim);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String getContextURL() {
        String string = this.request.getScheme();
        int n = this.request.getServerPort();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.request.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(this.request.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        stringBuffer.append(this.request.getContextPath());
        return stringBuffer.toString();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getBaseRef() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getContextURL());
        stringBuffer.append(this.request.getServletPath());
        return stringBuffer.toString();
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.uri != null) {
            stringBuffer.append(this.uri);
        }
        if ((string = this.getQueryData()) != null) {
            if (this.uri == null || this.uri.indexOf(63) < 0) {
                stringBuffer.append('?');
            } else {
                stringBuffer.append(this.queryDataDelim);
            }
            stringBuffer.append(string);
        }
        if (this.anchor != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.encodeURL(this.anchor));
        }
        return this.response.encodeURL(stringBuffer.toString());
    }

    public String encodeURL(String string) {
        if (encode != null) {
            try {
                Object[] objectArray = new Object[]{string, this.response.getCharacterEncoding()};
                return (String)encode.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                encode = null;
                LOG.debug((Object)("Can't access JDK 1.4 encode method (" + illegalAccessException + "). Using deprecated version from now on."));
            }
            catch (InvocationTargetException invocationTargetException) {
                LOG.debug((Object)("Error using JDK 1.4 encode method (" + invocationTargetException + "). Using deprecated version."));
            }
        }
        return URLEncoder.encode(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LinkTool.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = LinkTool.class$("java.lang.String")) : class$java$lang$String};
            encode = (class$java$net$URLEncoder == null ? (class$java$net$URLEncoder = LinkTool.class$("java.net.URLEncoder")) : class$java$net$URLEncoder).getMethod("encode", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.debug((Object)"Can't find JDK 1.4 encode method. Using JDK 1.3 version.");
        }
    }

    protected final class QueryPair {
        private final String key;
        private final Object value;

        public QueryPair(String string, Object object) {
            this.key = string;
            this.value = object;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.value == null) {
                stringBuffer.append(LinkTool.this.encodeURL(this.key));
                stringBuffer.append('=');
            } else if (this.value instanceof List) {
                this.appendAsArray(stringBuffer, this.key, ((List)this.value).toArray());
            } else if (this.value instanceof Object[]) {
                this.appendAsArray(stringBuffer, this.key, (Object[])this.value);
            } else {
                stringBuffer.append(LinkTool.this.encodeURL(this.key));
                stringBuffer.append('=');
                stringBuffer.append(LinkTool.this.encodeURL(String.valueOf(this.value)));
            }
            return stringBuffer.toString();
        }

        private void appendAsArray(StringBuffer stringBuffer, String string, Object[] objectArray) {
            String string2 = LinkTool.this.encodeURL(string);
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(string2);
                stringBuffer.append('=');
                if (objectArray[i] != null) {
                    stringBuffer.append(LinkTool.this.encodeURL(String.valueOf(objectArray[i])));
                }
                if (i + 1 >= objectArray.length) continue;
                stringBuffer.append(LinkTool.this.queryDataDelim);
            }
        }
    }
}

