/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.util.Iterator;
import java.util.Stack;
import org.apache.velocity.tools.ClassUtils;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.ValidScope;

@DefaultKey(value="loop")
@ValidScope(value={"request"})
public class LoopTool {
    private Stack<ManagedIterator> iterators = new Stack();

    public Iterator watch(Object obj) {
        Iterator iterator = LoopTool.getIterator(obj);
        if (iterator == null) {
            return null;
        }
        ManagedIterator managed = new ManagedIterator(iterator, this);
        this.iterators.push(managed);
        return managed;
    }

    public Iterator watch(Object obj, String name) {
        if (name == null) {
            return null;
        }
        Iterator iterator = LoopTool.getIterator(obj);
        if (iterator == null) {
            return null;
        }
        ManagedIterator managed = new ManagedIterator(name, iterator, this);
        this.iterators.push(managed);
        return managed;
    }

    public void stop() {
        if (!this.iterators.empty()) {
            this.iterators.peek().stop();
        }
    }

    public void stop(String name) {
        for (ManagedIterator iterator : this.iterators) {
            if (!iterator.getName().equals(name)) continue;
            iterator.stop();
            break;
        }
    }

    public void stopTo(String name) {
        if (!this.iterators.empty()) {
            ManagedIterator iterator;
            Stack<ManagedIterator> backup = new Stack<ManagedIterator>();
            boolean found = false;
            while (!found && !this.iterators.empty()) {
                iterator = this.iterators.pop();
                if (iterator.getName().equals(name)) {
                    found = true;
                    iterator.stop();
                    continue;
                }
                backup.push(iterator);
            }
            while (!backup.empty()) {
                iterator = (ManagedIterator)backup.pop();
                this.iterators.push(iterator);
                if (!found) continue;
                iterator.stop();
            }
        }
    }

    public void stopAll() {
        for (ManagedIterator iterator : this.iterators) {
            iterator.stop();
        }
    }

    public void skip(int number) {
        if (!this.iterators.empty()) {
            this.iterators.peek().skip(number);
        }
    }

    public void skip(int number, String name) {
        for (ManagedIterator iterator : this.iterators) {
            if (!iterator.getName().equals(name)) continue;
            iterator.skip(number);
            break;
        }
    }

    protected void pop() {
        this.iterators.pop();
    }

    protected static Iterator getIterator(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return ClassUtils.getIterator(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static class ManagedIterator
    implements Iterator {
        private String name;
        private Iterator iterator;
        private LoopTool owner;
        private boolean stopped = false;

        public ManagedIterator(Iterator iterator, LoopTool owner) {
            this(iterator.toString(), iterator, owner);
        }

        public ManagedIterator(String name, Iterator iterator, LoopTool owner) {
            if (name == null) {
                throw new NullPointerException("name cannot be null");
            }
            this.name = name;
            this.iterator = iterator;
            this.owner = owner;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasNext() {
            if (!this.stopped) {
                boolean hasNext = this.iterator.hasNext();
                if (!hasNext) {
                    this.owner.pop();
                }
                return hasNext;
            }
            return false;
        }

        public Object next() {
            return this.iterator.next();
        }

        public void remove() {
            this.iterator.remove();
        }

        public void stop() {
            this.stopped = true;
        }

        public void skip(int number) {
            for (int i = 0; i < number && this.iterator.hasNext(); ++i) {
                this.iterator.next();
            }
        }
    }
}

