/*
 * Decompiled with CFR 0.152.
 */
package com.insidious.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class CompressionTools {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String compressBase64String(byte[] data) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);){
            Deflater compressor = new Deflater();
            compressor.setLevel(9);
            compressor.setInput(data);
            compressor.finish();
            byte[] buf = new byte[1024];
            while (!compressor.finished()) {
                int count = compressor.deflate(buf);
                baos.write(buf, 0, count);
            }
            String string = Base64.getEncoder().encodeToString(baos.toByteArray());
            return string;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompressBase64String(String base64String) {
        byte[] data = Base64.getDecoder().decode(base64String);
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
            byte[] buffer = new byte[1024];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }
}

