/*
 * Decompiled with CFR 0.152.
 */
package com.insidious.common.weaver;

import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.insidious.common.weaver.LogLevel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.core.io.IORuntimeException;

public class ClassInfo
implements Serializable,
BytesMarshallable {
    public static final SimpleAttribute<ClassInfo, Integer> CLASS_ID = new SimpleAttribute<ClassInfo, Integer>("classId"){

        public Integer getValue(ClassInfo probeInfoDocument, QueryOptions queryOptions) {
            return probeInfoDocument.classId;
        }
    };
    private static final String SEPARATOR = ",";
    private String[] interfaces;
    private String superName;
    private String signature;
    private int classId;
    private String container;
    private String filename;
    private String className;
    private LogLevel loglevel;
    private String hash;
    private String classLoaderIdentifier;
    private boolean isEnum;
    private boolean isPojo;

    public ClassInfo() {
    }

    public ClassInfo(int classId, String container, String filename, String className, LogLevel loglevel, String hash, String classLoaderIdentifier, String[] interfaces, String superName, String signature) {
        this.classId = classId;
        this.container = container;
        this.filename = filename;
        this.className = className;
        this.loglevel = loglevel;
        this.hash = hash;
        this.classLoaderIdentifier = classLoaderIdentifier;
        this.interfaces = interfaces;
        this.superName = superName;
        this.signature = signature;
    }

    public boolean isPojo() {
        return this.isPojo;
    }

    public void setPojo(boolean pojo) {
        this.isPojo = pojo;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public void setEnum(boolean anEnum) {
        this.isEnum = anEnum;
    }

    public int getClassId() {
        return this.classId;
    }

    public String getContainer() {
        return this.container;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getClassName() {
        return this.className;
    }

    public LogLevel getLoglevel() {
        return this.loglevel;
    }

    public String getHash() {
        return this.hash;
    }

    public String getClassLoaderIdentifier() {
        return this.classLoaderIdentifier;
    }

    public void readMarshallable(BytesIn bytes) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        int fileNameLength;
        this.classId = bytes.readInt();
        int containerNameLength = bytes.readInt();
        if (containerNameLength > 0) {
            byte[] containerNameBytes = new byte[containerNameLength];
            bytes.read(containerNameBytes);
            this.container = new String(containerNameBytes);
        }
        if ((fileNameLength = bytes.readInt()) > 0) {
            byte[] fileNameBytes = new byte[fileNameLength];
            bytes.read(fileNameBytes);
            this.filename = new String(fileNameBytes);
        }
        int classNameLength = bytes.readInt();
        byte[] classNameBytes = new byte[classNameLength];
        bytes.read(classNameBytes);
        this.className = new String(classNameBytes);
        int logLevelValueLength = bytes.readInt();
        byte[] logLevelBytes = new byte[logLevelValueLength];
        bytes.read(logLevelBytes);
        this.loglevel = LogLevel.valueOf(new String(logLevelBytes));
        int hashValueLength = bytes.readInt();
        byte[] hashValueBytes = new byte[hashValueLength];
        bytes.read(hashValueBytes);
        this.hash = new String(hashValueBytes);
        int classLoaderIdentifierValueLength = bytes.readInt();
        byte[] classLoaderIdentifierBytes = new byte[classLoaderIdentifierValueLength];
        bytes.read(classLoaderIdentifierBytes);
        this.classLoaderIdentifier = new String(classLoaderIdentifierBytes);
        int interfaceCount = bytes.readInt();
        this.interfaces = new String[interfaceCount];
        for (int i = 0; i < interfaceCount; ++i) {
            int interfaceValueLength = bytes.readInt();
            byte[] interfaceValueBytes = new byte[interfaceValueLength];
            bytes.read(interfaceValueBytes);
            this.interfaces[i] = new String(interfaceValueBytes);
        }
        int signatureValueLength = bytes.readInt();
        byte[] signatureValueBytes = new byte[signatureValueLength];
        bytes.read(signatureValueBytes);
        this.signature = new String(signatureValueBytes);
        int superNameValueLength = bytes.readInt();
        byte[] superNameValueBytes = new byte[superNameValueLength];
        bytes.read(superNameValueBytes);
        this.superName = new String(superNameValueBytes);
        this.isPojo = bytes.readBoolean();
        this.isEnum = bytes.readBoolean();
    }

    public void readFromDataStream(ByteArrayInputStream byteArrayInputStream) throws BufferUnderflowException, IllegalStateException, IOException {
        int fileNameLength;
        DataInputStream bytes = new DataInputStream(byteArrayInputStream);
        this.classId = bytes.readInt();
        int containerNameLength = bytes.readInt();
        if (containerNameLength > 0) {
            byte[] containerNameBytes = new byte[containerNameLength];
            bytes.read(containerNameBytes);
            this.container = new String(containerNameBytes);
        }
        if ((fileNameLength = bytes.readInt()) > 0) {
            byte[] fileNameBytes = new byte[fileNameLength];
            bytes.read(fileNameBytes);
            this.filename = new String(fileNameBytes);
        }
        int classNameLength = bytes.readInt();
        byte[] classNameBytes = new byte[classNameLength];
        bytes.read(classNameBytes);
        this.className = new String(classNameBytes);
        int logLevelValueLength = bytes.readInt();
        byte[] logLevelBytes = new byte[logLevelValueLength];
        bytes.read(logLevelBytes);
        this.loglevel = LogLevel.valueOf(new String(logLevelBytes));
        int hashValueLength = bytes.readInt();
        byte[] hashValueBytes = new byte[hashValueLength];
        bytes.read(hashValueBytes);
        this.hash = new String(hashValueBytes);
        int classLoaderIdentifierValueLength = bytes.readInt();
        byte[] classLoaderIdentifierBytes = new byte[classLoaderIdentifierValueLength];
        bytes.read(classLoaderIdentifierBytes);
        this.classLoaderIdentifier = new String(classLoaderIdentifierBytes);
        int interfaceCount = bytes.readInt();
        this.interfaces = new String[interfaceCount];
        for (int i = 0; i < interfaceCount; ++i) {
            int interfaceValueLength = bytes.readInt();
            byte[] interfaceValueBytes = new byte[interfaceValueLength];
            bytes.read(interfaceValueBytes);
            this.interfaces[i] = new String(interfaceValueBytes);
        }
        int signatureValueLength = bytes.readInt();
        byte[] signatureValueBytes = new byte[signatureValueLength];
        bytes.read(signatureValueBytes);
        this.signature = new String(signatureValueBytes);
        int superNameValueLength = bytes.readInt();
        byte[] superNameValueBytes = new byte[superNameValueLength];
        bytes.read(superNameValueBytes);
        this.superName = new String(superNameValueBytes);
        this.isEnum = bytes.readBoolean();
        this.isPojo = bytes.readBoolean();
    }

    public void writeMarshallable(BytesOut bytes) throws IllegalStateException, BufferOverflowException, BufferUnderflowException, ArithmeticException {
        bytes.writeInt(this.classId);
        if (this.container != null) {
            bytes.writeInt(this.container.getBytes().length);
            bytes.write(this.container.getBytes());
        } else {
            bytes.writeInt(0);
        }
        if (this.filename != null) {
            bytes.writeInt(this.filename.getBytes().length);
            bytes.write(this.filename.getBytes());
        } else {
            bytes.writeInt(0);
        }
        bytes.writeInt(this.className.getBytes().length);
        bytes.write(this.className.getBytes());
        bytes.writeInt(this.loglevel.toString().getBytes().length);
        bytes.write(this.loglevel.toString().getBytes());
        bytes.writeInt(this.hash.getBytes().length);
        bytes.write(this.hash.getBytes());
        bytes.writeInt(this.classLoaderIdentifier.getBytes().length);
        bytes.write(this.classLoaderIdentifier.getBytes());
        bytes.writeInt(this.interfaces.length);
        for (String anInterface : this.interfaces) {
            bytes.writeInt(anInterface.length());
            bytes.write((CharSequence)anInterface);
        }
        if (this.signature != null) {
            bytes.writeInt(this.signature.length());
            bytes.write((CharSequence)this.signature);
        } else {
            bytes.writeInt(0);
        }
        if (this.superName != null) {
            bytes.writeInt(this.superName.length());
            bytes.write((CharSequence)this.superName);
        } else {
            bytes.writeInt(0);
        }
        bytes.writeBoolean(this.isEnum);
        bytes.writeBoolean(this.isPojo);
    }

    public byte[] toBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dao = new DataOutputStream(baos);
        try {
            this.writeToOutputStream(dao);
            return baos.toByteArray();
        }
        catch (IOException e) {
            baos = new ByteArrayOutputStream();
            dao = new DataOutputStream(baos);
            try {
                dao.writeInt(this.classId);
                if (this.container != null) {
                    dao.writeInt(this.container.getBytes().length);
                    dao.write(this.container.getBytes());
                } else {
                    dao.writeInt(0);
                }
                if (this.filename != null) {
                    dao.writeInt(this.filename.getBytes().length);
                    dao.write(this.filename.getBytes());
                } else {
                    dao.writeInt(0);
                }
                dao.writeInt(this.className.getBytes().length);
                dao.write(this.className.getBytes());
                dao.writeInt(this.loglevel.toString().getBytes().length);
                dao.write(this.loglevel.toString().getBytes());
                dao.writeInt(this.hash.getBytes().length);
                dao.write(this.hash.getBytes());
                dao.writeInt(this.classLoaderIdentifier.getBytes().length);
                dao.write(this.classLoaderIdentifier.getBytes());
                dao.writeInt(this.interfaces.length);
                for (String anInterface : this.interfaces) {
                    dao.writeInt(anInterface.length());
                    dao.writeBytes(anInterface);
                }
                if (this.signature != null) {
                    dao.writeInt(this.signature.length());
                    dao.writeBytes(this.signature);
                } else {
                    dao.writeInt(0);
                }
                if (this.superName != null) {
                    dao.writeInt(this.superName.length());
                    dao.writeBytes(this.superName);
                } else {
                    dao.writeInt(0);
                }
                dao.writeBoolean(this.isEnum);
                dao.writeBoolean(this.isPojo);
                return baos.toByteArray();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public void writeToOutputStream(OutputStream baos) throws IOException {
        DataOutputStream dao = new DataOutputStream(baos);
        dao.writeInt(this.classId);
        if (this.container != null) {
            dao.writeInt(this.container.getBytes().length);
            dao.write(this.container.getBytes());
        } else {
            dao.writeInt(0);
        }
        if (this.filename != null) {
            dao.writeInt(this.filename.getBytes().length);
            dao.write(this.filename.getBytes());
        } else {
            dao.writeInt(0);
        }
        dao.writeInt(this.className.getBytes().length);
        dao.write(this.className.getBytes());
        dao.writeInt(this.loglevel.toString().getBytes().length);
        dao.write(this.loglevel.toString().getBytes());
        dao.writeInt(this.hash.getBytes().length);
        dao.write(this.hash.getBytes());
        dao.writeInt(this.classLoaderIdentifier.getBytes().length);
        dao.write(this.classLoaderIdentifier.getBytes());
        dao.writeInt(this.interfaces.length);
        for (String anInterface : this.interfaces) {
            dao.writeInt(anInterface.length());
            dao.writeBytes(anInterface);
        }
        if (this.signature != null) {
            dao.writeInt(this.signature.length());
            dao.writeBytes(this.signature);
        } else {
            dao.writeInt(0);
        }
        if (this.superName != null) {
            dao.writeInt(this.superName.length());
            dao.writeBytes(this.superName);
        } else {
            dao.writeInt(0);
        }
        dao.writeBoolean(this.isEnum);
        dao.writeBoolean(this.isPojo);
        dao.flush();
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public String getSuperName() {
        return this.superName;
    }

    public String getSignature() {
        return this.signature;
    }
}

