/*
 * Decompiled with CFR 0.152.
 */
package com.insidious.common.weaver;

import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.insidious.common.weaver.Descriptor;
import com.insidious.common.weaver.EventType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Map;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.core.io.IORuntimeException;

public class DataInfo
implements Serializable,
BytesMarshallable {
    public static final SimpleAttribute<DataInfo, Integer> PROBE_ID = new SimpleAttribute<DataInfo, Integer>("dataId"){

        public Integer getValue(DataInfo probeInfoDocument, QueryOptions queryOptions) {
            return probeInfoDocument.dataId;
        }
    };
    private static final String SEPARATOR = ",";
    private static final char ATTRIBUTE_KEYVALUE_SEPARATOR = '=';
    private static final char ATTRIBUTE_SEPARATOR = ',';
    private int classId;
    private int methodId;
    private int dataId;
    private int index;
    private int line;
    private int instructionIndex;
    private EventType eventType;
    private Descriptor valueDesc;
    private String attributes;
    private Map<String, String> attributesMap;

    public DataInfo(int classId, int methodId, int dataId, int line, int instructionIndex, EventType eventType, Descriptor valueDesc, String attributes) {
        this.classId = classId;
        this.methodId = methodId;
        this.dataId = dataId;
        this.line = line;
        this.instructionIndex = instructionIndex;
        this.eventType = eventType;
        this.valueDesc = valueDesc;
        this.attributes = attributes;
    }

    public DataInfo() {
    }

    public void readMarshallable(BytesIn bytes) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        int descIndex;
        this.classId = bytes.readInt();
        this.methodId = bytes.readInt();
        this.dataId = bytes.readInt();
        this.index = bytes.readInt();
        this.line = bytes.readInt();
        this.instructionIndex = bytes.readInt();
        int eventTypeIndex = bytes.readInt();
        if (eventTypeIndex != -1) {
            this.eventType = EventType.values()[eventTypeIndex];
        }
        if ((descIndex = bytes.readInt()) != -1) {
            this.valueDesc = Descriptor.values()[descIndex];
        }
        int attrLength = bytes.readInt();
        byte[] attrBytes = new byte[attrLength];
        bytes.read(attrBytes);
        this.attributes = new String(attrBytes);
    }

    public void writeMarshallable(BytesOut bytes) throws IllegalStateException, BufferOverflowException, BufferUnderflowException, ArithmeticException {
        bytes.writeInt(this.classId);
        bytes.writeInt(this.methodId);
        bytes.writeInt(this.dataId);
        bytes.writeInt(this.index);
        bytes.writeInt(this.line);
        bytes.writeInt(this.instructionIndex);
        if (this.eventType != null) {
            bytes.writeInt(this.eventType.ordinal());
        } else {
            bytes.writeInt(-1);
        }
        if (this.valueDesc != null) {
            bytes.writeInt(this.valueDesc.ordinal());
        } else {
            bytes.writeInt(-1);
        }
        if (this.attributes != null) {
            bytes.writeInt(this.attributes.length());
            bytes.write((CharSequence)this.attributes);
        } else {
            bytes.writeInt(0);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Map<String, String> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttributesMap(Map<String, String> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public int getClassId() {
        return this.classId;
    }

    public void setClassId(int classId) {
        this.classId = classId;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public void setMethodId(int methodId) {
        this.methodId = methodId;
    }

    public int getDataId() {
        return this.dataId;
    }

    public void setDataId(int dataId) {
        this.dataId = dataId;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getInstructionIndex() {
        return this.instructionIndex;
    }

    public void setInstructionIndex(int instructionIndex) {
        this.instructionIndex = instructionIndex;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public Descriptor getValueDesc() {
        return this.valueDesc;
    }

    public void setValueDesc(Descriptor descriptor) {
        this.valueDesc = descriptor;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public String getAttribute(String key, String defaultValue) {
        int index = this.attributes.indexOf(key);
        while (index >= 0) {
            int keyEndIndex;
            if ((index == 0 || this.attributes.charAt(index - 1) == ',') && (keyEndIndex = this.attributes.indexOf(61, index)) == index + key.length()) {
                int valueEndIndex = this.attributes.indexOf(44, keyEndIndex);
                if (valueEndIndex > keyEndIndex) {
                    return this.attributes.substring(index + key.length() + 1, valueEndIndex);
                }
                return this.attributes.substring(index + key.length() + 1);
            }
            index = this.attributes.indexOf(key, index + 1);
        }
        return defaultValue;
    }

    public String toString() {
        return "DataInfo{dataId=" + this.dataId + ", classId=" + this.classId + ", methodId=" + this.methodId + ", line=" + this.line + ", eventType=" + (Object)((Object)this.eventType) + ", valueDesc=" + (Object)((Object)this.valueDesc) + '}';
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dao = new DataOutputStream(baos);
        dao.writeInt(this.classId);
        dao.writeInt(this.methodId);
        dao.writeInt(this.dataId);
        dao.writeInt(this.line);
        dao.writeInt(this.instructionIndex);
        dao.writeInt(this.eventType.ordinal());
        dao.writeInt(this.valueDesc.ordinal());
        dao.writeInt(this.attributes.getBytes().length);
        dao.write(this.attributes.getBytes());
        return baos.toByteArray();
    }

    public void writeToStream(OutputStream baos) throws IOException {
        DataOutputStream dao = new DataOutputStream(baos);
        dao.writeInt(this.classId);
        dao.writeInt(this.methodId);
        dao.writeInt(this.dataId);
        dao.writeInt(this.line);
        dao.writeInt(this.instructionIndex);
        dao.writeInt(this.eventType.ordinal());
        dao.writeInt(this.valueDesc.ordinal());
        dao.writeInt(this.attributes.getBytes().length);
        dao.write(this.attributes.getBytes());
        dao.flush();
    }
}

