/*
 * Decompiled with CFR 0.152.
 */
package com.insidious.common.weaver;

import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Scanner;

public class MethodInfo
implements Serializable {
    public static final SimpleAttribute<MethodInfo, Integer> METHOD_ID = new SimpleAttribute<MethodInfo, Integer>("methodId"){

        public Integer getValue(MethodInfo probeInfoDocument, QueryOptions queryOptions) {
            return probeInfoDocument.methodId;
        }
    };
    private static final String SEPARATOR = ",";
    private final int classId;
    private final int methodId;
    private final String className;
    private final String methodName;
    private final String methodDesc;
    private final int access;
    private final String sourceFileName;
    private final String methodHash;

    public MethodInfo(int classId, int methodId, String className, String methodName, String methodDesc, int access, String sourceFileName, String methodHash) {
        this.classId = classId;
        this.methodId = methodId;
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.access = access;
        this.sourceFileName = sourceFileName;
        this.methodHash = methodHash;
    }

    public static MethodInfo parse(String s) {
        Scanner sc = new Scanner(s);
        sc.useDelimiter(SEPARATOR);
        int classId = sc.nextInt();
        int methodId = sc.nextInt();
        String className = sc.next();
        String methodName = sc.next();
        String methodDesc = sc.next();
        int access = sc.nextInt();
        String sourceFileName = sc.hasNext() ? sc.next() : "";
        String methodHash = sc.hasNext() ? sc.next() : "";
        sc.close();
        return new MethodInfo(classId, methodId, className, methodName, methodDesc, access, sourceFileName, methodHash);
    }

    public int getClassId() {
        return this.classId;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public int getAccess() {
        return this.access;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getMethodHash() {
        return this.methodHash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.classId);
        buf.append(SEPARATOR);
        buf.append(this.methodId);
        buf.append(SEPARATOR);
        buf.append(this.className);
        buf.append(SEPARATOR);
        buf.append(this.methodName);
        buf.append(SEPARATOR);
        buf.append(this.methodDesc);
        buf.append(SEPARATOR);
        buf.append(this.access);
        buf.append(SEPARATOR);
        if (this.sourceFileName != null) {
            buf.append(this.sourceFileName);
        }
        buf.append(SEPARATOR);
        if (this.methodHash != null) {
            buf.append(this.methodHash);
        }
        return buf.toString();
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dao = new DataOutputStream(baos);
        dao.writeInt(this.classId);
        dao.writeInt(this.methodId);
        if (this.methodName != null) {
            dao.writeInt(this.methodName.getBytes().length);
            dao.write(this.methodName.getBytes());
        } else {
            dao.writeInt(0);
        }
        dao.writeInt(this.methodDesc.getBytes().length);
        dao.write(this.methodDesc.getBytes());
        dao.writeInt(this.access);
        if (this.sourceFileName != null) {
            dao.writeInt(this.sourceFileName.getBytes().length);
            dao.write(this.sourceFileName.getBytes());
        } else {
            dao.writeInt(0);
        }
        dao.writeInt(this.methodHash.getBytes().length);
        dao.write(this.methodHash.getBytes());
        return baos.toByteArray();
    }

    public void writeToOutputStream(OutputStream baos) throws IOException {
        DataOutputStream dao = new DataOutputStream(baos);
        dao.writeInt(this.classId);
        dao.writeInt(this.methodId);
        if (this.methodName != null) {
            dao.writeInt(this.methodName.getBytes().length);
            dao.write(this.methodName.getBytes());
        } else {
            dao.writeInt(0);
        }
        dao.writeInt(this.methodDesc.getBytes().length);
        dao.write(this.methodDesc.getBytes());
        dao.writeInt(this.access);
        if (this.sourceFileName != null) {
            dao.writeInt(this.sourceFileName.getBytes().length);
            dao.write(this.sourceFileName.getBytes());
        } else {
            dao.writeInt(0);
        }
        dao.writeInt(this.methodHash.getBytes().length);
        dao.write(this.methodHash.getBytes());
        dao.flush();
    }
}

