/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Array;

public class DefaultArraySerializers {

    public static class ObjectArraySerializer
    extends Serializer<Object[]> {
        private boolean elementsAreSameType;
        private boolean elementsCanBeNull = true;
        private final Class type;

        public ObjectArraySerializer(Kryo kryo, Class type2) {
            boolean isFinal;
            this.setAcceptsNull(true);
            this.type = type2;
            Class<?> componentType = type2.getComponentType();
            boolean bl = isFinal = 0 != (componentType.getModifiers() & 0x10);
            if (isFinal) {
                this.setElementsAreSameType(true);
            }
        }

        @Override
        public void write(Kryo kryo, Output output, Object[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            int n = object.length;
            output.writeVarInt(n + 1, true);
            Class<?> elementClass = object.getClass().getComponentType();
            if (this.elementsAreSameType || kryo.isFinal(elementClass)) {
                Serializer elementSerializer = kryo.getSerializer(elementClass);
                if (this.elementsCanBeNull) {
                    for (int i = 0; i < n; ++i) {
                        kryo.writeObjectOrNull(output, object[i], elementSerializer);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        kryo.writeObject(output, object[i], elementSerializer);
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    kryo.writeClassAndObject(output, object[i]);
                }
            }
        }

        @Override
        public Object[] read(Kryo kryo, Input input, Class type2) {
            int n = input.readVarInt(true);
            if (n == 0) {
                return null;
            }
            Object[] object = (Object[])Array.newInstance(type2.getComponentType(), --n);
            kryo.reference(object);
            Class<?> elementClass = type2.getComponentType();
            if (this.elementsAreSameType || kryo.isFinal(elementClass)) {
                Serializer elementSerializer = kryo.getSerializer(elementClass);
                if (this.elementsCanBeNull) {
                    for (int i = 0; i < n; ++i) {
                        object[i] = kryo.readObjectOrNull(input, elementClass, elementSerializer);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        object[i] = kryo.readObject(input, elementClass, elementSerializer);
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    object[i] = kryo.readClassAndObject(input);
                }
            }
            return object;
        }

        @Override
        public Object[] copy(Kryo kryo, Object[] original) {
            int n = original.length;
            Object[] copy2 = (Object[])Array.newInstance(original.getClass().getComponentType(), n);
            for (int i = 0; i < n; ++i) {
                copy2[i] = kryo.copy(original[i]);
            }
            return copy2;
        }

        public void setElementsCanBeNull(boolean elementsCanBeNull) {
            this.elementsCanBeNull = elementsCanBeNull;
        }

        public void setElementsAreSameType(boolean elementsAreSameType) {
            this.elementsAreSameType = elementsAreSameType;
        }
    }

    public static class StringArraySerializer
    extends Serializer<String[]> {
        public StringArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            if (kryo.getReferences() && kryo.getReferenceResolver().useReferences(String.class)) {
                Serializer serializer = kryo.getSerializer(String.class);
                int n = object.length;
                for (int i = 0; i < n; ++i) {
                    kryo.writeObjectOrNull(output, (Object)object[i], serializer);
                }
            } else {
                int n = object.length;
                for (int i = 0; i < n; ++i) {
                    output.writeString(object[i]);
                }
            }
        }

        @Override
        public String[] read(Kryo kryo, Input input, Class type2) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            String[] array = new String[--length];
            if (kryo.getReferences() && kryo.getReferenceResolver().useReferences(String.class)) {
                Serializer serializer = kryo.getSerializer(String.class);
                for (int i = 0; i < length; ++i) {
                    array[i] = kryo.readObjectOrNull(input, String.class, serializer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    array[i] = input.readString();
                }
            }
            return array;
        }

        @Override
        public String[] copy(Kryo kryo, String[] original) {
            String[] copy2 = new String[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    public static class BooleanArraySerializer
    extends Serializer<boolean[]> {
        public BooleanArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, boolean[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                output.writeBoolean(object[i]);
            }
        }

        @Override
        public boolean[] read(Kryo kryo, Input input, Class type2) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            boolean[] array = new boolean[--length];
            for (int i = 0; i < length; ++i) {
                array[i] = input.readBoolean();
            }
            return array;
        }

        @Override
        public boolean[] copy(Kryo kryo, boolean[] original) {
            boolean[] copy2 = new boolean[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    public static class DoubleArraySerializer
    extends Serializer<double[]> {
        public DoubleArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, double[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeDoubles(object, 0, object.length);
        }

        @Override
        public double[] read(Kryo kryo, Input input, Class type2) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readDoubles(length - 1);
        }

        @Override
        public double[] copy(Kryo kryo, double[] original) {
            double[] copy2 = new double[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    public static class CharArraySerializer
    extends Serializer<char[]> {
        public CharArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, char[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeChars(object, 0, object.length);
        }

        @Override
        public char[] read(Kryo kryo, Input input, Class type2) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readChars(length - 1);
        }

        @Override
        public char[] copy(Kryo kryo, char[] original) {
            char[] copy2 = new char[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    public static class ShortArraySerializer
    extends Serializer<short[]> {
        public ShortArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, short[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeShorts(object, 0, object.length);
        }

        @Override
        public short[] read(Kryo kryo, Input input, Class type2) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readShorts(length - 1);
        }

        @Override
        public short[] copy(Kryo kryo, short[] original) {
            short[] copy2 = new short[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    public static class LongArraySerializer
    extends Serializer<long[]> {
        public LongArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, long[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeLongs(object, 0, object.length, false);
        }

        @Override
        public long[] read(Kryo kryo, Input input, Class type2) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readLongs(length - 1, false);
        }

        @Override
        public long[] copy(Kryo kryo, long[] original) {
            long[] copy2 = new long[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    public static class FloatArraySerializer
    extends Serializer<float[]> {
        public FloatArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, float[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeFloats(object, 0, object.length);
        }

        @Override
        public float[] read(Kryo kryo, Input input, Class type2) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readFloats(length - 1);
        }

        @Override
        public float[] copy(Kryo kryo, float[] original) {
            float[] copy2 = new float[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    public static class IntArraySerializer
    extends Serializer<int[]> {
        public IntArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, int[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeInts(object, 0, object.length, false);
        }

        @Override
        public int[] read(Kryo kryo, Input input, Class type2) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readInts(length - 1, false);
        }

        @Override
        public int[] copy(Kryo kryo, int[] original) {
            int[] copy2 = new int[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    public static class ByteArraySerializer
    extends Serializer<byte[]> {
        public ByteArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, byte[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeBytes(object);
        }

        @Override
        public byte[] read(Kryo kryo, Input input, Class type2) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readBytes(length - 1);
        }

        @Override
        public byte[] copy(Kryo kryo, byte[] original) {
            byte[] copy2 = new byte[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }
}

