/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.SerializerFactory;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.Generics;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;

public class MapSerializer<T extends Map>
extends Serializer<T> {
    private Class keyClass;
    private Class valueClass;
    private Serializer keySerializer;
    private Serializer valueSerializer;
    private boolean keysCanBeNull = true;
    private boolean valuesCanBeNull = true;

    public MapSerializer() {
        this.setAcceptsNull(true);
    }

    public void setKeysCanBeNull(boolean keysCanBeNull) {
        this.keysCanBeNull = keysCanBeNull;
    }

    public void setKeyClass(Class keyClass) {
        this.keyClass = keyClass;
    }

    public Class getKeyClass() {
        return this.keyClass;
    }

    public void setKeyClass(Class keyClass, Serializer keySerializer) {
        this.keyClass = keyClass;
        this.keySerializer = keySerializer;
    }

    public void setKeySerializer(Serializer keySerializer) {
        this.keySerializer = keySerializer;
    }

    public Serializer getKeySerializer() {
        return this.keySerializer;
    }

    public void setValueClass(Class valueClass) {
        this.valueClass = valueClass;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class valueClass, Serializer valueSerializer) {
        this.valueClass = valueClass;
        this.valueSerializer = valueSerializer;
    }

    public void setValueSerializer(Serializer valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public Serializer getValueSerializer() {
        return this.valueSerializer;
    }

    public void setValuesCanBeNull(boolean valuesCanBeNull) {
        this.valuesCanBeNull = valuesCanBeNull;
    }

    @Override
    public void write(Kryo kryo, Output output, T map) {
        if (map == null) {
            output.writeByte(0);
            return;
        }
        int size = map.size();
        if (size == 0) {
            output.writeByte(1);
            this.writeHeader(kryo, output, map);
            return;
        }
        output.writeVarInt(size + 1, true);
        this.writeHeader(kryo, output, map);
        Serializer keySerializer = this.keySerializer;
        Serializer valueSerializer = this.valueSerializer;
        Generics.GenericType[] genericTypes = kryo.getGenerics().nextGenericTypes();
        if (genericTypes != null) {
            Class valueType;
            Class keyType;
            if (keySerializer == null && (keyType = genericTypes[0].resolve(kryo.getGenerics())) != null && kryo.isFinal(keyType)) {
                keySerializer = kryo.getSerializer(keyType);
            }
            if (valueSerializer == null && (valueType = genericTypes[1].resolve(kryo.getGenerics())) != null && kryo.isFinal(valueType)) {
                valueSerializer = kryo.getSerializer(valueType);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            if (genericTypes != null) {
                kryo.getGenerics().pushGenericType(genericTypes[0]);
            }
            if (keySerializer != null) {
                if (this.keysCanBeNull) {
                    kryo.writeObjectOrNull(output, entry.getKey(), keySerializer);
                } else {
                    kryo.writeObject(output, entry.getKey(), keySerializer);
                }
            } else {
                kryo.writeClassAndObject(output, entry.getKey());
            }
            if (genericTypes != null) {
                kryo.getGenerics().popGenericType();
            }
            if (valueSerializer != null) {
                if (this.valuesCanBeNull) {
                    kryo.writeObjectOrNull(output, entry.getValue(), valueSerializer);
                    continue;
                }
                kryo.writeObject(output, entry.getValue(), valueSerializer);
                continue;
            }
            kryo.writeClassAndObject(output, entry.getValue());
        }
        kryo.getGenerics().popGenericType();
    }

    protected void writeHeader(Kryo kryo, Output output, T map) {
    }

    protected T create(Kryo kryo, Input input, Class<? extends T> type2, int size) {
        if (type2 == HashMap.class) {
            return (T)new HashMap(size);
        }
        return (T)((Map)kryo.newInstance(type2));
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> type2) {
        int length = input.readVarInt(true);
        if (length == 0) {
            return null;
        }
        T map = this.create(kryo, input, type2, --length);
        kryo.reference(map);
        if (length == 0) {
            return map;
        }
        Class keyClass = this.keyClass;
        Class valueClass = this.valueClass;
        Serializer keySerializer = this.keySerializer;
        Serializer valueSerializer = this.valueSerializer;
        Generics.GenericType[] genericTypes = kryo.getGenerics().nextGenericTypes();
        if (genericTypes != null) {
            Class genericClass;
            if (keySerializer == null && (genericClass = genericTypes[0].resolve(kryo.getGenerics())) != null && kryo.isFinal(genericClass)) {
                keySerializer = kryo.getSerializer(genericClass);
                keyClass = genericClass;
            }
            if (valueSerializer == null && (genericClass = genericTypes[1].resolve(kryo.getGenerics())) != null && kryo.isFinal(genericClass)) {
                valueSerializer = kryo.getSerializer(genericClass);
                valueClass = genericClass;
            }
        }
        for (int i = 0; i < length; ++i) {
            if (genericTypes != null) {
                kryo.getGenerics().pushGenericType(genericTypes[0]);
            }
            Object key = keySerializer != null ? (this.keysCanBeNull ? kryo.readObjectOrNull(input, keyClass, keySerializer) : kryo.readObject(input, keyClass, keySerializer)) : kryo.readClassAndObject(input);
            if (genericTypes != null) {
                kryo.getGenerics().popGenericType();
            }
            Object value = valueSerializer != null ? (this.valuesCanBeNull ? kryo.readObjectOrNull(input, valueClass, valueSerializer) : kryo.readObject(input, valueClass, valueSerializer)) : kryo.readClassAndObject(input);
            map.put((Object)key, (Object)value);
        }
        kryo.getGenerics().popGenericType();
        return map;
    }

    protected T createCopy(Kryo kryo, T original) {
        return (T)((Map)kryo.newInstance(original.getClass()));
    }

    @Override
    public T copy(Kryo kryo, T original) {
        T copy2 = this.createCopy(kryo, original);
        for (Map.Entry entry : original.entrySet()) {
            copy2.put(kryo.copy(entry.getKey()), kryo.copy(entry.getValue()));
        }
        return copy2;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BindMap {
        public Class keyClass() default Object.class;

        public Class<? extends Serializer> keySerializer() default Serializer.class;

        public Class<? extends SerializerFactory> keySerializerFactory() default SerializerFactory.class;

        public Class valueClass() default Object.class;

        public Class<? extends Serializer> valueSerializer() default Serializer.class;

        public Class<? extends SerializerFactory> valueSerializerFactory() default SerializerFactory.class;

        public boolean keysCanBeNull() default true;

        public boolean valuesCanBeNull() default true;
    }
}

