/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.reflectasm.ConstructorAccess;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.strategy.InstantiatorStrategy;

public class DefaultInstantiatorStrategy
implements InstantiatorStrategy {
    private InstantiatorStrategy fallbackStrategy;

    public DefaultInstantiatorStrategy() {
    }

    public DefaultInstantiatorStrategy(InstantiatorStrategy fallbackStrategy) {
        this.fallbackStrategy = fallbackStrategy;
    }

    public void setFallbackInstantiatorStrategy(InstantiatorStrategy fallbackStrategy) {
        this.fallbackStrategy = fallbackStrategy;
    }

    public InstantiatorStrategy getFallbackInstantiatorStrategy() {
        return this.fallbackStrategy;
    }

    public ObjectInstantiator newInstantiatorOf(final Class type2) {
        if (!Util.isAndroid) {
            boolean isNonStaticMemberClass;
            Class<?> enclosingType = type2.getEnclosingClass();
            boolean bl = isNonStaticMemberClass = enclosingType != null && type2.isMemberClass() && !Modifier.isStatic(type2.getModifiers());
            if (!isNonStaticMemberClass) {
                try {
                    final ConstructorAccess access = ConstructorAccess.get(type2);
                    return new ObjectInstantiator(){

                        public Object newInstance() {
                            try {
                                return access.newInstance();
                            }
                            catch (Exception ex) {
                                throw new KryoException("Error constructing instance of class: " + Util.className(type2), ex);
                            }
                        }
                    };
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            Constructor ctor;
            try {
                ctor = type2.getConstructor(null);
            }
            catch (Exception ex) {
                ctor = type2.getDeclaredConstructor(null);
                ctor.setAccessible(true);
            }
            final Constructor constructor = ctor;
            return new ObjectInstantiator(){

                public Object newInstance() {
                    try {
                        return constructor.newInstance(new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new KryoException("Error constructing instance of class: " + Util.className(type2), ex);
                    }
                }
            };
        }
        catch (Exception ctor) {
            if (this.fallbackStrategy == null) {
                if (type2.isMemberClass() && !Modifier.isStatic(type2.getModifiers())) {
                    throw new KryoException("Class cannot be created (non-static member class): " + Util.className(type2));
                }
                StringBuilder message = new StringBuilder("Class cannot be created (missing no-arg constructor): " + Util.className(type2));
                if (type2.getSimpleName().equals("")) {
                    message.append("\nNote: This is an anonymous class, which is not serializable by default in Kryo. Possible solutions:\n").append("1. Remove uses of anonymous classes, including double brace initialization, from the containing\n").append("class. This is the safest solution, as anonymous classes don't have predictable names for serialization.\n").append("2. Register a FieldSerializer for the containing class and call FieldSerializer\n").append("setIgnoreSyntheticFields(false) on it. This is not safe but may be sufficient temporarily.");
                }
                throw new KryoException(message.toString());
            }
            return this.fallbackStrategy.newInstantiatorOf(type2);
        }
    }
}

