/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.KryoException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class GenericsUtil {
    public static Type resolveType(Class fromClass, Class toClass, Type type2) {
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof TypeVariable) {
            return GenericsUtil.resolveTypeVariable(fromClass, toClass, type2, true);
        }
        if (type2 instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type2).getRawType();
        }
        if (type2 instanceof GenericArrayType) {
            int dimensions = 1;
            while ((type2 = ((GenericArrayType)type2).getGenericComponentType()) instanceof GenericArrayType) {
                ++dimensions;
            }
            Type componentType = GenericsUtil.resolveType(fromClass, toClass, type2);
            if (!(componentType instanceof Class)) {
                return type2;
            }
            if (dimensions == 1) {
                return Array.newInstance((Class)componentType, 0).getClass();
            }
            return Array.newInstance((Class)componentType, new int[dimensions]).getClass();
        }
        if (type2 instanceof WildcardType) {
            Type upperBound = ((WildcardType)type2).getUpperBounds()[0];
            if (upperBound != Object.class) {
                return GenericsUtil.resolveType(fromClass, toClass, upperBound);
            }
            Type[] lowerBounds = ((WildcardType)type2).getLowerBounds();
            if (lowerBounds.length != 0) {
                return GenericsUtil.resolveType(fromClass, toClass, lowerBounds[0]);
            }
            return Object.class;
        }
        throw new KryoException("Unable to resolve type: " + type2);
    }

    private static Type resolveTypeVariable(Class fromClass, Class current, Type type2, boolean first) {
        Class superClass = current.getSuperclass();
        TypeVariable<Class<T>>[] params = superClass.getTypeParameters();
        if (params.length == 0) {
            return type2;
        }
        if (superClass != fromClass) {
            if (superClass == null) {
                return type2;
            }
            Type resolved = GenericsUtil.resolveTypeVariable(fromClass, superClass, type2, false);
            if (resolved instanceof Class) {
                return (Class)resolved;
            }
            type2 = resolved;
        }
        String name = type2.toString();
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            Type genericSuper;
            TypeVariable param = params[i];
            if (!param.getName().equals(name) || !((genericSuper = current.getGenericSuperclass()) instanceof ParameterizedType)) continue;
            Type arg = ((ParameterizedType)genericSuper).getActualTypeArguments()[i];
            if (arg instanceof Class) {
                return (Class)arg;
            }
            if (arg instanceof ParameterizedType) {
                return GenericsUtil.resolveType(fromClass, current, arg);
            }
            if (!(arg instanceof TypeVariable)) break;
            if (first) {
                return type2;
            }
            return arg;
        }
        throw new KryoException("Unable to resolve type variable: " + type2);
    }

    public static Type[] resolveTypeParameters(Class fromClass, Class toClass, Type type2) {
        if (type2 instanceof ParameterizedType) {
            Type[] actualArgs = ((ParameterizedType)type2).getActualTypeArguments();
            int n = actualArgs.length;
            Type[] generics = new Type[n];
            for (int i = 0; i < n; ++i) {
                generics[i] = GenericsUtil.resolveType(fromClass, toClass, actualArgs[i]);
            }
            return generics;
        }
        if (type2 instanceof GenericArrayType) {
            while ((type2 = ((GenericArrayType)type2).getGenericComponentType()) instanceof GenericArrayType) {
            }
            return GenericsUtil.resolveTypeParameters(fromClass, toClass, type2);
        }
        return null;
    }
}

