/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.SerializerFactory;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.Generics;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Type;

public class Util {
    public static final boolean isAndroid;
    public static final boolean unsafe;
    public static final int maxArraySize = 0x7FFFFFF7;

    public static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception ex) {
            Log.debug("kryo", "Class not available: " + className);
            return false;
        }
    }

    public static Class getWrapperClass(Class type2) {
        if (type2 == Integer.TYPE) {
            return Integer.class;
        }
        if (type2 == Float.TYPE) {
            return Float.class;
        }
        if (type2 == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type2 == Byte.TYPE) {
            return Byte.class;
        }
        if (type2 == Long.TYPE) {
            return Long.class;
        }
        if (type2 == Character.TYPE) {
            return Character.class;
        }
        if (type2 == Double.TYPE) {
            return Double.class;
        }
        if (type2 == Short.TYPE) {
            return Short.class;
        }
        return Void.class;
    }

    public static Class getPrimitiveClass(Class type2) {
        if (type2 == Integer.class) {
            return Integer.TYPE;
        }
        if (type2 == Float.class) {
            return Float.TYPE;
        }
        if (type2 == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type2 == Byte.class) {
            return Byte.TYPE;
        }
        if (type2 == Long.class) {
            return Long.TYPE;
        }
        if (type2 == Character.class) {
            return Character.TYPE;
        }
        if (type2 == Double.class) {
            return Double.TYPE;
        }
        if (type2 == Short.class) {
            return Short.TYPE;
        }
        if (type2 == Void.class) {
            return Void.TYPE;
        }
        return type2;
    }

    public static boolean isWrapperClass(Class type2) {
        return type2 == Integer.class || type2 == Float.class || type2 == Boolean.class || type2 == Byte.class || type2 == Long.class || type2 == Character.class || type2 == Double.class || type2 == Short.class;
    }

    public static boolean isEnum(Class type2) {
        return Enum.class.isAssignableFrom(type2) && type2 != Enum.class;
    }

    public static void log(String message, Object object, int position) {
        if (object == null) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": null" + Util.pos(position));
            }
            return;
        }
        Class<?> type2 = object.getClass();
        if (type2.isPrimitive() || Util.isWrapperClass(type2) || type2 == String.class) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": " + Util.string(object) + Util.pos(position));
            }
        } else {
            Log.debug("kryo", message + ": " + Util.string(object) + Util.pos(position));
        }
    }

    public static String pos(int position) {
        return position == -1 ? "" : " [" + position + "]";
    }

    public static String string(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> type2 = object.getClass();
        if (type2.isArray()) {
            return Util.className(type2);
        }
        String className = Log.TRACE ? Util.className(type2) : type2.getSimpleName();
        try {
            if (type2.getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                return className;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String value = String.valueOf(object) + " (" + className + ")";
            return value.length() > 97 ? value.substring(0, 97) + "..." : value;
        }
        catch (Throwable ex) {
            return className + " (toString exception: " + ex + ")";
        }
    }

    public static String className(Class type2) {
        if (type2 == null) {
            return "null";
        }
        if (type2.isArray()) {
            Class elementClass = Util.getElementClass(type2);
            StringBuilder buffer = new StringBuilder(16);
            int n = Util.getDimensionCount(type2);
            for (int i = 0; i < n; ++i) {
                buffer.append("[]");
            }
            return Util.className(elementClass) + buffer;
        }
        if (type2.isPrimitive() || type2 == Object.class || type2 == Boolean.class || type2 == Byte.class || type2 == Character.class || type2 == Short.class || type2 == Integer.class || type2 == Long.class || type2 == Float.class || type2 == Double.class || type2 == String.class) {
            return type2.getSimpleName();
        }
        return type2.getName();
    }

    public static String classNames(Class[] types) {
        StringBuilder buffer = new StringBuilder(32);
        int n = types.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(Util.className(types[i]));
        }
        return buffer.toString();
    }

    public static String simpleName(Type type2) {
        if (type2 instanceof Class) {
            return ((Class)type2).getSimpleName();
        }
        return type2.toString();
    }

    public static String simpleName(Class type2, Generics.GenericType genericType) {
        int i;
        int n;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append((type2.isArray() ? Util.getElementClass(type2) : type2).getSimpleName());
        if (genericType.arguments != null) {
            buffer.append('<');
            n = genericType.arguments.length;
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(genericType.arguments[i].toString());
            }
            buffer.append('>');
        }
        if (type2.isArray()) {
            n = Util.getDimensionCount(type2);
            for (i = 0; i < n; ++i) {
                buffer.append("[]");
            }
        }
        return buffer.toString();
    }

    public static int getDimensionCount(Class arrayClass) {
        int depth = 0;
        for (Class<?> nextClass = arrayClass.getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        return depth;
    }

    public static Class getElementClass(Class arrayClass) {
        Class<?> elementClass = arrayClass;
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        return elementClass;
    }

    public static boolean isAscii(String value) {
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            if (value.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static <T extends SerializerFactory> T newFactory(Class<T> factoryClass, Class<? extends Serializer> serializerClass) {
        try {
            if (serializerClass != null) {
                try {
                    return (T)((SerializerFactory)factoryClass.getConstructor(Class.class).newInstance(serializerClass));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return (T)((SerializerFactory)factoryClass.newInstance());
        }
        catch (Exception ex) {
            if (serializerClass == null) {
                throw new IllegalArgumentException("Unable to create serializer factory: " + factoryClass.getName(), ex);
            }
            throw new IllegalArgumentException("Unable to create serializer factory \"" + factoryClass.getName() + "\" for serializer class: " + Util.className(serializerClass), ex);
        }
    }

    static {
        boolean found;
        block2: {
            isAndroid = "Dalvik".equals(System.getProperty("java.vm.name"));
            found = false;
            try {
                found = Class.forName("com.esotericsoftware.kryo.unsafe.UnsafeUtil", true, FieldSerializer.class.getClassLoader()).getField("unsafe").get(null) != null;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (!Log.TRACE) break block2;
                Log.trace("kryo", "Unsafe is unavailable.");
            }
        }
        unsafe = found;
    }
}

