/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hibernate5;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.datatype.hibernate5.PackageVersion;
import javax.persistence.Transient;

public class HibernateAnnotationIntrospector
extends AnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    protected boolean _cfgCheckTransient = true;

    public HibernateAnnotationIntrospector setUseTransient(boolean state) {
        this._cfgCheckTransient = state;
        return this;
    }

    public boolean doesUseTransient() {
        return this._cfgCheckTransient;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember m) {
        return this._cfgCheckTransient && m.hasAnnotation(Transient.class);
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass ac) {
        Class<?> handlerClass = FieldHandlerChecker.instance.getHandlerClass();
        if (handlerClass != null && handlerClass.isAssignableFrom((Class<?>)ac.getAnnotated())) {
            return Boolean.TRUE;
        }
        return null;
    }

    static final class FieldHandlerChecker {
        private static final String FIELD_HANDLER_INTERFACE = "org.hibernate.bytecode.internal.javassist.FieldHandler";
        private final Class<?> _handlerClass;
        public static final FieldHandlerChecker instance = new FieldHandlerChecker();

        public FieldHandlerChecker() {
            Class<?> cls = null;
            try {
                cls = Class.forName(FIELD_HANDLER_INTERFACE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._handlerClass = cls;
        }

        public Class<?> getHandlerClass() {
            return this._handlerClass;
        }
    }
}

