/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.databind.JavaType;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;

public class BeanUtil {
    protected static boolean isConcrete(Member member) {
        int mod = member.getModifiers();
        return (mod & 0x600) == 0;
    }

    public static List<JavaType> findSuperTypes(JavaType type2, Class<?> endBefore) {
        return BeanUtil.findSuperTypes(type2, endBefore, new ArrayList<JavaType>());
    }

    public static List<JavaType> findSuperTypes(JavaType type2, Class<?> endBefore, List<JavaType> result2) {
        BeanUtil._addSuperTypes(type2, endBefore, result2, false);
        return result2;
    }

    private static void _addSuperTypes(JavaType type2, Class<?> endBefore, List<JavaType> result2, boolean addClassItself) {
        if (type2 == null || type2.isJavaLangObject() || type2.hasRawClass(endBefore)) {
            return;
        }
        if (addClassItself) {
            if (result2.contains(type2)) {
                return;
            }
            result2.add(type2);
        }
        for (JavaType intCls : type2.getInterfaces()) {
            BeanUtil._addSuperTypes(intCls, endBefore, result2, true);
        }
        BeanUtil._addSuperTypes(type2.getSuperClass(), endBefore, result2, true);
    }
}

