/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.module.mrbean.BeanBuilder;
import com.fasterxml.jackson.module.mrbean.asm.ClassWriter;
import com.fasterxml.jackson.module.mrbean.asm.signature.SignatureVisitor;
import com.fasterxml.jackson.module.mrbean.asm.signature.SignatureWriter;

public class TypeBuilder {
    protected final JavaType _implementedType;

    public TypeBuilder(JavaType type2) {
        this._implementedType = type2;
    }

    public byte[] buildAbstractBase(String className) {
        String superName;
        ClassWriter cw = new ClassWriter(1);
        String internalClass = TypeBuilder.getInternalClassName(className);
        String implName = TypeBuilder.getInternalClassName(this._implementedType.getRawClass().getName());
        if (this._implementedType.isInterface()) {
            superName = TypeBuilder.getInternalClassName(Object.class.getName());
            SignatureWriter sw = new SignatureWriter();
            SignatureVisitor sv = sw.visitSuperclass();
            sv.visitClassType(superName);
            sv.visitEnd();
            TypeBuilder.generateSignature(this._implementedType, sw.visitInterface());
            sw.visitEnd();
            cw.visit(49, 1057, internalClass, sw.toString(), superName, new String[]{implName});
        } else {
            superName = implName;
            SignatureWriter sw = new SignatureWriter();
            TypeBuilder.generateSignature(this._implementedType, sw.visitSuperclass());
            sw.visitEnd();
            cw.visit(49, 1057, internalClass, sw.toString(), superName, null);
        }
        cw.visitSource(className + ".java", null);
        BeanBuilder.generateDefaultConstructor(cw, superName);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static String getInternalClassName(String className) {
        return className.replace(".", "/");
    }

    private static void generateSignature(JavaType clazz, SignatureVisitor sw) {
        sw.visitClassType(TypeBuilder.getInternalClassName(clazz.getRawClass().getName()));
        if (clazz.containedTypeCount() == 0) {
            return;
        }
        sw.visitTypeArgument('=');
        for (int i = 0; i < clazz.containedTypeCount(); ++i) {
            JavaType type2 = clazz.containedType(i);
            TypeBuilder.generateSignature(type2, sw);
        }
        sw.visitEnd();
    }
}

