/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.solver;

import com.googlecode.concurrenttrees.common.CharSequences;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LCSubstringSolver {
    final ConcurrentSuffixTreeImpl<Set<String>> suffixTree;
    final Set<String> originalDocuments;

    public LCSubstringSolver(NodeFactory nodeFactory) {
        this.suffixTree = new ConcurrentSuffixTreeImpl(nodeFactory);
        this.originalDocuments = this.createSetForOriginalKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(CharSequence document) {
        if (document == null) {
            throw new IllegalArgumentException("The document argument was null");
        }
        if (document.length() == 0) {
            throw new IllegalArgumentException("The document argument was zero-length");
        }
        this.suffixTree.acquireWriteLock();
        try {
            String documentString = CharSequences.toString(document);
            boolean addedNew = this.originalDocuments.add(documentString);
            if (!addedNew) {
                boolean bl = false;
                return bl;
            }
            this.addSuffixesToRadixTree(documentString);
            boolean bl = true;
            return bl;
        }
        finally {
            this.suffixTree.releaseWriteLock();
        }
    }

    void addSuffixesToRadixTree(String keyAsString) {
        Iterable<CharSequence> suffixes = CharSequences.generateSuffixes(keyAsString);
        for (CharSequence suffix : suffixes) {
            Set<String> originalKeyRefs = (Set<String>)this.suffixTree.getValueForExactKey(suffix);
            if (originalKeyRefs == null) {
                originalKeyRefs = this.createSetForOriginalKeys();
                this.suffixTree.put(suffix, originalKeyRefs);
            }
            originalKeyRefs.add(keyAsString);
        }
    }

    public CharSequence getLongestCommonSubstring() {
        return this.suffixTree.getLongestCommonSubstring();
    }

    protected Set<String> createSetForOriginalKeys() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    class ConcurrentSuffixTreeImpl<V>
    extends ConcurrentRadixTree<V> {
        public ConcurrentSuffixTreeImpl(NodeFactory nodeFactory) {
            super(nodeFactory);
        }

        @Override
        protected void acquireWriteLock() {
            super.acquireWriteLock();
        }

        @Override
        protected void releaseWriteLock() {
            super.releaseWriteLock();
        }

        @Override
        protected Iterable<ConcurrentRadixTree.NodeKeyPair> lazyTraverseDescendants(CharSequence startKey, Node startNode) {
            return super.lazyTraverseDescendants(startKey, startNode);
        }

        CharSequence getLongestCommonSubstring() {
            Node root = LCSubstringSolver.this.suffixTree.getNode();
            CharSequence[] longestCommonSubstringSoFar = new CharSequence[]{""};
            int[] longestCommonSubstringSoFarLength = new int[]{0};
            for (ConcurrentRadixTree.NodeKeyPair nodeKeyPair : this.lazyTraverseDescendants("", root)) {
                if (nodeKeyPair.key.length() <= longestCommonSubstringSoFarLength[0] || !this.subTreeReferencesAllOriginalDocuments(nodeKeyPair.key, nodeKeyPair.node)) continue;
                longestCommonSubstringSoFarLength[0] = nodeKeyPair.key.length();
                longestCommonSubstringSoFar[0] = nodeKeyPair.key;
            }
            return longestCommonSubstringSoFar[0];
        }

        boolean subTreeReferencesAllOriginalDocuments(CharSequence startKey, Node startNode) {
            HashSet documentsEncounteredSoFar = new HashSet(LCSubstringSolver.this.originalDocuments.size());
            boolean[] result2 = new boolean[]{false};
            for (ConcurrentRadixTree.NodeKeyPair nodeKeyPair : this.lazyTraverseDescendants(startKey, startNode)) {
                Set documentsReferencedByThisNode = (Set)nodeKeyPair.node.getValue();
                if (documentsReferencedByThisNode == null) continue;
                documentsEncounteredSoFar.addAll(documentsReferencedByThisNode);
                if (!documentsEncounteredSoFar.equals(LCSubstringSolver.this.originalDocuments)) continue;
                result2[0] = true;
                break;
            }
            return result2[0];
        }
    }
}

