/*
 * Decompiled with CFR 0.152.
 */
package com.insidious.common;

import com.insidious.common.AbstractEvent;
import com.insidious.common.BloomFilterUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import orestes.bloomfilter.BloomFilter;
import orestes.bloomfilter.json.BloomFilterConverter;
import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.attribute.MultiValueAttribute;
import selogger.com.googlecode.cqengine.attribute.SimpleAttribute;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;

public class UploadFile
extends AbstractEvent<UploadFile> {
    public static final Attribute<UploadFile, String> SESSION_ID = new SimpleAttribute<UploadFile, String>("sessionId"){

        @Override
        public String getValue(UploadFile object, QueryOptions queryOptions) {
            return object.sessionId;
        }
    };
    public static final SimpleAttribute<UploadFile, String> UPLOAD_ID = new SimpleAttribute<UploadFile, String>("uploadId"){

        @Override
        public String getValue(UploadFile UploadFile2, QueryOptions queryOptions) {
            return UploadFile2.id;
        }
    };
    public static final Attribute<UploadFile, Long> THREAD_ID = new SimpleAttribute<UploadFile, Long>("threadId"){

        @Override
        public Long getValue(UploadFile object, QueryOptions queryOptions) {
            return object.threadId;
        }
    };
    public static final Attribute<UploadFile, Integer> PROBE_ID = new MultiValueAttribute<UploadFile, Integer>("probeIds"){

        @Override
        public Iterable<Integer> getValues(UploadFile file, QueryOptions queryOptions) {
            return Arrays.asList(file.probeIds);
        }
    };
    public static final Attribute<UploadFile, Long> NANOTIME_EVENT = new MultiValueAttribute<UploadFile, Long>("nanotime"){

        @Override
        public Iterable<Long> getValues(UploadFile file, QueryOptions queryOptions) {
            return Arrays.asList(file.nanotimes);
        }
    };
    public static final Attribute<UploadFile, Long> VALUE_ID = new MultiValueAttribute<UploadFile, Long>("valueIds"){

        @Override
        public Iterable<Long> getValues(UploadFile file, QueryOptions queryOptions) {
            return Arrays.asList(file.valueIds);
        }
    };
    protected static final int MASHALLABLE_VERSION = 1;
    private final long timeStart = System.currentTimeMillis();
    public String path;
    public long threadId;
    public BloomFilter<Long> valueIdBloomFilter;
    public BloomFilter<Integer> probeIdBloomFilter;
    protected String sessionId;
    protected String id;
    protected Integer[] probeIds;
    protected Long[] nanotimes;
    protected Long[] valueIds;
    private long timeEnd = System.currentTimeMillis();

    public UploadFile(String pathToFile, long threadId, BloomFilter<Long> valueIdBloomFilter, BloomFilter<Integer> probeIdBloomFilter) {
        this.path = pathToFile;
        this.threadId = threadId;
        this.valueIdBloomFilter = valueIdBloomFilter;
        this.probeIdBloomFilter = probeIdBloomFilter;
    }

    public static UploadFile fromBytes(byte[] bytes) {
        ByteBuffer byteReader = ByteBuffer.wrap(bytes);
        String path = BloomFilterUtil.getNextString(byteReader);
        long threadId = byteReader.getLong();
        byte[] valueBytes = BloomFilterUtil.getNextBytes(byteReader);
        byte[] probeBytes = BloomFilterUtil.getNextBytes(byteReader);
        return new UploadFile(path, threadId, null, null);
    }

    public void setTimeEnd(long timeEnd) {
        this.timeEnd = timeEnd;
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(4 + this.path.length() + 8 + 4 + 0 + 4 + 0);
        buffer.putInt(this.path.length());
        buffer.put(this.path.getBytes());
        buffer.putLong(this.threadId);
        if (this.valueIdBloomFilter != null) {
            byte[] valueBytes = BloomFilterConverter.toJson(this.valueIdBloomFilter).toString().getBytes();
            buffer.putInt(valueBytes.length);
            buffer.put(valueBytes);
        } else {
            buffer.putInt(0);
        }
        if (this.probeIdBloomFilter != null) {
            byte[] probeBytes = BloomFilterConverter.toJson(this.probeIdBloomFilter).toString().getBytes();
            buffer.putInt(probeBytes.length);
            buffer.put(probeBytes);
        } else {
            buffer.putInt(0);
        }
        return buffer.array();
    }

    @Override
    public void writeMarshallable(BytesOut out) {
        super.writeMarshallable(out);
        out.writeStopBit(1L);
        out.write(this.toBytes());
    }

    @Override
    public void readMarshallable(BytesIn in) {
        super.readMarshallable(in);
        int version = (int)in.readStopBit();
        if (version == 1) {
            byte[] bytes = in.toByteArray();
            this.copyFrom(UploadFile.fromBytes(bytes));
        }
    }

    @Override
    public void writeMarshallable(WireOut out) {
        super.writeMarshallable(out);
        out.write("bytes").bytes(this.toBytes());
    }

    @Override
    public void readMarshallable(WireIn in) {
        super.readMarshallable(in);
        byte[] bytes = in.read("bytes").bytes();
        UploadFile uf = UploadFile.fromBytes(bytes);
        this.copyFrom(uf);
    }

    protected void copyFrom(UploadFile that) {
        this.path = that.path;
        this.threadId = that.threadId;
        this.valueIdBloomFilter = that.valueIdBloomFilter;
        this.probeIdBloomFilter = that.probeIdBloomFilter;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public BloomFilter<Long> getValueIdBloomFilter() {
        return this.valueIdBloomFilter;
    }

    public void setValueIdBloomFilter(BloomFilter<Long> valueIdBloomFilter) {
        this.valueIdBloomFilter = valueIdBloomFilter;
    }

    public BloomFilter<Integer> getProbeIdBloomFilter() {
        return this.probeIdBloomFilter;
    }

    public void setProbeIdBloomFilter(BloomFilter<Integer> probeIdBloomFilter) {
        this.probeIdBloomFilter = probeIdBloomFilter;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer[] getProbeIds() {
        return this.probeIds;
    }

    public void setProbeIds(Integer[] probeIds) {
        this.probeIds = probeIds;
    }

    public Long[] getNanotimes() {
        return this.nanotimes;
    }

    public void setNanotimes(Long[] nanotimes) {
        this.nanotimes = nanotimes;
    }

    public Long[] getValueIds() {
        return this.valueIds;
    }

    public void setValueIds(Long[] valueIds) {
        this.valueIds = valueIds;
    }
}

