/*
 * Decompiled with CFR 0.152.
 */
package com.insidious.common.parser;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStream;
import io.kaitai.struct.KaitaiStruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class KaitaiInsidiousEventParser
extends KaitaiStruct {
    private Event event;
    private KaitaiInsidiousEventParser _root;
    private KaitaiStruct _parent;

    public static KaitaiInsidiousEventParser fromFile(String fileName) throws IOException {
        return new KaitaiInsidiousEventParser(new ByteBufferKaitaiStream(fileName));
    }

    public KaitaiInsidiousEventParser(KaitaiStream _io) {
        this(_io, null, null);
    }

    public KaitaiInsidiousEventParser(KaitaiStream _io, KaitaiStruct _parent) {
        this(_io, _parent, null);
    }

    public KaitaiInsidiousEventParser(KaitaiStream _io, KaitaiStruct _parent, KaitaiInsidiousEventParser _root) {
        super(_io);
        this._parent = _parent;
        this._root = _root == null ? this : _root;
        this._read();
    }

    private void _read() {
        this.event = new Event(this._io, this, this._root);
    }

    public Event event() {
        return this.event;
    }

    public KaitaiInsidiousEventParser _root() {
        return this._root;
    }

    @Override
    public KaitaiStruct _parent() {
        return this._parent;
    }

    public static class DetailedEventBlock
    extends KaitaiStruct {
        private long eventId;
        private long timestamp;
        private int probeId;
        private long valueId;
        private long lenSerializedData;
        private byte[] serializedData;
        private KaitaiInsidiousEventParser _root;
        private Block _parent;

        public static DetailedEventBlock fromFile(String fileName) throws IOException {
            return new DetailedEventBlock(new ByteBufferKaitaiStream(fileName));
        }

        public DetailedEventBlock(KaitaiStream _io) {
            this(_io, null, null);
        }

        public DetailedEventBlock(KaitaiStream _io, Block _parent) {
            this(_io, _parent, null);
        }

        public DetailedEventBlock(KaitaiStream _io, Block _parent, KaitaiInsidiousEventParser _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.eventId = this._io.readU8be();
            this.timestamp = this._io.readU8be();
            this.probeId = this._io.readS4be();
            this.valueId = this._io.readU8be();
            this.lenSerializedData = this._io.readU4be();
            this.serializedData = this._io.readBytes(this.lenSerializedData());
        }

        public long eventId() {
            return this.eventId;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public int probeId() {
            return this.probeId;
        }

        public long valueId() {
            return this.valueId;
        }

        public long lenSerializedData() {
            return this.lenSerializedData;
        }

        public byte[] serializedData() {
            return this.serializedData;
        }

        public KaitaiInsidiousEventParser _root() {
            return this._root;
        }

        @Override
        public Block _parent() {
            return this._parent;
        }
    }

    public static class Block
    extends KaitaiStruct {
        private byte[] magic;
        private DetailedEventBlock block;
        private KaitaiInsidiousEventParser _root;
        private Event _parent;

        public static Block fromFile(String fileName) throws IOException {
            return new Block(new ByteBufferKaitaiStream(fileName));
        }

        public Block(KaitaiStream _io) {
            this(_io, null, null);
        }

        public Block(KaitaiStream _io, Event _parent) {
            this(_io, _parent, null);
        }

        public Block(KaitaiStream _io, Event _parent, KaitaiInsidiousEventParser _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.magic = this._io.readBytes(1L);
            if (!Arrays.equals(this.magic(), new byte[]{7})) {
                throw new KaitaiStream.ValidationNotEqualError(new byte[]{7}, this.magic(), this._io(), "/types/block/seq/0");
            }
            this.block = new DetailedEventBlock(this._io, this, this._root);
        }

        public byte[] magic() {
            return this.magic;
        }

        public DetailedEventBlock block() {
            return this.block;
        }

        public KaitaiInsidiousEventParser _root() {
            return this._root;
        }

        @Override
        public Event _parent() {
            return this._parent;
        }

        public static enum Identifier {
            DETAILED_EVENT_INFORMATION(7L);

            private final long id;
            private static final Map<Long, Identifier> byId;

            private Identifier(long id) {
                this.id = id;
            }

            public long id() {
                return this.id;
            }

            public static Identifier byId(long id) {
                return byId.get(id);
            }

            static {
                byId = new HashMap<Long, Identifier>(1);
                for (Identifier e : Identifier.values()) {
                    byId.put(e.id(), e);
                }
            }
        }
    }

    public static class Event
    extends KaitaiStruct {
        private ArrayList<Block> entries;
        private KaitaiInsidiousEventParser _root;
        private KaitaiInsidiousEventParser _parent;

        public static Event fromFile(String fileName) throws IOException {
            return new Event(new ByteBufferKaitaiStream(fileName));
        }

        public Event(KaitaiStream _io) {
            this(_io, null, null);
        }

        public Event(KaitaiStream _io, KaitaiInsidiousEventParser _parent) {
            this(_io, _parent, null);
        }

        public Event(KaitaiStream _io, KaitaiInsidiousEventParser _parent, KaitaiInsidiousEventParser _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.entries = new ArrayList();
            int i = 0;
            while (!this._io.isEof()) {
                this.entries.add(new Block(this._io, this, this._root));
                ++i;
            }
        }

        public ArrayList<Block> entries() {
            return this.entries;
        }

        public KaitaiInsidiousEventParser _root() {
            return this._root;
        }

        @Override
        public KaitaiInsidiousEventParser _parent() {
            return this._parent;
        }
    }
}

