/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Collections;
import java.util.List;

public class CollectionsSingletonListSerializer
extends Serializer<List<?>> {
    @Override
    public List<?> read(Kryo kryo, Input input, Class<? extends List<?>> type2) {
        Object obj = kryo.readClassAndObject(input);
        return Collections.singletonList(obj);
    }

    @Override
    public void write(Kryo kryo, Output output, List<?> list) {
        kryo.writeClassAndObject(output, list.get(0));
    }

    @Override
    public List<?> copy(Kryo kryo, List<?> original) {
        Object singleton = original.get(0);
        kryo.reference(singleton);
        Object newSingleton = kryo.copy(singleton);
        return Collections.singletonList(newSingleton);
    }
}

