/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.Map;

public class EnumMapSerializer
extends Serializer<EnumMap<? extends Enum<?>, ?>> {
    private static final Field TYPE_FIELD;
    private static final Object FAKE_REFERENCE;

    @Override
    public EnumMap<? extends Enum<?>, ?> copy(Kryo kryo, EnumMap<? extends Enum<?>, ?> original) {
        EnumMap copy2 = new EnumMap(original);
        for (Map.Entry<Enum<?>, ?> entry : original.entrySet()) {
            copy2.put(entry.getKey(), kryo.copy(entry.getValue()));
        }
        return copy2;
    }

    private EnumMap<? extends Enum<?>, ?> create(Kryo kryo, Input input, Class<? extends EnumMap<? extends Enum<?>, ?>> type2) {
        Class keyType = kryo.readClass(input).getType();
        return new EnumMap(keyType);
    }

    @Override
    public EnumMap<? extends Enum<?>, ?> read(Kryo kryo, Input input, Class<? extends EnumMap<? extends Enum<?>, ?>> type2) {
        kryo.reference(FAKE_REFERENCE);
        EnumMap<Enum<?>, ?> result2 = this.create(kryo, input, type2);
        Class<Enum<?>> keyType = this.getKeyType(result2);
        Enum<?>[] enumConstants = keyType.getEnumConstants();
        EnumMap<Enum<?>, ?> rawResult = result2;
        int size = input.readInt(true);
        for (int i = 0; i < size; ++i) {
            int ordinal = input.readVarInt(true);
            Enum<?> key = enumConstants[ordinal];
            Object value = kryo.readClassAndObject(input);
            rawResult.put(key, value);
        }
        return result2;
    }

    @Override
    public void write(Kryo kryo, Output output, EnumMap<? extends Enum<?>, ?> map) {
        kryo.writeClass(output, this.getKeyType(map));
        output.writeInt(map.size(), true);
        for (Map.Entry<Enum<?>, ?> entry : map.entrySet()) {
            output.writeVarInt(entry.getKey().ordinal(), true);
            kryo.writeClassAndObject(output, entry.getValue());
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote EnumMap: " + map);
        }
    }

    private Class<Enum<?>> getKeyType(EnumMap<?, ?> map) {
        try {
            return (Class)TYPE_FIELD.get(map);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not access keys field.", e);
        }
    }

    static {
        try {
            TYPE_FIELD = EnumMap.class.getDeclaredField("keyType");
            TYPE_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("The EnumMap class seems to have changed, could not access expected field.", e);
        }
        FAKE_REFERENCE = new Object();
    }
}

